/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.beans.Selectable;
import com.spacekiller.util.beans.Selection;
import com.spacekiller.util.workbench.FileTreeView;
import com.spacekiller.util.workbench.FileViewer;
import com.spacekiller.util.workbench.Workbench;
import com.spacekiller.util.workbench.WorkbenchExtensions;
import com.spacekiller.util.workbench.WorkbenchUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class FileExplorer
extends JPanel
implements Selectable {
    private static final long serialVersionUID = -7120279567751636284L;
    private FileTreeView fileTreeView;
    private FileViewer fileViewer;
    private File directory;
    private boolean adjustingDirectory = false;
    private boolean adjustingFileTree = false;
    private ArrayList history;
    private int historyIndex;
    private int maxHistorySize = 1024;
    private FileViewerActionHandler fileViewerActionHandler = new FileViewerActionHandler();
    private JPanel jPanelAddress = null;
    private JLabel jLabel = null;
    private JTextField jTextFieldAddress = null;
    private JButton jButtonGo = null;
    private JPanel jPanelContent = null;
    private JPanel jPanelTools = null;
    private JToolBar jToolBar = null;
    private JButton jButtonBack = null;
    private JButton jButtonForward = null;
    private JButton jButtonFolders = null;
    private JButton jButtonSearch = null;
    private JPanel jPanel = null;
    private JButton jButtonParent = null;
    private static final Logger logger = Logger.getLogger(FileExplorer.class.getName());

    public FileExplorer() {
        this.initialize();
        this.initFileExplorer();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.fill = 2;
        gridBagConstraints11.gridy = -1;
        gridBagConstraints11.gridx = -1;
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.fill = 1;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.weighty = 1.0;
        gridBagConstraints4.gridy = 2;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridy = 1;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(434, 307));
        this.add((Component)this.getJPanelAddress(), gridBagConstraints);
        this.add((Component)this.getJPanelContent(), gridBagConstraints4);
        this.add((Component)this.getJPanelTools(), gridBagConstraints11);
    }

    private JPanel getJPanelAddress() {
        if (this.jPanelAddress == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 2;
            gridBagConstraints3.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints3.gridy = 2;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets = new Insets(0, 2, 0, 2);
            gridBagConstraints2.gridy = 2;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.gridy = 2;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.insets = new Insets(2, 0, 2, 0);
            gridBagConstraints1.gridx = 1;
            this.jLabel = new JLabel();
            this.jLabel.setText("Address");
            this.jLabel.setFont(new Font("Dialog", 0, 12));
            this.jPanelAddress = new JPanel();
            this.jPanelAddress.setLayout(new GridBagLayout());
            this.jPanelAddress.setOpaque(false);
            this.jPanelAddress.setBorder(BorderFactory.createEtchedBorder(0));
            this.jPanelAddress.add((Component)this.jLabel, gridBagConstraints2);
            this.jPanelAddress.add((Component)this.getJTextFieldAddress(), gridBagConstraints1);
            this.jPanelAddress.add((Component)this.getJButtonGo(), gridBagConstraints3);
        }
        return this.jPanelAddress;
    }

    private JTextField getJTextFieldAddress() {
        if (this.jTextFieldAddress == null) {
            this.jTextFieldAddress = new JTextField();
            this.jTextFieldAddress.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FileExplorer.this.actionAddressGo();
                }
            });
        }
        return this.jTextFieldAddress;
    }

    private JButton getJButtonGo() {
        if (this.jButtonGo == null) {
            this.jButtonGo = new JButton();
            this.jButtonGo.setToolTipText("Go to specified location");
            this.jButtonGo.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/workbench/icons/commit_trans.gif")));
            this.jButtonGo.setMargin(new Insets(0, 0, 0, 0));
            this.jButtonGo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FileExplorer.this.actionAddressGo();
                }
            });
        }
        return this.jButtonGo;
    }

    private JPanel getJPanelContent() {
        if (this.jPanelContent == null) {
            GridLayout gridLayout1 = new GridLayout();
            gridLayout1.setRows(1);
            this.jPanelContent = new JPanel();
            this.jPanelContent.setLayout(gridLayout1);
            this.jPanelContent.setOpaque(false);
        }
        return this.jPanelContent;
    }

    private JPanel getJPanelTools() {
        if (this.jPanelTools == null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(1);
            this.jPanelTools = new JPanel();
            this.jPanelTools.setLayout(gridLayout);
            this.jPanelTools.setOpaque(false);
            this.jPanelTools.add((Component)this.getJToolBar(), null);
        }
        return this.jPanelTools;
    }

    private JToolBar getJToolBar() {
        if (this.jToolBar == null) {
            this.jToolBar = new JToolBar();
            this.jToolBar.setFloatable(false);
            this.jToolBar.add(this.getJButtonBack());
            this.jToolBar.add(this.getJButtonForward());
            this.jToolBar.add(this.getJButtonParent());
            this.jToolBar.add(this.getJPanel());
            this.jToolBar.add(this.getJButtonSearch());
            this.jToolBar.add(this.getJButtonFolders());
        }
        return this.jToolBar;
    }

    private JButton getJButtonBack() {
        if (this.jButtonBack == null) {
            this.jButtonBack = new JButton();
            this.jButtonBack.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/workbench/icons/nav_back.gif")));
            this.jButtonBack.setOpaque(false);
            this.jButtonBack.setMargin(new Insets(0, 0, 0, 0));
            this.jButtonBack.setToolTipText("Back..");
            this.jButtonBack.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FileExplorer.this.actionBack();
                }
            });
        }
        return this.jButtonBack;
    }

    private JButton getJButtonForward() {
        if (this.jButtonForward == null) {
            this.jButtonForward = new JButton();
            this.jButtonForward.setToolTipText("Forward..");
            this.jButtonForward.setOpaque(false);
            this.jButtonForward.setMargin(new Insets(0, 0, 0, 0));
            this.jButtonForward.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/workbench/icons/nav_forward.gif")));
            this.jButtonForward.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FileExplorer.this.actionForward();
                }
            });
        }
        return this.jButtonForward;
    }

    private JButton getJButtonFolders() {
        if (this.jButtonFolders == null) {
            this.jButtonFolders = new JButton();
            this.jButtonFolders.setToolTipText("Folders..");
            this.jButtonFolders.setOpaque(false);
            this.jButtonFolders.setMargin(new Insets(0, 0, 0, 0));
            this.jButtonFolders.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/workbench/icons/nav_folders.gif")));
            this.jButtonFolders.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FileExplorer.this.actionFolders();
                }
            });
        }
        return this.jButtonFolders;
    }

    private JButton getJButtonSearch() {
        if (this.jButtonSearch == null) {
            this.jButtonSearch = new JButton();
            this.jButtonSearch.setToolTipText("Search..");
            this.jButtonSearch.setOpaque(false);
            this.jButtonSearch.setMargin(new Insets(0, 0, 0, 0));
            this.jButtonSearch.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/workbench/icons/nav_search.gif")));
            this.jButtonSearch.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FileExplorer.this.actionSearch();
                }
            });
        }
        return this.jButtonSearch;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setMaximumSize(new Dimension(8, 8));
            this.jPanel.setOpaque(false);
            this.jPanel.setMinimumSize(new Dimension(8, 8));
        }
        return this.jPanel;
    }

    protected void initFileExplorer() {
        this.history = new ArrayList();
        this.historyIndex = -1;
        this.getJButtonBack().setEnabled(false);
        this.getJButtonForward().setEnabled(false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FileExplorer.this.getJTextFieldAddress().requestFocus();
            }
        });
    }

    public FileViewer getFileViewer() {
        return this.fileViewer;
    }

    public void setFileViewer(FileViewer newFileViewer) {
        if (this.fileViewer != newFileViewer) {
            if (this.fileViewer != null) {
                this.fileViewer.removeActionListener(this.fileViewerActionHandler);
            }
            this.fileViewer = newFileViewer;
            if (this.fileViewer != null) {
                this.fileViewer.addActionListener(this.fileViewerActionHandler);
            }
        }
        this.refreshViewers();
    }

    protected synchronized void refreshViewers() {
        Component comp;
        this.getJPanelContent().removeAll();
        Component leftComp = null;
        Component rightComp = null;
        if (this.fileViewer != null && (comp = this.fileViewer.getComponent()) != null) {
            rightComp = comp;
        }
        if (this.fileTreeView != null && (comp = this.fileTreeView.getComponent()) != null) {
            leftComp = comp;
        }
        if (leftComp != null) {
            if (rightComp != null) {
                JSplitPane split = new JSplitPane();
                split.setOpaque(false);
                split.setLeftComponent(leftComp);
                split.setRightComponent(rightComp);
                this.getJPanelContent().add(split);
            } else {
                this.getJPanelContent().add(leftComp);
            }
        } else if (rightComp != null) {
            this.getJPanelContent().add(rightComp);
        }
        this.getJPanelContent().validate();
        this.getJPanelContent().repaint();
    }

    protected void actionBack() {
        if (this.historyIndex < 1) {
            return;
        }
        --this.historyIndex;
        File dir = (File)this.history.get(this.historyIndex);
        this.handleHistoryChanged();
        this.setDirectory(dir);
    }

    protected void actionForward() {
        int num = this.history.size();
        if (this.historyIndex + 1 >= num) {
            return;
        }
        ++this.historyIndex;
        File dir = (File)this.history.get(this.historyIndex);
        this.handleHistoryChanged();
        this.setDirectory(dir);
    }

    protected void actionSearch() {
    }

    protected void actionFolders() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void actionAddressGo() {
        try {
            this.adjustingDirectory = true;
            String path = this.getJTextFieldAddress().getText();
            File dir = null;
            if (path != null && path.length() > 0) {
                dir = new File(path);
            }
            this.setDirectory(dir);
            this.refreshFileTree();
            this.refreshFileViewer();
        }
        finally {
            this.adjustingDirectory = false;
        }
    }

    protected void actionParent() {
        File parent;
        File dir = this.getDirectory();
        if (dir != null && (parent = dir.getParentFile()) != null) {
            this.setDirectory(parent);
        }
    }

    public FileTreeView getFileTreeView() {
        return this.fileTreeView;
    }

    public void setFileTreeView(FileTreeView fileTreeView) {
        this.fileTreeView = fileTreeView;
        this.refreshViewers();
    }

    private JButton getJButtonParent() {
        if (this.jButtonParent == null) {
            this.jButtonParent = new JButton();
            this.jButtonParent.setOpaque(false);
            this.jButtonParent.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/workbench/icons/nav_parent.gif")));
            this.jButtonParent.setMargin(new Insets(0, 0, 0, 0));
            this.jButtonParent.setToolTipText("Up..");
            this.jButtonParent.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FileExplorer.this.actionParent();
                }
            });
        }
        return this.jButtonParent;
    }

    public File getDirectory() {
        return this.directory;
    }

    public synchronized void setDirectory(File directory) {
        if (directory != null) {
            directory = FileExplorer.getAbsoluteFile(directory);
        }
        this.directory = directory;
        if (directory != null) {
            boolean addHist = true;
            if (this.historyIndex >= 0) {
                File curr = (File)this.history.get(this.historyIndex);
                boolean bl = addHist = !directory.equals(curr);
            }
            if (addHist) {
                ++this.historyIndex;
                int num = this.history.size();
                for (int i = num - 1; i >= this.historyIndex; --i) {
                    this.history.remove(i);
                }
                this.history.add(directory);
                if (this.historyIndex + 1 > this.maxHistorySize) {
                    this.history.remove(0);
                    --this.historyIndex;
                }
                this.handleHistoryChanged();
            }
        }
        File parentDir = null;
        if (directory != null) {
            parentDir = directory.getParentFile();
        }
        this.getJButtonParent().setEnabled(parentDir != null);
        if (this.adjustingDirectory) {
            return;
        }
        if (directory != null) {
            String path = directory.getAbsolutePath();
            this.getJTextFieldAddress().setText(path);
            this.actionAddressGo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshFileTree() {
        if (this.adjustingFileTree) {
            return;
        }
        try {
            this.adjustingFileTree = true;
            File dir = this.getDirectory();
            FileTreeView tv = this.getFileTreeView();
            if (tv != null) {
                tv.setSelectedFile(dir);
            }
        }
        finally {
            this.adjustingFileTree = false;
        }
    }

    protected void refreshFileViewer() {
        FileViewer fv = this.getFileViewer();
        if (fv == null) {
            return;
        }
        File dir = this.getDirectory();
        File[] files = null;
        files = dir != null ? dir.listFiles() : new File[]{};
        fv.setFiles(files);
    }

    public Selection getSelection() {
        return this.getFileViewer().getSelection();
    }

    public static final File getAbsoluteFile(File f) {
        for (f = f.getAbsoluteFile(); f != null && f.getName().equals("."); f = f.getParentFile()) {
        }
        return f;
    }

    protected void actionOpenSelectedObjects() {
        File f;
        Object o;
        Workbench wb = WorkbenchUtilities.getWorkbench(this);
        if (wb == null) {
            return;
        }
        FileViewer fv = this.getFileViewer();
        if (fv == null) {
            return;
        }
        Selection sel = fv.getSelection();
        if (sel == null) {
            return;
        }
        ArrayList dst = new ArrayList();
        sel.getSelectedObjects(dst);
        if (dst.isEmpty()) {
            return;
        }
        int size = dst.size();
        if (size == 1 && (o = dst.get(0)) != null && o instanceof File && (f = (File)o).isDirectory()) {
            this.setDirectory(f);
            return;
        }
        try {
            WorkbenchExtensions.actionObjectOpen(wb, dst);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void handleException(Throwable e) {
        logger.log(Level.SEVERE, e.getMessage(), e);
    }

    protected void handleHistoryChanged() {
        this.getJButtonBack().setEnabled(this.historyIndex > 0);
        this.getJButtonForward().setEnabled(this.historyIndex < this.history.size() - 1);
    }

    protected class FileViewerActionHandler
    implements ActionListener {
        protected FileViewerActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileExplorer.this.actionOpenSelectedObjects();
        }
    }
}

