/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.Tools;
import com.spacekiller.util.swing.TransListCellRenderer;
import com.spacekiller.util.workspace.ProjectReference;
import com.spacekiller.util.workspace.ProjectType;
import com.spacekiller.util.workspace.SyncManager;
import com.spacekiller.util.workspace.Workspace;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class LoadProjectDialog
extends JPanel {
    private static final long serialVersionUID = 6655891134023071293L;
    private JDialog dialog;
    private Workspace workspace;
    private boolean confirmed = false;
    private JScrollPane jScrollPane = null;
    private JList jListProject = null;
    private JPanel jPanel = null;
    private JButton jButtonLoad = null;
    private JButton jButton1 = null;
    private DefaultListModel projectListModel;
    private ProjectReference[] selectedProjects;
    private static final Logger logger = Logger.getLogger(LoadProjectDialog.class.getName());

    public LoadProjectDialog() {
        this.initialize();
        this.initDialog();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        JLabel jLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setSize(404, 284);
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.insets = new Insets(4, 4, 4, 4);
        jLabel.setText("Available Projects:");
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(0, 4, 0, 4);
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 3;
        gridBagConstraints3.anchor = 13;
        this.add((Component)jLabel, gridBagConstraints1);
        this.add((Component)this.getJScrollPane(), gridBagConstraints2);
        this.add((Component)this.getJPanel(), gridBagConstraints3);
    }

    public boolean showDialog() {
        if (this.workspace == null) {
            throw new NullPointerException("workspace");
        }
        this.refreshAvailableProjects();
        JDialog dlg = this.getDialog();
        this.setConfirmed(false);
        dlg.setSize(200, 300);
        Tools.centerWindow((Window)dlg);
        dlg.setModal(true);
        dlg.setVisible(true);
        return this.isConfirmed();
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    private void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    public JDialog getDialog() {
        if (this.dialog == null) {
            JFrame frame = new JFrame();
            try {
                frame.setIconImage(Tools.createImage((Component)frame, this.getClass(), (String)"/com/spacekiller/util/workbench/icons/loadproject.gif"));
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            this.dialog = new JDialog(frame);
            this.dialog.setTitle("Load Project(s)");
            this.dialog.setContentPane(this);
            this.dialog.setSize(213, 99);
        }
        return this.dialog;
    }

    void setDialog(JDialog dialog) {
        this.dialog = dialog;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJListProject());
        }
        return this.jScrollPane;
    }

    private JList getJListProject() {
        if (this.jListProject == null) {
            this.jListProject = new JList();
            this.jListProject.setOpaque(false);
            this.jListProject.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    LoadProjectDialog.this.checkEnable();
                }
            });
        }
        return this.jListProject;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            gridBagConstraints4.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints5.insets = new Insets(4, 0, 4, 4);
            this.jPanel.add((Component)this.getJButtonLoad(), gridBagConstraints4);
            this.jPanel.add((Component)this.getJButton1(), gridBagConstraints5);
        }
        return this.jPanel;
    }

    private JButton getJButtonLoad() {
        if (this.jButtonLoad == null) {
            this.jButtonLoad = new JButton();
            this.jButtonLoad.setText("Load");
            this.jButtonLoad.setMargin(new Insets(2, 4, 2, 4));
            this.jButtonLoad.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/workbench/icons/loadproject.gif")));
            this.jButtonLoad.setEnabled(false);
            this.jButtonLoad.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoadProjectDialog.this.setConfirmed(true);
                    LoadProjectDialog.this.dialog.dispose();
                }
            });
        }
        return this.jButtonLoad;
    }

    private JButton getJButton1() {
        if (this.jButton1 == null) {
            this.jButton1 = new JButton();
            this.jButton1.setText("Cancel");
            this.jButton1.setMargin(new Insets(2, 4, 2, 4));
            this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/workbench/icons/cancel.gif")));
            this.jButton1.setFont(new Font("Dialog", 0, 12));
            this.jButton1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoadProjectDialog.this.setConfirmed(false);
                    LoadProjectDialog.this.dialog.dispose();
                }
            });
        }
        return this.jButton1;
    }

    protected DefaultListModel getProjectSourceListModel() {
        return this.projectListModel;
    }

    void setProjectSourceListModel(DefaultListModel projectSourceListModel) {
        this.projectListModel = projectSourceListModel;
    }

    protected void refreshAvailableProjects() {
        this.projectListModel.removeAllElements();
        try {
            logger.fine("getting available projects..");
            SyncManager sync = this.workspace.getSyncManager();
            TreeSet<ProjectReference> refs = new TreeSet<ProjectReference>(new ProjectReferenceComparator());
            Iterator it = sync.getProjectReferences();
            while (it.hasNext()) {
                ProjectReference ref = (ProjectReference)it.next();
                if (ref == null) continue;
                refs.add(ref);
            }
            Iterator i = refs.iterator();
            while (i.hasNext()) {
                this.projectListModel.addElement((ProjectReference)i.next());
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void handleException(Throwable e) {
        logger.log(Level.SEVERE, "" + e, e);
    }

    private void initDialog() {
        this.projectListModel = new DefaultListModel();
        this.getJListProject().setCellRenderer(new ProjectListCellRenderer());
        this.getJListProject().setModel(this.projectListModel);
    }

    protected void checkEnable() {
        int[] sel = this.getJListProject().getSelectedIndices();
        int num = sel.length;
        ProjectReference[] array = new ProjectReference[num];
        for (int c = 0; c < num; ++c) {
            array[c] = (ProjectReference)this.projectListModel.get(sel[c]);
        }
        this.setSelectedProjects(array);
        this.getJButtonLoad().setEnabled(num > 0);
    }

    public ProjectReference[] getSelectedProjects() {
        return this.selectedProjects;
    }

    protected void setSelectedProjects(ProjectReference[] selectedProjects) {
        this.selectedProjects = selectedProjects;
    }

    public class ProjectListCellRenderer
    extends TransListCellRenderer {
        private static final long serialVersionUID = -5801739088937159186L;

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Object o = value;
            Component rc = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (o != null && o instanceof ProjectReference) {
                ProjectReference info = (ProjectReference)o;
                String projectName = info.getProjectName();
                String projectTypeName = info.getProjectTypeName();
                Workspace ws = LoadProjectDialog.this.getWorkspace();
                ProjectType projectType = null;
                if (ws != null) {
                    projectType = ws.getProjectType(projectTypeName);
                }
                this.setText(String.valueOf(projectName));
                Icon icon = projectType == null ? null : projectType.getIcon();
                this.setIcon(icon);
                String tooltip = projectType == null ? null : projectType.getTitle();
                this.setToolTipText(tooltip);
            }
            return rc;
        }
    }

    public static class ProjectReferenceComparator
    implements Comparator {
        public int compare(Object a, Object b) {
            if (a == b) {
                return 0;
            }
            ProjectReference ra = (ProjectReference)a;
            ProjectReference rb = (ProjectReference)b;
            String na = ra.getProjectName();
            String nb = rb.getProjectName();
            if (na == null) {
                return -1;
            }
            if (nb == null) {
                return 1;
            }
            int rc = na.compareTo(nb);
            if (rc != 0) {
                return rc;
            }
            rc = ra.getProjectClassName().compareTo(rb.getProjectClassName());
            if (rc != 0) {
                return rc;
            }
            rc = ra.getProjectPath().toString().compareTo(rb.getProjectPath().toString());
            return rc;
        }
    }
}

