/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.beans.BeanDropSupport;
import com.spacekiller.util.beans.model.BeanTreeComparator;
import com.spacekiller.util.beans.model.DefaultBeanTreeComparator;
import com.spacekiller.util.tooling.ToolGroup;
import com.spacekiller.util.workbench.DefaultViewProvider;
import com.spacekiller.util.workbench.ProjectTreeView;
import com.spacekiller.util.workbench.View;
import com.spacekiller.util.workbench.WorkbenchExtensions;
import com.spacekiller.util.workbench.WorkbenchUtilities;
import com.spacekiller.util.workspace.WorkspacePlugin;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProjectTreeViewProvider
extends DefaultViewProvider {
    private ToolGroup toolbarGroup;
    private ToolGroup contextMenuGroup;
    private static final Logger logger = Logger.getLogger(ProjectTreeViewProvider.class.getName());

    @Override
    protected void initView(View v) {
        super.initView(v);
        if (v instanceof ProjectTreeView) {
            ProjectTreeView pv = (ProjectTreeView)v;
            try {
                WorkspacePlugin wsPlugin = WorkbenchUtilities.getWorkspacePlugin();
                logger.fine("WorkspacePlugin: " + wsPlugin);
                BeansToolkit btk = wsPlugin.getBeansToolkit();
                logger.fine("BeansToolkit: " + btk);
                BeanDropSupport dropSupport = wsPlugin.getBeanDropSupport();
                logger.fine("BeanDropSupport: " + dropSupport);
                pv.setBeanDropSupport(dropSupport);
                pv.setBeansToolkit(btk);
                DefaultBeanTreeComparator beanTreeComparator = new DefaultBeanTreeComparator();
                WorkbenchExtensions.BeanComparatorIgnoreCase rootComp = new WorkbenchExtensions.BeanComparatorIgnoreCase();
                beanTreeComparator.setRootComparator((Comparator)rootComp);
                pv.setBeanTreeComparator((BeanTreeComparator)beanTreeComparator);
                WorkbenchExtensions.FeatureDescriptorFilter_OnlyBeans filter = new WorkbenchExtensions.FeatureDescriptorFilter_OnlyBeans();
                pv.setFeatureDescriptorFilter(filter);
                pv.setToolbarGroup(this.getToolbarGroup());
                pv.setPopupMenuToolGroup(this.getContextMenuGroup());
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public ToolGroup getContextMenuGroup() {
        return this.contextMenuGroup;
    }

    public void setContextMenuGroup(ToolGroup contextMenuGroup) {
        this.contextMenuGroup = contextMenuGroup;
    }

    public ToolGroup getToolbarGroup() {
        return this.toolbarGroup;
    }

    public void setToolbarGroup(ToolGroup toolbarGroup) {
        this.toolbarGroup = toolbarGroup;
    }
}

