/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.beans.AbstractProperty;
import com.spacekiller.util.beans.Selection;
import com.spacekiller.util.workspace.Project;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class SelectionCondition
extends AbstractProperty {
    private static final Logger logger = Logger.getLogger(SelectionCondition.class.getName());

    public SelectionCondition() {
        super(null);
        this.setValue(false);
    }

    protected abstract void selectionChanged(Selection var1);

    protected void setValue(boolean v) {
        try {
            this.setValue(v ? Boolean.TRUE : Boolean.FALSE);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public static class ProjectsSelected
    extends SelectionCondition {
        private boolean enabled = false;

        @Override
        protected void selectionChanged(Selection selection) {
            int num = selection == null ? 0 : selection.getSelectionCount();
            boolean enable = false;
            if (num > 0) {
                ArrayList list = new ArrayList();
                selection.getSelectedObjects(list);
                if (!list.isEmpty()) {
                    enable = true;
                    int n = list.size();
                    for (int c = 0; c < n; ++c) {
                        Object o = list.get(c);
                        if (o == null) {
                            enable = false;
                            continue;
                        }
                        if (o instanceof Project) continue;
                        enable = false;
                    }
                }
            }
            if (enable == this.enabled) {
                return;
            }
            this.enabled = enable;
            this.setValue(this.enabled);
        }
    }

    public static class ObjectsSelected
    extends SelectionCondition {
        private boolean enabled = false;

        @Override
        protected void selectionChanged(Selection selection) {
            boolean enable;
            int num = selection == null ? 0 : selection.getSelectionCount();
            boolean bl = enable = num > 0;
            if (enable == this.enabled) {
                return;
            }
            this.enabled = enable;
            this.setValue(this.enabled);
        }
    }

    public static class SingleObjectSelected
    extends SelectionCondition {
        private boolean enabled = false;

        @Override
        protected void selectionChanged(Selection selection) {
            boolean enable;
            int num = selection == null ? 0 : selection.getSelectionCount();
            boolean bl = enable = num == 1;
            if (enable == this.enabled) {
                return;
            }
            this.enabled = enable;
            this.setValue(this.enabled);
        }
    }

    public static class NothingSelected
    extends SelectionCondition {
        private boolean enabled = false;

        @Override
        protected void selectionChanged(Selection selection) {
            boolean enable;
            int num = selection == null ? 0 : selection.getSelectionCount();
            boolean bl = enable = num == 0;
            if (enable == this.enabled) {
                return;
            }
            this.enabled = enable;
            this.setValue(this.enabled);
        }
    }
}

