/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.beans.Selection;
import com.spacekiller.util.tooling.TAction;
import com.spacekiller.util.tooling.ToolContext;
import com.spacekiller.util.workbench.SelectionCondition;
import com.spacekiller.util.workbench.SelectionManager;
import com.spacekiller.util.workbench.SelectionToolContext;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;

public abstract class SelectionToolContextAction
extends TAction {
    private static final Logger logger = Logger.getLogger(SelectionToolContextAction.class.getName());

    public Object createInstance(ToolContext context, Class type) {
        SelectionToolContext stc;
        SelectionManager sm;
        Object instance = super.createInstance(context, type);
        if (instance == null) {
            return null;
        }
        if (context != null && context instanceof SelectionToolContext && (sm = (stc = (SelectionToolContext)context).getSelectionManager()) != null) {
            sm.addSelectionCondition(new SelectionConditionImpl(instance));
        }
        return instance;
    }

    public static abstract class PasteSupportedAction
    extends SelectionToolContextAction {
        protected void refreshInstance(Object c) {
            super.refreshInstance(c);
            if (!(c instanceof JComponent)) {
                return;
            }
            JComponent comp = (JComponent)c;
            boolean enable = false;
            try {
                Selection sel;
                SelectionToolContext stc;
                SelectionManager sm;
                ToolContext tc = this.getToolContext(c);
                if (tc != null && tc instanceof SelectionToolContext && (sm = (stc = (SelectionToolContext)tc).getSelectionManager()) != null && (sel = sm.getSelection()) != null) {
                    enable = sel.isPasteSupported();
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            comp.setEnabled(enable);
        }
    }

    public static abstract class ObjectsSelectedAction
    extends SelectionToolContextAction {
        protected void refreshInstance(Object c) {
            super.refreshInstance(c);
            if (!(c instanceof JComponent)) {
                return;
            }
            JComponent comp = (JComponent)c;
            boolean enable = false;
            try {
                Selection sel;
                SelectionToolContext stc;
                SelectionManager sm;
                ToolContext tc = this.getToolContext(c);
                if (tc != null && tc instanceof SelectionToolContext && (sm = (stc = (SelectionToolContext)tc).getSelectionManager()) != null && (sel = sm.getSelection()) != null) {
                    enable = sel.getSelectedObjectCount() > 0;
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            comp.setEnabled(enable);
        }
    }

    protected class SelectionConditionImpl
    extends SelectionCondition {
        private Object instance;

        public SelectionConditionImpl(Object instance) {
            this.instance = instance;
        }

        @Override
        protected void selectionChanged(Selection selection) {
            SelectionToolContextAction.this.refreshInstance(this.instance);
        }
    }
}

