/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.swing.ManagedTabbedPane;
import com.spacekiller.util.workbench.View;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;

public class TabbedView
extends View {
    private ManagedTabbedPane tabbedPane;
    private static final Logger logger = Logger.getLogger(TabbedView.class.getName());

    @Override
    public synchronized void addChild(View v) {
        this.insertChildAt(v, this.getChildCount());
    }

    @Override
    protected Component createComponent() {
        ManagedTabbedPane tabbedPane = this.getTabbedPane();
        tabbedPane.setMinimumSize(new Dimension(100, 100));
        return tabbedPane;
    }

    protected ManagedTabbedPane createTabbedPane() {
        final ManagedTabbedPane rc = new ManagedTabbedPane();
        rc.setOpaque(false);
        rc.setFont(new Font("dialog", 0, 10));
        rc.addCloseButtonActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                int tabIndex = rc.getCloseButtonTabIndex();
                if (tabIndex >= 0 && tabIndex < rc.getTabCount()) {
                    TabbedView.this.fireViewClosing(TabbedView.this.getChildAt(tabIndex));
                }
            }
        });
        return rc;
    }

    protected void fireViewClosing(View child) {
        logger.fine("PENDING: close");
    }

    protected Icon getChildIcon(View child, int index) {
        return child.getIcon();
    }

    protected String getChildTitle(View child, int index) {
        String title = String.valueOf(child.getTitle());
        int maxSize = 16;
        if (title.length() > maxSize) {
            title = title.substring(0, maxSize) + "..";
        }
        return title;
    }

    protected String getChildTooltip(View child, int index) {
        String rc = child.getTooltip();
        if (rc != null && rc.length() < 1) {
            rc = null;
        }
        return rc;
    }

    protected ManagedTabbedPane getTabbedPane() {
        if (this.tabbedPane == null) {
            this.setTabbedPane(this.createTabbedPane());
        }
        return this.tabbedPane;
    }

    @Override
    public synchronized void insertChildAt(View v, int i) {
        super.insertChildAt(v, i);
    }

    @Override
    protected synchronized void installChildComponent(View child, Component childComponent) {
        int tabIndex = this.getChildIndex(child);
        if (tabIndex < 0) {
            return;
        }
        boolean opaque = false;
        this.installTabComponent(child, childComponent, tabIndex, opaque);
    }

    protected synchronized void installTabComponent(View child, Component childComponent, int index, boolean opaque) {
        if (childComponent instanceof JComponent) {
            ((JComponent)childComponent).setOpaque(opaque);
        }
        String title = this.getChildTitle(child, index);
        String tip = this.getChildTooltip(child, index);
        Icon icon = this.getChildIcon(child, index);
        title = "" + title + "    ";
        this.getTabbedPane().insertTab(title, icon, childComponent, tip, index);
        this.getTabbedPane().setSelectedIndex(index);
    }

    @Override
    public synchronized void removeChild(View v) {
        super.removeChild(v);
    }

    @Override
    public synchronized void removeChildAt(int i) {
        this.removeChild(this.getChildAt(i));
    }

    protected void setTabbedPane(ManagedTabbedPane newTabbedPane) {
        this.tabbedPane = newTabbedPane;
    }

    @Override
    protected void uninstallChildComponent(View child, Component childComponent) {
        int tabIndex = this.getTabbedPane().indexOfComponent(childComponent);
        if (tabIndex >= 0) {
            this.uninstallTabComponent(tabIndex);
        }
    }

    protected synchronized void uninstallTabComponent(int index) {
        this.getTabbedPane().removeTabAt(index);
    }
}

