/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.tooling.AbstractToolGroup;
import com.spacekiller.util.tooling.TToolBar;
import com.spacekiller.util.tooling.Tool;
import com.spacekiller.util.tooling.ToolContext;
import com.spacekiller.util.tooling.ToolEvent;
import com.spacekiller.util.tooling.ToolListener;
import com.spacekiller.util.workbench.ToolView;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class ToolBarView
extends ToolView {
    private JPanel toolBarPanel;
    private Component toolBarComponent;
    private AbstractToolGroup toolBar;
    private ToolHandler toolHandler = new ToolHandler();

    @Override
    protected Component createComponent() {
        return this.getToolBarPanel();
    }

    @Override
    protected AbstractToolGroup createGroup() throws Exception {
        TToolBar rc = new TToolBar();
        rc.setName("ToolBar");
        rc.setTooltip("Tool bar");
        rc.addToolListener((ToolListener)this.toolHandler);
        return rc;
    }

    protected JToolBar createJToolBar() {
        ToolContext ctx = this.getToolContext();
        JToolBar rc = (JToolBar)this.getGroup().createInstance(ctx, JToolBar.class);
        return rc;
    }

    protected JPanel createToolBarPanel() {
        JPanel rc = new JPanel();
        rc.setLayout(new GridLayout(1, 1));
        this.toolBarComponent = this.createJToolBar();
        this.toolBar = this.getGroup();
        return rc;
    }

    protected JPanel getToolBarPanel() {
        if (this.toolBarPanel == null) {
            this.setToolBarPanel(this.createToolBarPanel());
            this.handleToolsChanged();
        }
        return this.toolBarPanel;
    }

    private void setToolBarPanel(JPanel toolBarPanel) {
        this.toolBarPanel = toolBarPanel;
    }

    protected void handleToolsChanged() {
        int count;
        JPanel panel = this.toolBarPanel;
        if (panel == null) {
            return;
        }
        AbstractToolGroup group = this.toolBar;
        int n = count = group == null ? 0 : group.getChildCount();
        if (panel.getComponentCount() > 0 ? count > 0 : count <= 0) {
            return;
        }
        panel.removeAll();
        if (count > 0 && this.toolBarComponent != null) {
            panel.add(this.toolBarComponent);
        }
        panel.validate();
        panel.repaint();
    }

    protected class ToolHandler
    implements ToolListener {
        protected ToolHandler() {
        }

        public void childrenAdded(ToolEvent ev) {
            ToolBarView.this.handleToolsChanged();
        }

        public void childrenRemoved(ToolEvent ev) {
            ToolBarView.this.handleToolsChanged();
        }

        public void toolChanged(Tool tool) {
            ToolBarView.this.handleToolsChanged();
        }
    }
}

