/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.beans.AbstractProperty;
import com.spacekiller.util.workspace.TransactionListener;
import com.spacekiller.util.workspace.TransactionSavepoint;
import com.spacekiller.util.workspace.Workspace;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class TransactionCondition
extends AbstractProperty {
    private Workspace workspace;
    private TransHandler transHandler = new TransHandler();
    private static final Logger logger = Logger.getLogger(TransactionCondition.class.getName());

    public TransactionCondition() {
        super(null);
        this.setValue(false);
    }

    protected void setValue(boolean v) {
        try {
            this.setValue(v ? Boolean.TRUE : Boolean.FALSE);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected abstract void handleTransactionChange();

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public synchronized void setWorkspace(Workspace newWorkspace) {
        if (this.workspace == newWorkspace) {
            return;
        }
        if (this.workspace != null) {
            this.workspace.removeTransactionListener((TransactionListener)this.transHandler);
        }
        this.workspace = newWorkspace;
        if (this.workspace != null) {
            this.workspace.addTransactionListener((TransactionListener)this.transHandler);
        }
        this.handleTransactionChange();
    }

    public static class RollbackCondition
    extends TransactionCondition {
        @Override
        protected void handleTransactionChange() {
            Workspace ws = this.getWorkspace();
            this.setValue(ws != null);
        }
    }

    public static class CommitCondition
    extends TransactionCondition {
        @Override
        protected void handleTransactionChange() {
            Workspace ws = this.getWorkspace();
            if (ws == null) {
                this.setValue(false);
            }
            this.setValue(!ws.isCommitted());
        }
    }

    protected class TransHandler
    implements TransactionListener {
        protected TransHandler() {
        }

        public void transactionBegin(TransactionSavepoint sp) {
            TransactionCondition.this.handleTransactionChange();
        }

        public void transactionCommit(TransactionSavepoint sp) {
            TransactionCondition.this.handleTransactionChange();
        }

        public void transactionRollback(TransactionSavepoint sp) {
            TransactionCondition.this.handleTransactionChange();
        }

        public void transactionSavepoint(TransactionSavepoint sp) {
            TransactionCondition.this.handleTransactionChange();
        }

        public void transactionRemoveSavepoint(TransactionSavepoint sp) {
            TransactionCondition.this.handleTransactionChange();
        }
    }
}

