/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.Editor;
import com.spacekiller.util.EditorContext;
import com.spacekiller.util.Platform;
import com.spacekiller.util.workbench.AbstractWorkbenchObject;
import com.spacekiller.util.workbench.Perspective;
import com.spacekiller.util.workbench.ViewConstraints;
import com.spacekiller.util.workbench.ViewEvent;
import com.spacekiller.util.workbench.ViewListener;
import com.spacekiller.util.workbench.ViewProvider;
import com.spacekiller.util.workbench.Workbench;
import java.awt.Component;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.event.EventListenerList;
import javax.swing.undo.UndoManager;

public abstract class View
extends AbstractWorkbenchObject
implements Editor {
    public static final String VIEW_LISTENER_LIST = View.class.getName() + "#viewListenerList";
    private ViewProvider provider;
    private View parent;
    private Vector children = new Vector();
    private Component viewComponent;
    private EventListenerList viewListenerList = new EventListenerList();
    private ViewConstraints viewConstraints;
    private boolean dirty;
    private EditorContext editorContext;
    private static final Logger logger = Logger.getLogger(View.class.getName());

    public View() {
        this.initAbstractView();
    }

    protected synchronized void addChild(View v) {
        this.insertChildAt(v, this.getChildCount());
    }

    protected abstract Component createComponent();

    protected synchronized void fireViewsInserted(ViewEvent ev) {
        Object[] l = this.viewListenerList.getListenerList();
        for (int i = l.length - 2; i >= 0; i -= 2) {
            if (l[i] != ViewListener.class) continue;
            ((ViewListener)l[i + 1]).viewsInserted(ev);
        }
    }

    protected synchronized void fireViewsRemoved(ViewEvent ev) {
        Object[] l = this.viewListenerList.getListenerList();
        for (int i = l.length - 2; i >= 0; i -= 2) {
            if (l[i] != ViewListener.class) continue;
            ((ViewListener)l[i + 1]).viewsRemoved(ev);
        }
    }

    public View getChild(String name) {
        int count = this.children.size();
        for (int c = 0; c < count; ++c) {
            View v = (View)this.children.get(c);
            if (!name.equals(v.getName())) continue;
            return v;
        }
        return null;
    }

    public View getChildAt(int i) {
        return (View)this.children.get(i);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public int getChildIndex(View v) {
        return this.children.indexOf(v);
    }

    public final Component getComponent() {
        if (this.viewComponent == null) {
            this.setComponent(this.createComponent());
        }
        return this.viewComponent;
    }

    public final View getParent() {
        return this.parent;
    }

    protected View[] getViewPath(View v) {
        if (v == null) {
            return new View[0];
        }
        return this.getViewPath(v, 0);
    }

    protected View[] getViewPath(View v, int i) {
        View[] rc = null;
        View p = v.getParent();
        rc = p == null ? new View[i] : this.getViewPath(p, ++i);
        rc[rc.length - i] = v;
        return rc;
    }

    protected void handleException(Throwable e) {
        Perspective pers = this.getPerspective();
        if (pers == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Uncaught exception in view: " + this);
            }
            logger.log(Level.SEVERE, e.getMessage(), e);
        } else {
            pers.handleException(e);
        }
    }

    protected void initAbstractView() {
        Platform.getInstance().debugReference((Object)this);
    }

    protected synchronized void insertChildAt(View v, int i) {
        Component comp;
        if (v == null || v == this) {
            return;
        }
        this.children.insertElementAt(v, i);
        if (v instanceof View) {
            View av = v;
            av.setParent(this);
        }
        if ((comp = v.getComponent()) == null) {
            return;
        }
        Platform.getInstance().debugReference((Object)comp);
        this.installChildComponent(v, comp);
        this.fireViewsInserted(new ViewEvent(1, this, new View[]{v}));
    }

    protected abstract void installChildComponent(View var1, Component var2);

    public boolean isChildComponent(Component comp) {
        if (this.viewComponent != null && comp != null) {
            while (comp != null) {
                if (comp == this.viewComponent) {
                    return true;
                }
                comp = comp.getParent();
            }
        }
        return false;
    }

    public final boolean isComponentInitialized() {
        return this.viewComponent != null;
    }

    protected synchronized void removeChild(View v) {
        if (v == null) {
            return;
        }
        if (!this.children.contains(v)) {
            return;
        }
        v.setParent(null);
        this.uninstallChildComponent(v, v.getComponent());
        this.children.removeElement(v);
        v.close();
        this.fireViewsRemoved(new ViewEvent(-1, this, new View[]{v}));
    }

    protected synchronized void removeChildAt(int i) {
        this.removeChild(this.getChildAt(i));
    }

    protected void setComponent(Component newViewComponent) {
        this.viewComponent = newViewComponent;
    }

    synchronized void setParent(View newParent) {
        if (this.parent == newParent) {
            return;
        }
        View old = this.parent;
        this.parent = newParent;
        this.parentChanged(old, newParent);
    }

    protected abstract void uninstallChildComponent(View var1, Component var2);

    public void refresh() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Refresh: " + this);
        }
        if (this.viewComponent != null) {
            this.viewComponent.validate();
            this.viewComponent.repaint();
        }
        if (this.children != null) {
            for (View v : this.children) {
                if (v == null) continue;
                v.refresh();
            }
        }
        if (this.viewComponent != null) {
            this.viewComponent.repaint();
        }
    }

    public ViewConstraints getViewConstraints() {
        return this.viewConstraints;
    }

    public void setViewConstraints(ViewConstraints viewConstraints) {
        this.viewConstraints = viewConstraints;
    }

    protected void finalize() throws Throwable {
        logger.fine("View finalized: " + this);
    }

    protected void parentChanged(View oldParent, View newParent) {
    }

    public void addViewListener(ViewListener l) {
        this.viewListenerList.add(ViewListener.class, l);
    }

    public void removeViewListener(ViewListener l) {
        this.viewListenerList.remove(ViewListener.class, l);
    }

    public Perspective getPerspective() {
        View p = this.parent;
        return p == null ? null : p.getPerspective();
    }

    public Workbench getWorkbench() {
        Perspective p = this.getPerspective();
        return p == null ? null : p.getWorkbench();
    }

    protected UndoManager getUndoManager() {
        Workbench wb = this.getWorkbench();
        return wb == null ? null : wb.getUndoManager();
    }

    public boolean isDirty() throws Exception {
        if (this.dirty) {
            return true;
        }
        int num = this.getChildCount();
        for (int c = 0; c < num; ++c) {
            View v = this.getChildAt(c);
            if (v == null || !v.isDirty()) continue;
            return true;
        }
        return false;
    }

    protected void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public void save() throws Exception {
        int num = this.getChildCount();
        for (int c = 0; c < num; ++c) {
            View v = this.getChildAt(c);
            if (v == null || !v.isDirty()) continue;
            v.save();
        }
    }

    public boolean promptClose() throws Exception {
        if (!this.isDirty()) {
            return true;
        }
        return this.promptSaveAndClose();
    }

    protected boolean promptSaveAndClose() throws Exception {
        String message = "Save changes ?";
        String title = "Save Changes";
        int optionType = 1;
        int messageType = 3;
        int rc = JOptionPane.showConfirmDialog(this.viewComponent, message, title, optionType, messageType);
        if (rc == 0) {
            this.save();
            return !this.isDirty();
        }
        return rc == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.viewComponent == null) {
            return;
        }
        try {
            this.dispose();
        }
        finally {
            this.disposeInternal();
        }
    }

    protected synchronized void dispose() {
    }

    private synchronized void disposeInternal() {
        View p = this.parent;
        if (p != null) {
            p.removeChild(this);
        }
        if (this.children != null) {
            int num = this.children.size();
            for (int i = num - 1; i >= 0; --i) {
                View v = (View)this.children.remove(i);
                v.close();
            }
        }
        this.viewComponent = null;
        this.parent = null;
        this.provider = null;
        this.dirty = false;
    }

    public ViewProvider getProvider() {
        return this.provider;
    }

    protected void setProvider(ViewProvider provider) {
        this.provider = provider;
    }

    public void toFront() {
        Perspective pers = this.getPerspective();
        if (pers == null) {
            return;
        }
        pers.toFront(this);
    }

    public EditorContext getEditorContext() {
        return this.editorContext;
    }

    public void setEditorContext(EditorContext editorContext) {
        this.editorContext = editorContext;
    }
}

