/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.platform;

import com.spacekiller.infection.platform.LogHistory;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class InfectionLogHistory
implements LogHistory {
    private final LogHandler logHandler;
    private Record first;
    private Record last;
    private int size;
    private int max;
    private final List handlers = new ArrayList();
    private int handlerCount;
    private boolean closed;

    protected InfectionLogHistory(int maxRecords) {
        this.max = maxRecords;
        new Record(null);
        new Record(null, null);
        this.logHandler = new LogHandler();
    }

    protected LogHandler getLogHandler() {
        return this.logHandler;
    }

    protected synchronized int getMaxRecords() {
        return this.max;
    }

    protected synchronized void setMaxRecords(int maxRecords) {
        this.max = maxRecords;
        if (this.size > this.max) {
            int num = this.size - this.max;
            Record rec = this.first;
            for (int i = 0; i < num && rec != null; ++i) {
                rec = rec.next;
            }
            if (rec == null) {
                this.last = null;
                this.first = null;
            } else {
                this.first = rec;
            }
        }
    }

    protected synchronized void dispose() {
        if (this.closed) {
            return;
        }
        this.handlers.clear();
        this.first = null;
        this.last = null;
        this.size = 0;
        this.closed = true;
    }

    @Override
    public synchronized void getLogRecords(Collection dst) {
        Record rec = this.first;
        while (rec != null) {
            dst.add((LogRecord)rec.get());
            rec = rec.next;
        }
    }

    protected synchronized void publishRecord(LogRecord record) {
        if (this.max > 0) {
            Record rec = new Record(record);
            if (this.last == null) {
                this.first = rec;
                this.size = 1;
            } else {
                this.last.next = rec;
                if (this.size < this.max) {
                    ++this.size;
                } else {
                    this.first = this.first.next;
                }
            }
            this.last = rec;
        }
        for (int i = 0; i < this.handlerCount; ++i) {
            Handler handler = (Handler)this.handlers.get(i);
            handler.publish(record);
        }
    }

    @Override
    public synchronized void addHandler(Handler handler) {
        if (handler == null) {
            return;
        }
        if (this.handlers.contains(handler)) {
            return;
        }
        this.handlers.add(handler);
        this.handlerCount = this.handlers.size();
    }

    @Override
    public synchronized void removeHandler(Handler handler) {
        this.handlers.remove(handler);
        this.handlerCount = this.handlers.size();
    }

    protected class LogHandler
    extends Handler {
        protected LogHandler() {
        }

        @Override
        public void publish(LogRecord record) {
            InfectionLogHistory.this.publishRecord(record);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }

    protected static class Record
    extends SoftReference {
        protected Record next;

        public Record(LogRecord r) {
            super(r);
        }

        public Record(LogRecord r, ReferenceQueue q) {
            super(r, q);
        }
    }
}

