/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.platform;

import com.spacekiller.infection.platform.ProductRegistry;
import com.spacekiller.util.Preferences;
import com.spacekiller.util.PreferencesRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class InfectionProductRegistry
implements ProductRegistry {
    private static final String PREFERENCES_KEY = "infection.product.keys";
    private PreferencesRegistry registry;
    private Preferences prefs;
    private Map productKeys;

    public InfectionProductRegistry(PreferencesRegistry registry) throws Exception {
        this.registry = registry;
        this.productKeys = new HashMap();
        this.initInfectionProductRegistry();
    }

    private void initInfectionProductRegistry() throws Exception {
        String[] names;
        this.prefs = this.registry.getPreferences(PREFERENCES_KEY);
        if (this.prefs == null) {
            this.prefs = this.registry.createPreferences(PREFERENCES_KEY);
        }
        if ((names = this.prefs.propertyNames()) != null) {
            for (int c = 0; c < names.length; ++c) {
                String s;
                String name = names[c];
                Object obj = this.prefs.getObject(name);
                if (obj == null || !(obj instanceof String) || (s = (String)obj).length() <= 0) continue;
                this.productKeys.put(name, obj);
            }
        }
    }

    @Override
    public String getProductKey(String product) {
        String regKey = (String)this.productKeys.get(product);
        return regKey;
    }

    public String[] getProducts() {
        Set coll = this.productKeys.keySet();
        return coll.toArray(new String[coll.size()]);
    }

    public synchronized void registerProduct(String product, String productKey) throws Exception {
        if (product == null || productKey == null) {
            return;
        }
        if (product.length() < 1 || productKey.length() < 1) {
            return;
        }
        this.prefs.setObject(product, (Object)productKey);
        this.productKeys.put(product, productKey);
        this.registry.savePreferences(this.prefs);
    }

    public synchronized void unregisterProduct(String product) throws Exception {
        this.prefs.setObject(product, (Object)"");
        this.productKeys.remove(product);
        this.registry.savePreferences(this.prefs);
    }

    public static final class Facade
    implements ProductRegistry {
        private ProductRegistry registry;

        public Facade(ProductRegistry registry) {
            this.registry = registry;
        }

        @Override
        public String getProductKey(String product) {
            return this.registry.getProductKey(product);
        }
    }
}

