/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.platform;

import java.io.FileOutputStream;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;

public class RegistrationTest {
    private static final Logger logger = Logger.getLogger(RegistrationTest.class.getName());

    public static void main(String[] args) {
        try {
            new RegistrationTest().test();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        System.exit(0);
    }

    public void test() throws Exception {
        logger.fine("" + this + "..");
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        KeyPair keyPair = keyGen.generateKeyPair();
        PrivateKey privateKey = keyPair.getPrivate();
        byte[] privateKeyData = privateKey.getEncoded();
        PublicKey publicKey = keyPair.getPublic();
        byte[] publicKeyData = publicKey.getEncoded();
        logger.fine("Private: " + privateKey);
        logger.fine("Public: " + publicKey);
        this.saveKey(privateKeyData, "/temp/private.key");
        this.saveKey(publicKeyData, "/temp/public.key");
        Cipher cipher = Cipher.getInstance("RSA");
        logger.fine("Cipher: " + cipher);
        cipher.init(1, privateKey);
        KeyFactory rSAKeyFactory = KeyFactory.getInstance("RSA");
        PrivateKey loadedPrivate = rSAKeyFactory.generatePrivate(new PKCS8EncodedKeySpec(privateKeyData));
        logger.fine("Loaded private: " + loadedPrivate);
        rSAKeyFactory = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec pubSpec = new X509EncodedKeySpec(publicKeyData);
        PublicKey loadedPublic = rSAKeyFactory.generatePublic(pubSpec);
        logger.fine("Loaded public: " + loadedPublic);
        logger.fine("SUCCESS.");
    }

    private void saveKey(byte[] key, String filePath) throws Exception {
        FileOutputStream fout = new FileOutputStream(filePath);
        fout.write(key);
        fout.close();
        logger.fine("Key saved: " + filePath);
    }
}

