/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.prefs;

import com.spacekiller.infection.platform.InfectionPreferencesConstants;
import com.spacekiller.infection.prefs.WorkbenchPreferencesPanel;
import com.spacekiller.util.Platform;
import com.spacekiller.util.Preferences;
import com.spacekiller.util.PreferencesRegistry;
import com.spacekiller.util.workbench.AbstractPreferencesPage;
import com.spacekiller.util.workbench.View;
import com.spacekiller.util.workbench.Workbench;
import java.awt.Component;

public class WorkbenchPreferencesPage
extends AbstractPreferencesPage
implements InfectionPreferencesConstants {
    private PreferencesRegistry registry;

    public Component createComponent() {
        WorkbenchPreferencesPanel panel = new WorkbenchPreferencesPanel();
        return panel;
    }

    public void refreshPreferences(View view) throws Exception {
        WorkbenchPreferencesPanel panel = this.getWorkbenchPreferencesPanel(view);
        Preferences prefs = this.getPreferences();
        boolean backTypeCustom = false;
        String backFilePath = null;
        boolean stretch = true;
        boolean windowAnimation = true;
        boolean alwaysOnTop = false;
        boolean autoHideDetachedViews = false;
        if (prefs != null) {
            Object obj;
            String str;
            String backType = (String)prefs.getObject("background.type");
            backTypeCustom = false;
            if (backType != null && backType.equals("custom")) {
                backTypeCustom = true;
            }
            if ((backFilePath = (String)prefs.getObject("background.file")) == null || backFilePath.length() < 1) {
                backTypeCustom = false;
            }
            if ((str = (String)prefs.getObject("background.stretch")) != null) {
                stretch = new Boolean(str);
            }
            if ((obj = prefs.getObject("window.alwaysOnTop")) != null) {
                alwaysOnTop = new Boolean(obj.toString());
            }
            if ((str = (String)prefs.getObject("window.audioHideDetachedViews")) != null) {
                autoHideDetachedViews = new Boolean(str);
            }
            if ((str = (String)prefs.getObject("window.animation")) != null) {
                windowAnimation = new Boolean(str);
            }
        }
        panel.getJRadioButtonDefaultBackground().setSelected(!backTypeCustom);
        panel.getJRadioButtonCustomBackground().setSelected(backTypeCustom);
        panel.getFileFieldCustomBackground().setPath(backFilePath);
        panel.getJCheckBoxStretch().setSelected(stretch);
        panel.getCheckBoxAlwaysOnTop().setSelected(alwaysOnTop);
        panel.getChckbxAutoHideDetached().setSelected(autoHideDetachedViews);
        panel.getJCheckBoxWindowAnimation().setSelected(windowAnimation);
    }

    public void resetPreferences(View view) throws Exception {
        this.refreshPreferences(view);
    }

    public void savePreferences(View view) throws Exception {
        WorkbenchPreferencesPanel panel = this.getWorkbenchPreferencesPanel(view);
        Preferences prefs = this.getPreferences();
        if (prefs == null) {
            prefs = this.getRegistry().createPreferences("platform.workbench");
        }
        boolean alwaysOnTop = panel.getCheckBoxAlwaysOnTop().isSelected();
        prefs.setObject("window.alwaysOnTop", (Object)("" + alwaysOnTop));
        boolean autoHideDetachedViews = panel.getChckbxAutoHideDetached().isSelected();
        prefs.setObject("window.audioHideDetachedViews", (Object)("" + autoHideDetachedViews));
        boolean windowAnimation = panel.getJCheckBoxWindowAnimation().isSelected();
        prefs.setObject("window.animation", (Object)("" + windowAnimation));
        String backType = "default";
        boolean customBack = panel.getJRadioButtonCustomBackground().isSelected();
        if (customBack) {
            backType = "custom";
        }
        prefs.setObject("background.type", (Object)backType);
        String filePath = panel.getFileFieldCustomBackground().getPath();
        if (filePath == null) {
            filePath = "";
        }
        prefs.setObject("background.file", (Object)filePath);
        boolean stretch = panel.getJCheckBoxStretch().isSelected();
        prefs.setObject("background.stretch", (Object)("" + stretch));
        this.getRegistry().savePreferences(prefs);
        Workbench wb = view.getWorkbench();
        if (wb != null) {
            wb.refresh();
        }
    }

    protected PreferencesRegistry createRegistry() {
        return Platform.getInstance().getPreferencesRegistry();
    }

    protected PreferencesRegistry getRegistry() {
        if (this.registry == null) {
            this.setRegistry(this.createRegistry());
        }
        return this.registry;
    }

    protected void setRegistry(PreferencesRegistry registry) {
        this.registry = registry;
    }

    protected Preferences getPreferences() throws Exception {
        return this.getRegistry().getPreferences("platform.workbench");
    }

    protected WorkbenchPreferencesPanel getWorkbenchPreferencesPanel(View view) {
        Component comp = view.getComponent();
        if (comp != null && comp instanceof WorkbenchPreferencesPanel) {
            return (WorkbenchPreferencesPanel)comp;
        }
        return null;
    }
}

