/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.service.plugin;

import com.spacekiller.util.Platform;
import com.spacekiller.util.Plugin;
import com.spacekiller.util.service.DefaultServiceManager;
import com.spacekiller.util.service.Service;
import com.spacekiller.util.service.ServiceManager;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServicePlugin
extends Plugin {
    private static Logger logger = Logger.getLogger(ServicePlugin.class.getName());
    public static final String SERVICE_PLUGIN_ID = "com.spacekiller.util.service.plugin";
    private ServiceManager serviceManager;

    public static ServicePlugin getInstance() throws Exception {
        return (ServicePlugin)Platform.getInstance().getPlugin(SERVICE_PLUGIN_ID);
    }

    protected void startup() {
        super.startup();
    }

    protected void shutdown() {
        ServiceManager serviceMan;
        super.shutdown();
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Stopping services...");
        }
        if ((serviceMan = this.serviceManager) != null) {
            int num = serviceMan.getServiceCount();
            for (int i = 0; i < num; ++i) {
                int status;
                Service service = serviceMan.getServiceAt(i);
                if (service == null || (status = service.getStatus()) == 0) continue;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Stopping service: " + service);
                }
                try {
                    service.stop();
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.fine("Service stopped: " + service);
                    continue;
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            this.serviceManager = null;
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Services stopped.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceManager getServiceManager() {
        if (this.serviceManager == null) {
            ServicePlugin servicePlugin = this;
            synchronized (servicePlugin) {
                if (this.serviceManager == null) {
                    this.setServiceManager(this.createServiceManager());
                }
            }
        }
        return this.serviceManager;
    }

    protected void setServiceManager(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    protected ServiceManager createServiceManager() {
        return new DefaultServiceManager();
    }
}

