/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.components;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.ClassDescriptor;
import com.spacekiller.util.ClassRegistry;
import com.spacekiller.util.Filter;
import com.spacekiller.util.Platform;
import com.spacekiller.util.Tools;
import com.spacekiller.util.beans.components.ClassChooser;
import com.spacekiller.util.swing.DocumentAdapter;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ClassChooserField
extends JPanel
implements ItemSelectable {
    private static final long serialVersionUID = -3191119220637621313L;
    private BeansToolkit beansToolkit;
    private ClassRegistry classRegistry;
    private Filter classFilter;
    private boolean dialogConfirm = false;
    private int emptySearchAction = ClassChooser.EMPTY_DO_NOTHING;
    private JButton jButtonBrowse = null;
    private JTextField jTextFieldClassName = null;
    private transient ItemListener itemListeners;
    private JDialog jDialogChooser = null;
    private JPanel jContentPane = null;
    private ClassChooser classChooser = null;
    private JPanel jPanel = null;
    private JButton jButtonOkay = null;

    public ClassChooserField() {
        this.initialize();
        this.initClassChooserField();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.gridx = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(210, 40));
        this.add((Component)this.getJButtonBrowse(), gridBagConstraints);
        this.add((Component)this.getJTextFieldClassName(), gridBagConstraints2);
    }

    private JButton getJButtonBrowse() {
        if (this.jButtonBrowse == null) {
            this.jButtonBrowse = new JButton();
            this.jButtonBrowse.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/beans/editors/icons/search.gif")));
            this.jButtonBrowse.setMaximumSize(new Dimension(23, 23));
            this.jButtonBrowse.setMinimumSize(new Dimension(23, 23));
            this.jButtonBrowse.setPreferredSize(new Dimension(23, 23));
            this.jButtonBrowse.setMargin(new Insets(0, 0, 0, 0));
            this.jButtonBrowse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ClassChooserField.this.actionBrowse();
                }
            });
        }
        return this.jButtonBrowse;
    }

    private JTextField getJTextFieldClassName() {
        if (this.jTextFieldClassName == null) {
            this.jTextFieldClassName = new JTextField();
            this.jTextFieldClassName.setColumns(18);
        }
        return this.jTextFieldClassName;
    }

    @Override
    public void setOpaque(boolean isOpaque) {
        super.setOpaque(isOpaque);
        this.getJTextFieldClassName().setOpaque(isOpaque);
        this.getJButtonBrowse().setOpaque(isOpaque);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.getJTextFieldClassName().setEnabled(enabled);
        this.getJButtonBrowse().setEnabled(enabled);
    }

    protected void actionBrowse() {
        ClassChooser chooser = this.getClassChooser();
        chooser.setEmptySearchAction(this.getEmptySearchAction());
        chooser.setBeansToolkit(this.getBeansToolkit());
        chooser.setClassRegistry(this.getClassRegistry());
        chooser.setClassFilter(this.getClassFilter());
        chooser.refresh();
        this.dialogConfirm = false;
        this.getJDialogChooser().setBounds(0, 0, 300, 400);
        Tools.centerWindow((Component)this, (Window)this.getJDialogChooser());
        this.getJDialogChooser().setModal(true);
        this.getJDialogChooser().setVisible(true);
        if (!this.dialogConfirm) {
            return;
        }
        ClassDescriptor cd = chooser.getSelectedClassDescriptor();
        if (cd == null) {
            return;
        }
        this.getJTextFieldClassName().setText(cd.getClassName());
    }

    public BeansToolkit getBeansToolkit() {
        if (this.beansToolkit == null) {
            this.setBeansToolkit(Platform.getInstance().getBeansToolkit());
        }
        return this.beansToolkit;
    }

    public void setBeansToolkit(BeansToolkit beansToolkit) {
        this.beansToolkit = beansToolkit;
    }

    public Filter getClassFilter() {
        return this.classFilter;
    }

    public void setClassFilter(Filter classFilter) {
        this.classFilter = classFilter;
    }

    public ClassRegistry getClassRegistry() {
        if (this.classRegistry == null) {
            this.setClassRegistry(Platform.getInstance().getClassRegistry());
        }
        return this.classRegistry;
    }

    public void setClassRegistry(ClassRegistry classRegistry) {
        this.classRegistry = classRegistry;
    }

    public String getSelectedClassName() {
        String className = this.getJTextFieldClassName().getText();
        if (className != null) {
            className = className.trim();
        }
        return className;
    }

    public ClassDescriptor getSelectedClassDescriptor() {
        ClassDescriptor cd = null;
        String className = this.getSelectedClassName();
        if (className != null && this.classRegistry != null) {
            cd = this.classRegistry.getClassDescriptor(className);
        }
        return cd;
    }

    public void setSelectedClassName(String className) {
        if (className == null) {
            className = "";
        }
        this.getJTextFieldClassName().setText(className);
    }

    public void setSelectedClassDescriptor(ClassDescriptor cd) {
        String name = cd == null ? null : cd.getClassName();
        this.setSelectedClassName(name);
    }

    protected void fireItemStateChanged(ItemEvent e) {
        if (this.itemListeners == null) {
            return;
        }
        this.itemListeners.itemStateChanged(e);
    }

    @Override
    public void addItemListener(ItemListener listener) {
        this.itemListeners = AWTEventMulticaster.add(this.itemListeners, listener);
    }

    @Override
    public void removeItemListener(ItemListener listener) {
        this.itemListeners = AWTEventMulticaster.remove(this.itemListeners, listener);
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])AWTEventMulticaster.getListeners((EventListener)this.itemListeners, ItemListener.class);
    }

    private JDialog getJDialogChooser() {
        if (this.jDialogChooser == null) {
            this.jDialogChooser = new JDialog();
            this.jDialogChooser.setSize(new Dimension(334, 259));
            this.jDialogChooser.setTitle("Choose Class");
            this.jDialogChooser.setContentPane(this.getJContentPane());
        }
        return this.jDialogChooser;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.weightx = 0.0;
            gridBagConstraints3.weighty = 0.0;
            gridBagConstraints3.fill = 0;
            gridBagConstraints3.anchor = 13;
            gridBagConstraints3.gridy = 1;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.weighty = 1.0;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.gridy = 0;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getClassChooser(), gridBagConstraints1);
            this.jContentPane.add((Component)this.getJPanel(), gridBagConstraints3);
        }
        return this.jContentPane;
    }

    private ClassChooser getClassChooser() {
        if (this.classChooser == null) {
            this.classChooser = new ClassChooser();
        }
        return this.classChooser;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints4.gridy = 0;
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.add((Component)this.getJButtonOkay(), gridBagConstraints4);
        }
        return this.jPanel;
    }

    private JButton getJButtonOkay() {
        if (this.jButtonOkay == null) {
            this.jButtonOkay = new JButton();
            this.jButtonOkay.setText("Ok");
            this.jButtonOkay.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ClassChooserField.this.dialogConfirm = true;
                    ClassChooserField.this.getJDialogChooser().dispose();
                }
            });
        }
        return this.jButtonOkay;
    }

    protected void initClassChooserField() {
        this.getJButtonOkay().setEnabled(false);
        this.getClassChooser().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ClassChooserField.this.checkEnable();
            }
        });
        this.getJTextFieldClassName().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void handle(DocumentEvent e) {
                String item = ClassChooserField.this.getSelectedClassName();
                ItemEvent ie = new ItemEvent(ClassChooserField.this, 701, item, 1);
                ClassChooserField.this.fireItemStateChanged(ie);
            }
        });
    }

    protected void checkEnable() {
        boolean enable = this.getClassChooser().getSelectedClassDescriptor() != null;
        this.getJButtonOkay().setEnabled(enable);
    }

    @Override
    public Object[] getSelectedObjects() {
        String name = this.getSelectedClassName();
        if (name == null) {
            return null;
        }
        return new Object[]{name};
    }

    public int getEmptySearchAction() {
        return this.emptySearchAction;
    }

    public void setEmptySearchAction(int emptySearchAction) {
        this.emptySearchAction = emptySearchAction;
    }
}

