/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.components;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.beans.components.FeatureLabel;
import com.spacekiller.util.beans.components.FeatureLabelToolkit;
import com.spacekiller.util.swing.AbstractCellRenderer;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

public class DefaultFeatureHeaderRenderer
extends AbstractCellRenderer
implements TableCellRenderer {
    private static final long serialVersionUID = -3614944282488128651L;
    private FeatureLabelToolkit featureLabelToolkit;
    private BeansToolkit beansToolkit;
    private Border headerBorder;
    private static final Logger logger = Logger.getLogger(DefaultFeatureHeaderRenderer.class.getName());

    public DefaultFeatureHeaderRenderer(BeansToolkit newBeansToolkit) {
        this.setBeansToolkit(newBeansToolkit);
        this.setOpaque(false);
        this.setLayout(new GridLayout(1, 1, 0, 0));
        this.setHeaderBorder(UIManager.getBorder("TableHeader.cellBorder"));
    }

    protected FeatureLabelToolkit createFeatureLabelToolkit() {
        return new FeatureLabelToolkit();
    }

    protected BeanDescriptor getBeanDescriptor(Object bean) {
        BeansToolkit btk = this.getBeansToolkit();
        try {
            BeanInfo info = btk.getBeanInfo(bean.getClass());
            if (info == null) {
                return null;
            }
            return info.getBeanDescriptor();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected BeansToolkit getBeansToolkit() {
        return this.beansToolkit;
    }

    public FeatureLabelToolkit getFeatureLabelToolkit() {
        if (this.featureLabelToolkit == null) {
            this.setFeatureLabelToolkit(this.createFeatureLabelToolkit());
        }
        return this.featureLabelToolkit;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setSelected(isSelected);
        this.setFocus(hasFocus);
        this.setBorder(this.headerBorder);
        try {
            FeatureDescriptor feature = null;
            Object bean = null;
            if (value instanceof FeatureDescriptor && value != null) {
                feature = (FeatureDescriptor)value;
            } else {
                feature = this.getBeanDescriptor(value);
                bean = value;
            }
            this.getFeatureLabelToolkit().getFeatureLabel(this.getBeansToolkit(), feature, bean);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return this;
    }

    public String getToolTipText() {
        return this.getFeatureLabelToolkit().getToolTipText();
    }

    public String getToolTipText(MouseEvent event) {
        return this.getToolTipText();
    }

    protected void installFeatureLabel(FeatureLabelToolkit tk) {
        this.removeAll();
        if (tk == null) {
            return;
        }
        FeatureLabel label = tk.getFeatureLabel();
        if (label == null) {
            return;
        }
        this.add(label);
    }

    protected void setBeansToolkit(BeansToolkit newBeansToolkit) {
        this.beansToolkit = newBeansToolkit;
    }

    public void setFeatureLabelToolkit(FeatureLabelToolkit newFeatureLabelToolkit) {
        this.featureLabelToolkit = newFeatureLabelToolkit;
        this.installFeatureLabel(newFeatureLabelToolkit);
    }

    public Border getHeaderBorder() {
        return this.headerBorder;
    }

    public void setHeaderBorder(Border headerBorder) {
        this.headerBorder = headerBorder;
    }
}

