/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.components;

import com.spacekiller.util.beans.components.AbstractPropertyEditorCellEditor;
import com.spacekiller.util.beans.components.DefaultPropertyEditorCellToolkit;
import com.spacekiller.util.beans.components.PropertyEditorDelegate;
import com.spacekiller.util.swing.PopupManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.beancontext.BeanContext;
import java.util.EventObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.CellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class DefaultPropertyEditorCellEditor
extends AbstractPropertyEditorCellEditor {
    private static final long serialVersionUID = 7134338781900319633L;
    private DefaultPropertyEditorCellToolkit cellToolkit;
    private JButton customizerButton;
    private CellEditor peerCellEditor;
    private static final Logger logger = Logger.getLogger(DefaultPropertyEditorCellEditor.class.getName());

    public DefaultPropertyEditorCellEditor(DefaultPropertyEditorCellToolkit tk) {
        this.setCellToolkit(tk);
    }

    protected JButton createCustomizerButton() {
        JButton button = new JButton("");
        try {
            button.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/beans/editors/icons/genericvariable_obj.gif")));
            button.setBorder(new CompoundBorder());
            button.setPreferredSize(new Dimension(16, 16));
        }
        catch (Exception e) {
            button.setText("..");
        }
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setOpaque(false);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                DefaultPropertyEditorCellEditor.this.showCustomEditor();
            }
        });
        return button;
    }

    @Override
    protected Object getBean(int row, int column) {
        return this.getCellToolkit().getBean(row, column);
    }

    @Override
    protected BeanContext getBeanContextOfBean(int row, int column) {
        return this.getCellToolkit().getBeanContextOfBean(row, column);
    }

    public DefaultPropertyEditorCellToolkit getCellToolkit() {
        return this.cellToolkit;
    }

    @Override
    protected JButton getCustomizerButton() {
        if (this.customizerButton == null) {
            this.customizerButton = this.createCustomizerButton();
        }
        return this.customizerButton;
    }

    public CellEditor getPeerCellEditor() {
        return this.peerCellEditor;
    }

    @Override
    protected PropertyDescriptor getPropertyDescriptor(int row, int column) {
        return this.getCellToolkit().getPropertyDescriptor(row, column);
    }

    @Override
    protected PropertyEditor getPropertyEditor(int row, int column) {
        return this.getCellToolkit().getPropertyEditor(row, column);
    }

    protected BeanContext getPropertyEditorBeanContext(PropertyEditor propertyEditor, int row, int column) {
        return this.getCellToolkit().getPropertyEditorBeanContext(propertyEditor, row, column);
    }

    @Override
    protected void handleException(Throwable e) {
        logger.log(Level.WARNING, this.getClass().getName(), e);
    }

    private void setCellToolkit(DefaultPropertyEditorCellToolkit newCellToolkit) {
        this.cellToolkit = newCellToolkit;
    }

    protected void setCustomizerButton(JButton newCustomizerButton) {
        this.customizerButton = newCustomizerButton;
    }

    public void setPeerCellEditor(CellEditor newPeerCellEditor) {
        this.peerCellEditor = newPeerCellEditor;
    }

    protected void showCustomEditor() {
        this.showCustomEditorPopupWindow();
    }

    protected void showCustomEditorDialog() {
        CellEditor peer;
        PropertyEditorDelegate delegate = this.getEditorDelegate();
        if (delegate == null) {
            return;
        }
        PropertyEditor ed = delegate.getPropertyEditor();
        if (ed == null) {
            return;
        }
        if (!ed.supportsCustomEditor()) {
            return;
        }
        Component custom = ed.getCustomEditor();
        if (custom == null) {
            return;
        }
        CustomEditorDelegate customDelegate = new CustomEditorDelegate();
        customDelegate.setPropertyEditor(ed);
        this.setCustomEditorDelegate(customDelegate);
        JDialog dialog = new JDialog();
        dialog.setTitle("Custom editor");
        dialog.getContentPane().setLayout(new GridLayout(1, 1));
        dialog.getContentPane().add(custom);
        dialog.setModal(true);
        dialog.pack();
        Point screenLocation = this.getLocationOnScreen();
        dialog.setLocation(screenLocation.x, screenLocation.y + this.getHeight());
        dialog.setVisible(true);
        AbstractPropertyEditorCellEditor.TextFieldEditorDelegate textDelegate = null;
        if (delegate instanceof AbstractPropertyEditorCellEditor.TextFieldEditorDelegate) {
            textDelegate = (AbstractPropertyEditorCellEditor.TextFieldEditorDelegate)delegate;
            textDelegate.setEditable(true);
        }
        if ((peer = this.getPeerCellEditor()) == null) {
            peer = this;
        }
        peer.stopCellEditing();
    }

    protected void showCustomEditorPopupMenu() {
        PropertyEditorDelegate delegate = this.getEditorDelegate();
        if (delegate == null) {
            return;
        }
        final PropertyEditor ed = delegate.getPropertyEditor();
        if (ed == null) {
            return;
        }
        if (!ed.supportsCustomEditor()) {
            return;
        }
        Component custom = ed.getCustomEditor();
        if (custom == null) {
            return;
        }
        CustomEditorDelegate customDelegate = new CustomEditorDelegate();
        customDelegate.setPropertyEditor(ed);
        this.setCustomEditorDelegate(customDelegate);
        final DefaultPropertyEditorCellEditor thisCellEditor = this;
        JPopupMenu popup = new JPopupMenu();
        popup.setLightWeightPopupEnabled(false);
        popup.add(custom);
        AbstractPropertyEditorCellEditor.TextFieldEditorDelegate textDelegate = null;
        if (delegate instanceof AbstractPropertyEditorCellEditor.TextFieldEditorDelegate) {
            textDelegate = (AbstractPropertyEditorCellEditor.TextFieldEditorDelegate)delegate;
            textDelegate.setEditable(true);
        }
        popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                logger.info("popupMenuCanceled: " + e);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                logger.info("popupMenuWillBecomeInvisible: " + e);
                Object newValue = ed.getValue();
                logger.fine("-> New value from Custom-Editor: " + newValue);
                CellEditor peer = DefaultPropertyEditorCellEditor.this.getPeerCellEditor();
                if (peer == null) {
                    peer = thisCellEditor;
                }
                boolean rc = peer.stopCellEditing();
                logger.fine("-> RC=" + rc);
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                logger.info("popupMenuWillBecomeVisible: " + e);
            }
        });
        logger.info("showCustomEditorPopupMenu: " + popup);
        Dimension dim = custom.getPreferredSize();
        int prefCustomWidth = dim == null ? this.getWidth() : dim.width;
        popup.show((Component)((Object)this), this.getWidth() - prefCustomWidth, this.getHeight());
    }

    protected void showCustomEditorPopupWindow() {
        PropertyEditorDelegate delegate = this.getEditorDelegate();
        if (delegate == null) {
            return;
        }
        PropertyEditor ed = delegate.getPropertyEditor();
        if (ed == null) {
            return;
        }
        if (!ed.supportsCustomEditor()) {
            return;
        }
        Component custom = ed.getCustomEditor();
        if (custom == null) {
            return;
        }
        CustomEditorDelegate customDelegate = new CustomEditorDelegate();
        customDelegate.setPropertyEditor(ed);
        this.setCustomEditorDelegate(customDelegate);
        AbstractPropertyEditorCellEditor.TextFieldEditorDelegate textDelegate = null;
        if (delegate instanceof AbstractPropertyEditorCellEditor.TextFieldEditorDelegate) {
            textDelegate = (AbstractPropertyEditorCellEditor.TextFieldEditorDelegate)delegate;
            textDelegate.setEditable(true);
        }
        logger.info("showCustomEditorPopupWindow: " + custom);
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new GridLayout(1, 1));
        panel.add(custom);
        panel.setBorder(new EtchedBorder(0));
        Dimension dim = panel.getPreferredSize();
        int prefCustomWidth = dim == null ? this.getWidth() : dim.width;
        PopupManager.getSharedInstance().showPopup((Component)((Object)this), (Component)panel, this.getWidth() - prefCustomWidth, this.getHeight());
    }

    public class CustomEditorDelegate
    implements PropertyEditorDelegate {
        private PropertyEditor editor;

        @Override
        public PropertyEditor getPropertyEditor() {
            return this.editor;
        }

        public void setPropertyEditor(PropertyEditor ed) {
            this.editor = ed;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        @Override
        public Component getComponent() {
            return null;
        }

        @Override
        public boolean isEditable() {
            return true;
        }

        @Override
        public Object getCellEditorValue() {
            return this.editor == null ? null : this.editor.getValue();
        }
    }
}

