/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.components;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.beans.model.BeanModel;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.beancontext.BeanContext;
import java.util.Vector;
import java.util.logging.Logger;

public class DefaultPropertyEditorCellToolkit {
    public static final int BEANS_IN_ROWS = 0;
    public static final int BEANS_IN_COLUMNS = 1;
    private static final Logger logger = Logger.getLogger(DefaultPropertyEditorCellToolkit.class.getName());
    private int orientation = 0;
    private Vector propertyEditors;
    private Vector propertyDescriptors;
    private BeansToolkit beansToolkit;
    private Vector propertyEditorBeanContexts;
    private BeanModel model;

    public DefaultPropertyEditorCellToolkit(BeansToolkit newBeansToolkit, BeanModel model, int newOrientation, Vector newPropertyDescriptors, Vector newPropertyEditors, Vector newPropertyEditorBeanContexts) {
        this.setBeansToolkit(newBeansToolkit);
        this.setModel(model);
        this.setOrientation(newOrientation);
        this.setPropertyDescriptors(newPropertyDescriptors);
        this.setPropertyEditors(newPropertyEditors);
        this.setPropertyEditorBeanContexts(newPropertyEditorBeanContexts);
    }

    public Object getBean(int row, int column) {
        BeanModel m;
        int index = this.getBeanIndex(row, column);
        if (index >= 0 && (m = this.getModel()) != null) {
            Object rc = m.getBeanAt(index);
            logger.fine("Getting bean for " + row + "," + column + " => " + index + " of " + m.getBeanCount() + " => " + rc);
            return rc;
        }
        return null;
    }

    public BeanContext getBeanContextOfBean(int row, int column) {
        BeanModel m;
        int index = this.getBeanIndex(row, column);
        if (index >= 0 && (m = this.getModel()) != null) {
            BeanContext rc = m.getBeanContextOfBeanAt(index);
            logger.fine("Getting beanContext for " + row + "," + column + " => " + index + " => " + rc);
            return rc;
        }
        return null;
    }

    public int getBeanIndex(int row, int column) {
        if (this.getOrientation() == 0) {
            return row;
        }
        return column;
    }

    public BeansToolkit getBeansToolkit() {
        return this.beansToolkit;
    }

    public BeanModel getModel() {
        return this.model;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public PropertyDescriptor getPropertyDescriptor(int row, int column) {
        Vector v = this.getPropertyDescriptors();
        if (v == null) {
            return null;
        }
        int index = this.getPropertyIndex(row, column);
        if (index < 0 || index >= v.size()) {
            return null;
        }
        return (PropertyDescriptor)v.get(index);
    }

    public Vector getPropertyDescriptors() {
        return this.propertyDescriptors;
    }

    public PropertyEditor getPropertyEditor(int row, int column) {
        Vector v = this.getPropertyEditors();
        if (v == null) {
            return null;
        }
        int index = this.getPropertyIndex(row, column);
        if (index < 0 || index >= v.size()) {
            return null;
        }
        return (PropertyEditor)v.get(index);
    }

    public BeanContext getPropertyEditorBeanContext(PropertyEditor propertyEditor, int row, int column) {
        Vector v = this.getPropertyEditorBeanContexts();
        if (v == null) {
            return null;
        }
        int index = this.getPropertyIndex(row, column);
        if (index < 0 || index >= v.size()) {
            return null;
        }
        return (BeanContext)v.get(index);
    }

    public Vector getPropertyEditorBeanContexts() {
        return this.propertyEditorBeanContexts;
    }

    public Vector getPropertyEditors() {
        return this.propertyEditors;
    }

    public String getPropertyEditorToolTip(PropertyEditor propertyEditor, int row, int column) {
        if (propertyEditor == null) {
            return null;
        }
        try {
            return this.getPropertyEditorToolTip(propertyEditor.getValue());
        }
        catch (Throwable e) {
            return null;
        }
    }

    protected String getPropertyEditorToolTip(Object value) {
        String rc = null;
        Class<?> clazz = value == null ? null : value.getClass();
        rc = clazz.isArray() ? clazz.getComponentType().getName() + "[]" : String.valueOf(value);
        if (rc != null && rc.length() < 1) {
            rc = null;
        }
        return rc;
    }

    public int getPropertyIndex(int row, int column) {
        if (this.getOrientation() == 0) {
            return column;
        }
        return row;
    }

    private void setBeansToolkit(BeansToolkit newBeansToolkit) {
        this.beansToolkit = newBeansToolkit;
    }

    private void setModel(BeanModel newModel) {
        this.model = newModel;
    }

    private void setOrientation(int newOrientation) {
        this.orientation = newOrientation;
    }

    private void setPropertyDescriptors(Vector newPropertyDescriptors) {
        this.propertyDescriptors = newPropertyDescriptors;
    }

    private void setPropertyEditorBeanContexts(Vector newPropertyEditorBeanContexts) {
        this.propertyEditorBeanContexts = newPropertyEditorBeanContexts;
    }

    private void setPropertyEditors(Vector newPropertyEditors) {
        this.propertyEditors = newPropertyEditors;
    }
}

