/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.components;

import java.awt.Component;
import java.awt.Graphics;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class FeatureIcon
implements Icon {
    private Icon readIcon;
    private Icon writeIcon;
    private Icon boundIcon;
    private Icon constrainedIcon;
    private Icon expertIcon;
    private Icon hiddenIcon;
    private FeatureDescriptor feature;

    public FeatureIcon() {
        this.initDefaultIcons();
    }

    public Icon getBoundIcon() {
        return this.boundIcon;
    }

    public Icon getExpertIcon() {
        return this.expertIcon;
    }

    public FeatureDescriptor getFeature() {
        return this.feature;
    }

    protected Iterator getFeatureIcons() {
        Vector<Icon> rc = new Vector<Icon>();
        FeatureDescriptor f = this.getFeature();
        if (f != null) {
            Icon icon;
            if (f instanceof PropertyDescriptor) {
                PropertyDescriptor prop = (PropertyDescriptor)f;
                if (prop.getReadMethod() != null && (icon = this.getReadIcon()) != null) {
                    rc.add(icon);
                }
                if (prop.getWriteMethod() != null && (icon = this.getWriteIcon()) != null) {
                    rc.add(icon);
                }
                if (prop.isBound() && (icon = this.getBoundIcon()) != null) {
                    rc.add(icon);
                }
                if (prop.isConstrained() && (icon = this.getConstrainedIcon()) != null) {
                    rc.add(icon);
                }
            }
            if (f.isExpert() && (icon = this.getExpertIcon()) != null) {
                rc.add(icon);
            }
            if (f.isHidden() && (icon = this.getHiddenIcon()) != null) {
                rc.add(icon);
            }
        }
        return rc.iterator();
    }

    public Icon getHiddenIcon() {
        return this.hiddenIcon;
    }

    @Override
    public int getIconHeight() {
        int rc = 0;
        Iterator i = this.getFeatureIcons();
        while (i.hasNext()) {
            Icon icon = (Icon)i.next();
            int h = icon.getIconHeight();
            if (h <= rc) continue;
            rc = h;
        }
        return rc;
    }

    @Override
    public int getIconWidth() {
        int rc = 0;
        Iterator i = this.getFeatureIcons();
        while (i.hasNext()) {
            Icon icon = (Icon)i.next();
            rc += icon.getIconWidth();
        }
        return rc;
    }

    public Icon getReadIcon() {
        return this.readIcon;
    }

    public Icon getWriteIcon() {
        return this.writeIcon;
    }

    protected void initDefaultIcons() {
        this.setReadIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/beans/editors/icons/read.gif")));
        this.setWriteIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/beans/editors/icons/write.gif")));
        this.setBoundIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/beans/editors/icons/bound.gif")));
        this.setConstrainedIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/beans/editors/icons/constrained.gif")));
        this.setExpertIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/beans/editors/icons/expert.gif")));
        this.setHiddenIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/beans/editors/icons/hidden.gif")));
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Iterator i = this.getFeatureIcons();
        while (i.hasNext()) {
            Icon icon = (Icon)i.next();
            int w = icon.getIconWidth();
            icon.paintIcon(c, g, x, y);
            x += w;
        }
    }

    public void setBoundIcon(Icon newBoundIcon) {
        this.boundIcon = newBoundIcon;
    }

    public void setExpertIcon(Icon newExpertIcon) {
        this.expertIcon = newExpertIcon;
    }

    public void setFeature(FeatureDescriptor newFeature) {
        this.feature = newFeature;
    }

    public void setHiddenIcon(Icon newHiddenIcon) {
        this.hiddenIcon = newHiddenIcon;
    }

    public void setReadIcon(Icon newReadIcon) {
        this.readIcon = newReadIcon;
    }

    public void setWriteIcon(Icon newWriteIcon) {
        this.writeIcon = newWriteIcon;
    }

    public Icon getConstrainedIcon() {
        return this.constrainedIcon;
    }

    public void setConstrainedIcon(Icon constrainedIcon) {
        this.constrainedIcon = constrainedIcon;
    }
}

