/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.components;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.Tools;
import com.spacekiller.util.beans.DefaultFeatureDescriptorComparator;
import com.spacekiller.util.beans.DynamicBean;
import com.spacekiller.util.beans.components.FeatureIcon;
import com.spacekiller.util.beans.components.FeatureLabel;
import java.awt.Font;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.FeatureDescriptor;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import javax.swing.Icon;

public class FeatureLabelToolkit {
    private FeatureIcon featureIcon;
    private FeatureLabel featureLabel;
    private Font defaultFeatureFont = Tools.getDefaultFont((int)0);
    private Font preferredFeatureFont = Tools.getDefaultFont((int)1);
    private Font hiddenFeatureFont;
    private Font expertFeatureFont = this.hiddenFeatureFont = Tools.getDefaultFont((int)2);

    public FeatureLabelToolkit() {
        this.setFeatureIcon(this.getFeatureIcon());
        this.setFeatureLabel(this.getFeatureLabel());
    }

    protected FeatureIcon createFeatureIcon() {
        return new FeatureIcon();
    }

    protected FeatureLabel createFeatureLabel() {
        FeatureLabel label = new FeatureLabel();
        label.setFeatureIcon(this.getFeatureIcon());
        label.setText("shit");
        return label;
    }

    public Font getDefaultFeatureFont() {
        return this.defaultFeatureFont;
    }

    public Font getExpertFeatureFont() {
        return this.expertFeatureFont;
    }

    protected Font getFeatureFont(FeatureDescriptor feature) {
        if (DefaultFeatureDescriptorComparator.isPreferredFeature((FeatureDescriptor)feature)) {
            return this.getPreferredFeatureFont();
        }
        if (feature.isExpert()) {
            return this.getExpertFeatureFont();
        }
        if (feature.isHidden()) {
            return this.getHiddenFeatureFont();
        }
        return this.getDefaultFeatureFont();
    }

    public FeatureIcon getFeatureIcon() {
        if (this.featureIcon == null) {
            this.featureIcon = this.createFeatureIcon();
        }
        return this.featureIcon;
    }

    protected Icon getFeatureIcon(FeatureDescriptor feature) {
        FeatureIcon icon = this.getFeatureIcon();
        if (icon != null) {
            icon.setFeature(feature);
        }
        return icon;
    }

    public FeatureLabel getFeatureLabel() {
        if (this.featureLabel == null) {
            this.featureLabel = this.createFeatureLabel();
        }
        return this.featureLabel;
    }

    public FeatureLabel getFeatureLabel(BeansToolkit btk, FeatureDescriptor feature, Object bean) {
        FeatureLabel label = this.getFeatureLabel();
        String name = null;
        Icon typeIcon = null;
        Font font = this.getDefaultFeatureFont();
        String toolTip = null;
        if (label == null || feature == null) {
            name = "";
            this.getFeatureIcon(null);
        } else {
            name = this.getFeatureText(feature, bean);
            font = this.getFeatureFont(feature);
            this.getFeatureIcon(feature);
            typeIcon = this.getFeatureTypeIcon(btk, feature, bean);
            toolTip = this.getFeatureToolTip(feature);
        }
        if (name == null) {
            name = "";
        }
        label.setText(name);
        label.setFont(font);
        label.setIcon(typeIcon);
        label.setFeatureIcon(this.featureIcon);
        label.setToolTipText(toolTip);
        return label;
    }

    protected String getFeatureText(FeatureDescriptor feature, Object bean) {
        BeanDescriptor descr;
        DynamicBean dynamic;
        BeanInfo info;
        if (bean != null && bean instanceof DynamicBean && (info = (dynamic = (DynamicBean)bean).getBeanInfo()) != null && (descr = info.getBeanDescriptor()) != null) {
            return String.valueOf(descr.getDisplayName());
        }
        if (feature instanceof BeanDescriptor) {
            return String.valueOf(bean);
        }
        return feature.getDisplayName();
    }

    protected String getFeatureToolTip(FeatureDescriptor feature) {
        return feature.getShortDescription();
    }

    protected Icon getFeatureTypeIcon(BeansToolkit btk, FeatureDescriptor feature, Object bean) {
        Icon icon;
        Class<?> clazz;
        BeanDescriptor descr;
        DynamicBean dynamic;
        BeanInfo info;
        FeatureLabel label = this.getFeatureLabel();
        if (label == null) {
            return null;
        }
        if (feature == null) {
            return null;
        }
        if (bean != null && btk != null && bean instanceof DynamicBean && (info = (dynamic = (DynamicBean)bean).getBeanInfo()) != null && (descr = info.getBeanDescriptor()) != null && (clazz = descr.getBeanClass()) != null && (icon = btk.getIcon(clazz)) != null) {
            return icon;
        }
        if (feature instanceof BeanDescriptor) {
            Icon rc = null;
            if (btk != null) {
                if (bean != null) {
                    rc = btk.getIcon(bean);
                } else {
                    BeanDescriptor descr2 = (BeanDescriptor)feature;
                    Class<?> beanClass = descr2.getBeanClass();
                    rc = btk.getIcon(beanClass);
                }
            }
            if (rc == null) {
                rc = label.getBeanIcon();
            }
            return rc;
        }
        if (feature instanceof PropertyDescriptor) {
            Icon rc;
            PropertyDescriptor descr3 = (PropertyDescriptor)feature;
            Class<?> beanClass = descr3.getPropertyType();
            Icon icon2 = rc = btk == null ? null : btk.getIcon(beanClass);
            if (rc == null) {
                rc = label.getPropertyIcon();
            }
            return rc;
        }
        if (feature instanceof MethodDescriptor) {
            return label.getMethodIcon();
        }
        if (feature instanceof EventSetDescriptor) {
            return label.getEventIcon();
        }
        return null;
    }

    public Font getHiddenFeatureFont() {
        return this.hiddenFeatureFont;
    }

    public Font getPreferredFeatureFont() {
        return this.preferredFeatureFont;
    }

    public String getToolTipText() {
        FeatureLabel label = this.getFeatureLabel();
        if (label == null) {
            return null;
        }
        return label.getToolTipText();
    }

    public void setDefaultFeatureFont(Font newDefaultFeatureFont) {
        this.defaultFeatureFont = newDefaultFeatureFont;
    }

    public void setExpertFeatureFont(Font newExpertFeatureFont) {
        this.expertFeatureFont = newExpertFeatureFont;
    }

    private void setFeatureIcon(FeatureIcon newFeatureIcon) {
        this.featureIcon = newFeatureIcon;
    }

    private void setFeatureLabel(FeatureLabel newFeatureLabel) {
        this.featureLabel = newFeatureLabel;
    }

    public void setHiddenFeatureFont(Font newHiddenFeatureFont) {
        this.hiddenFeatureFont = newHiddenFeatureFont;
    }

    public void setPreferredFeatureFont(Font newPreferredFeatureFont) {
        this.preferredFeatureFont = newPreferredFeatureFont;
    }
}

