/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.customizers;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.Platform;
import com.spacekiller.util.beans.AbstractBeansToolkit;
import com.spacekiller.util.beans.BeanArrayList;
import com.spacekiller.util.beans.BeanDropSupport;
import com.spacekiller.util.beans.DefaultBeanContextServiceProvider;
import com.spacekiller.util.beans.FeatureDescriptorFilter;
import com.spacekiller.util.beans.customizers.BeanSelectionContext;
import java.beans.Customizer;
import java.beans.VetoableChangeListener;
import java.beans.beancontext.BeanContextServiceProvider;
import java.beans.beancontext.BeanContextServicesSupport;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionListener;

public abstract class AbstractCustomizer
extends JPanel
implements Customizer {
    private static final long serialVersionUID = -5178916570988558478L;
    private static Logger logger = null;
    private BeanDropSupport beanDropSupport;

    public void addVetoableChangeListener(String name, VetoableChangeListener vcl) {
    }

    public static BeanContextServicesSupport createCustomizerBeanContext(BeansToolkit btk, FeatureDescriptorFilter filter, ListSelectionListener listSelectionListener, BeanSelectionContext beanSelectionContext) {
        BeanContextServicesSupport services = new BeanContextServicesSupport();
        DefaultBeanContextServiceProvider provider = new DefaultBeanContextServiceProvider();
        provider.registerServiceInstance(BeansToolkit.class, (Object)btk);
        services.addService(BeansToolkit.class, (BeanContextServiceProvider)provider);
        provider.registerServiceInstance(FeatureDescriptorFilter.class, (Object)filter);
        services.addService(FeatureDescriptorFilter.class, (BeanContextServiceProvider)provider);
        if (listSelectionListener != null) {
            provider.registerServiceInstance(ListSelectionListener.class, (Object)listSelectionListener);
            services.addService(ListSelectionListener.class, (BeanContextServiceProvider)provider);
        }
        if (beanSelectionContext != null) {
            provider.registerServiceInstance(BeanSelectionContext.class, (Object)beanSelectionContext);
            services.addService(BeanSelectionContext.class, (BeanContextServiceProvider)provider);
        }
        return services;
    }

    protected Iterator getBeans(Object bean) {
        if (bean == null) {
            return null;
        }
        if (bean instanceof BeanArrayList) {
            return ((BeanArrayList)bean).iterator();
        }
        final Object b = bean;
        return new Iterator(){
            private Object rc;
            private int index;
            {
                this.rc = b;
                this.index = 0;
            }

            @Override
            public boolean hasNext() {
                return this.index < 1;
            }

            public Object next() {
                ++this.index;
                return this.rc;
            }

            @Override
            public void remove() {
            }
        };
    }

    protected abstract BeanSelectionContext getBeanSelectionContext();

    protected BeansToolkit getBeansToolkit() {
        return Platform.getInstance().getBeansToolkit();
    }

    protected abstract ListSelectionListener getListSelectionListener();

    static Logger getLogger() {
        if (logger == null) {
            logger = Logger.getLogger("com.spacekiller.util.beans.customizers");
        }
        return logger;
    }

    protected void handleCustomizerException(Throwable e) {
        AbstractCustomizer.getLogger().log(Level.WARNING, e.getMessage(), e);
    }

    public void removeVetoableChangeListener(String name, VetoableChangeListener vcl) {
    }

    protected abstract void setBeanSelectionContext(BeanSelectionContext var1);

    protected abstract void setBeansToolkit(BeansToolkit var1);

    protected abstract void setListSelectionListener(ListSelectionListener var1);

    protected BeanDropSupport getBeanDropSupport() {
        BeansToolkit btk;
        if (this.beanDropSupport == null && (btk = this.getBeansToolkit()) != null) {
            AbstractBeansToolkit abt = (AbstractBeansToolkit)btk;
            this.setBeanDropSupport(abt.getBeanDropSupport());
        }
        return this.beanDropSupport;
    }

    protected void setBeanDropSupport(BeanDropSupport beanDropSupport) {
        this.beanDropSupport = beanDropSupport;
    }
}

