/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.customizers;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.beans.DynamicBean;
import com.spacekiller.util.beans.customizers.AbstractCustomizer;
import com.spacekiller.util.beans.model.AbstractBeanTableModel;
import java.awt.Font;
import java.awt.FontMetrics;
import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.beans.beancontext.BeanContext;
import java.util.Iterator;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.JTableHeader;

public abstract class AbstractTableCustomizer
extends AbstractCustomizer {
    private static final long serialVersionUID = -6149697170896071795L;

    protected abstract AbstractBeanTableModel createTableModel();

    protected abstract BeanContext getBeanContextOfBean(Object var1);

    protected AbstractBeanTableModel getTableModel(Object bean) throws Exception {
        AbstractBeanTableModel model = this.createTableModel();
        model.removeAllBeans();
        Class<?> beanType = null;
        if (bean != null) {
            int x = 0;
            Iterator i = this.getBeans(bean);
            while (i.hasNext()) {
                Object o = i.next();
                if (o != null && beanType == null) {
                    beanType = o.getClass();
                }
                model.insertBeanAt(o, x);
                model.setBeanContextOfBeanAt(this.getBeanContextOfBean(o), x);
                ++x;
            }
        }
        if (beanType != null) {
            this.initTablePropertyDescriptors(model, bean, beanType);
        }
        return model;
    }

    protected void initTable(JTable table, JScrollPane scrollPane) {
        FontMetrics fm;
        Font font;
        JViewport headerViewport;
        JTableHeader header = table.getTableHeader();
        if (header != null) {
            header.setOpaque(false);
            scrollPane.setColumnHeaderView(header);
        }
        if ((headerViewport = scrollPane.getColumnHeader()) != null) {
            headerViewport.setOpaque(false);
        }
        if ((font = header.getFont()) != null && (fm = this.getFontMetrics(font)) != null) {
            int rowHeight = fm.getHeight() + table.getRowMargin();
            table.setRowHeight(rowHeight);
        }
    }

    protected void initTablePropertyDescriptors(AbstractBeanTableModel model, BeanInfo info) {
        PropertyDescriptor[] descr = info.getPropertyDescriptors();
        for (int c = 0; c < descr.length; ++c) {
            PropertyDescriptor pd = descr[c];
            if (pd == null || pd.getReadMethod() == null) continue;
            model.addPropertyDescriptor(pd);
        }
    }

    protected void initTablePropertyDescriptors(AbstractBeanTableModel model, Object bean, Class beanType) throws Exception {
        BeansToolkit btk = this.getBeansToolkit();
        if (btk == null) {
            throw new NullPointerException("BeansToolkit==null");
        }
        BeanInfo info = null;
        if (bean != null && bean instanceof DynamicBean) {
            info = ((DynamicBean)bean).getBeanInfo();
            if (info == null) {
                info = btk.getBeanInfo(beanType);
            }
        } else {
            info = btk.getBeanInfo(beanType);
        }
        if (info != null) {
            this.initTablePropertyDescriptors(model, info);
        }
    }
}

