/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.customizers;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.Sys;
import com.spacekiller.util.beans.AbstractBeansToolkit;
import com.spacekiller.util.beans.AnchorlessBeanContext;
import com.spacekiller.util.beans.BeanDropSupport;
import com.spacekiller.util.beans.ClipboardManager;
import com.spacekiller.util.beans.DefaultDragSourceHandler;
import com.spacekiller.util.beans.TypeContext;
import com.spacekiller.util.beans.components.BeanListCellRenderer;
import com.spacekiller.util.beans.components.FeatureLabelToolkit;
import com.spacekiller.util.beans.customizers.AbstractCustomizer;
import com.spacekiller.util.beans.customizers.BeanSelectionContext;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Customizer;
import java.beans.beancontext.BeanContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CollectionCustomizer
extends AbstractCustomizer
implements Customizer {
    private static final long serialVersionUID = -1274877112229982308L;
    private BeansToolkit beansToolkit;
    private BeanSelectionContext beanSelectionContext;
    private ListSelectionListener listSelectionListener;
    private BeanDropSupport beanDropSupport;
    private Collection collection;
    private boolean sortSet;
    private DragGestureHandler dragGestureHandler = new DragGestureHandler();
    private DefaultDragSourceHandler dragSourceHandler = new DefaultDragSourceHandler();
    private DropTargetHandler dropTargetHandler = new DropTargetHandler();
    private DropBeanContext dropBeanContext;
    private JScrollPane jScrollPane = null;
    private JList jList = null;
    private JPanel jPanel = null;
    private JToolBar jToolBar = null;
    private JButton jButtonRemove = null;
    private JButton jButtonPaste = null;
    private JPanel jPanel1 = null;
    private JButton jButtonRefresh = null;
    private JPanel jPanel2 = null;
    private JButton jButtonMoveUp = null;
    private JPanel jPanel3 = null;
    private JButton jButtonMoveDown = null;
    private static final Logger logger = Logger.getLogger(CollectionCustomizer.class.getName());

    public CollectionCustomizer() {
        this.initialize();
        this.initCollectionCustomizer();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.weightx = 0.0;
        gridBagConstraints1.weighty = 0.0;
        gridBagConstraints1.anchor = 13;
        gridBagConstraints1.gridy = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(298, 237));
        this.add((Component)this.getJScrollPane(), gridBagConstraints);
        this.add((Component)this.getJPanel(), gridBagConstraints1);
    }

    @Override
    public void setObject(Object bean) {
        this.setCollection((Collection)bean);
    }

    public Collection getCollection() {
        return this.collection;
    }

    public void setCollection(Collection collection) {
        this.collection = collection;
        this.sortSet = false;
        if (collection != null && !(collection instanceof List) && collection instanceof Set && !(collection instanceof SortedSet)) {
            this.sortSet = true;
        }
        this.refresh();
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setOpaque(false);
            this.jScrollPane.setViewportView(this.getJList());
        }
        return this.jScrollPane;
    }

    private JList getJList() {
        if (this.jList == null) {
            this.jList = new JList();
            this.jList.setOpaque(true);
            this.jList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    CollectionCustomizer.this.checkEnable();
                }
            });
        }
        return this.jList;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.gridx = 0;
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.add((Component)this.getJToolBar(), gridBagConstraints3);
        }
        return this.jPanel;
    }

    @Override
    public BeansToolkit getBeansToolkit() {
        if (this.beansToolkit == null) {
            return super.getBeansToolkit();
        }
        return this.beansToolkit;
    }

    @Override
    public void setBeansToolkit(BeansToolkit beansToolkit) {
        this.beansToolkit = beansToolkit;
        if (beansToolkit != null) {
            FeatureLabelToolkit flt = new FeatureLabelToolkit();
            this.getJList().setCellRenderer(new BeanListCellRenderer(beansToolkit, flt));
            if (this.beanDropSupport == null) {
                AbstractBeansToolkit abt = (AbstractBeansToolkit)beansToolkit;
                this.setBeanDropSupport(abt.getBeanDropSupport());
            }
        }
    }

    @Override
    public BeanSelectionContext getBeanSelectionContext() {
        return this.beanSelectionContext;
    }

    @Override
    public void setBeanSelectionContext(BeanSelectionContext beanSelectionContext) {
        this.beanSelectionContext = beanSelectionContext;
    }

    @Override
    public ListSelectionListener getListSelectionListener() {
        return this.listSelectionListener;
    }

    @Override
    public void setListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listSelectionListener = listSelectionListener;
    }

    protected JToolBar getJToolBar() {
        if (this.jToolBar == null) {
            this.jToolBar = new JToolBar();
            this.jToolBar.setFloatable(false);
            this.jToolBar.setOpaque(false);
            this.jToolBar.add(this.getJButtonRefresh());
            this.jToolBar.add(this.getJPanel2());
            this.jToolBar.add(this.getJButtonPaste());
            this.jToolBar.add(this.getJPanel1());
            this.jToolBar.add(this.getJButtonMoveUp());
            this.jToolBar.add(this.getJButtonMoveDown());
            this.jToolBar.add(this.getJPanel3());
            this.jToolBar.add(this.getJButtonRemove());
        }
        return this.jToolBar;
    }

    private JButton getJButtonRemove() {
        if (this.jButtonRemove == null) {
            this.jButtonRemove = new JButton();
            this.jButtonRemove.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/beans/editors/icons/error2.gif")));
            this.jButtonRemove.setToolTipText("Remove selected element(s)");
            this.jButtonRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CollectionCustomizer.this.actionRemove();
                }
            });
        }
        return this.jButtonRemove;
    }

    private JButton getJButtonPaste() {
        if (this.jButtonPaste == null) {
            this.jButtonPaste = new JButton();
            this.jButtonPaste.setToolTipText("Paste new element(s)");
            this.jButtonPaste.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/beans/editors/icons/paste.gif")));
            this.jButtonPaste.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CollectionCustomizer.this.actionPaste();
                }
            });
        }
        return this.jButtonPaste;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            this.jPanel1 = new JPanel();
            this.jPanel1.setMinimumSize(new Dimension(8, 8));
            this.jPanel1.setMaximumSize(new Dimension(8, 8));
            this.jPanel1.setOpaque(false);
            this.jPanel1.setPreferredSize(new Dimension(8, 8));
        }
        return this.jPanel1;
    }

    protected void initCollectionCustomizer() {
        this.checkEnable();
        this.setBeansToolkit(this.getBeansToolkit());
        this.setPreferredSize(new Dimension(300, 300));
        DropTarget dt = new DropTarget(this.getJList(), this.dropTargetHandler);
        this.getJList().setDropTarget(dt);
        DragSource ds = new DragSource();
        ds.addDragSourceListener((DragSourceListener)this.dragSourceHandler);
        int actions = 0x40000003;
        DragGestureRecognizer dgr = ds.createDefaultDragGestureRecognizer(this.getJList(), actions, this.dragGestureHandler);
        dgr.getComponent();
    }

    protected void checkEnable() {
        boolean enablePaste = false;
        boolean enableRemove = false;
        boolean enableMoveUp = false;
        boolean enableMoveDown = false;
        if (this.collection != null) {
            boolean sel;
            enableRemove = sel = !this.getJList().isSelectionEmpty();
            enablePaste = true;
            if (sel && this.collection instanceof List) {
                enableMoveUp = !this.getJList().isSelectedIndex(0);
                int size = this.getJList().getModel().getSize();
                enableMoveDown = !this.getJList().isSelectedIndex(size - 1);
            }
        }
        this.getJButtonPaste().setEnabled(enablePaste);
        this.getJButtonMoveUp().setEnabled(enableMoveUp);
        this.getJButtonMoveDown().setEnabled(enableMoveDown);
        this.getJButtonRemove().setEnabled(enableRemove);
    }

    public void refresh() {
        DefaultListModel model = new DefaultListModel();
        TreeSet coll = this.getCollection();
        if (coll != null) {
            if (this.sortSet) {
                try {
                    TreeSet tree = new TreeSet(new SetEntryComparator());
                    tree.addAll(coll);
                    coll = tree;
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            Iterator i = coll.iterator();
            while (i.hasNext()) {
                model.addElement(i.next());
            }
        }
        this.getJList().setModel(model);
        this.checkEnable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void actionPaste() {
        Collection coll = this.getCollection();
        if (coll == null) {
            return;
        }
        BeansToolkit btk = this.getBeansToolkit();
        if (btk == null) {
            return;
        }
        try {
            AbstractBeansToolkit abt = (AbstractBeansToolkit)btk;
            ClipboardManager cm = abt.getClipboardManager();
            if (cm == null) {
                return;
            }
            Collection objects = cm.getObjects();
            if (objects == null) {
                return;
            }
            if (objects.isEmpty()) {
                return;
            }
            try {
                for (Object obj : objects) {
                    if (coll.add(obj)) continue;
                    logger.fine("DEBUG: failed to add element into collection: " + coll + ", element=" + obj);
                }
            }
            finally {
                this.refresh();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void actionRemove() {
        Collection coll = this.getCollection();
        if (coll == null) {
            return;
        }
        int[] sel = this.getJList().getSelectedIndices();
        if (sel.length < 1) {
            return;
        }
        try {
            ListModel model = this.getJList().getModel();
            for (int i = sel.length - 1; i >= 0; --i) {
                int index = sel[i];
                Object element = model.getElementAt(index);
                this.removeElement(coll, element, index);
            }
        }
        finally {
            this.refresh();
        }
    }

    protected void removeElement(Collection coll, Object element, int index) {
        List list;
        if (coll instanceof List && (list = (List)coll).get(index) == element) {
            list.remove(index);
            return;
        }
        coll.remove(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void actionMoveUp() {
        int i;
        int[] sel = this.getJList().getSelectedIndices();
        if (sel.length < 1) {
            return;
        }
        List list = (List)this.collection;
        try {
            ListModel model = this.getJList().getModel();
            for (i = 0; i < sel.length; ++i) {
                int index = sel[i];
                if (index <= 0) continue;
                Object element = model.getElementAt(index);
                this.moveElement(list, element, index, index - 1);
            }
            this.refresh();
        }
        catch (Throwable throwable) {
            this.refresh();
            int[] newSel = new int[sel.length];
            for (int i2 = 0; i2 < sel.length; ++i2) {
                newSel[i2] = sel[i2] - 1;
            }
            this.getJList().setSelectedIndices(newSel);
            throw throwable;
        }
        int[] newSel = new int[sel.length];
        for (i = 0; i < sel.length; ++i) {
            newSel[i] = sel[i] - 1;
        }
        this.getJList().setSelectedIndices(newSel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void actionMoveDown() {
        int i;
        int[] sel = this.getJList().getSelectedIndices();
        if (sel.length < 1) {
            return;
        }
        List list = (List)this.collection;
        try {
            ListModel model = this.getJList().getModel();
            for (i = sel.length - 1; i >= 0; --i) {
                int index = sel[i];
                if (index >= list.size() - 1) continue;
                Object element = model.getElementAt(index);
                this.moveElement(list, element, index, index + 1);
            }
            this.refresh();
        }
        catch (Throwable throwable) {
            this.refresh();
            int[] newSel = new int[sel.length];
            for (int i2 = 0; i2 < sel.length; ++i2) {
                newSel[i2] = sel[i2] + 1;
            }
            this.getJList().setSelectedIndices(newSel);
            throw throwable;
        }
        int[] newSel = new int[sel.length];
        for (i = 0; i < sel.length; ++i) {
            newSel[i] = sel[i] + 1;
        }
        this.getJList().setSelectedIndices(newSel);
    }

    protected void moveElement(List list, Object element, int index, int newIndex) {
        if (index == newIndex) {
            return;
        }
        if (list.get(index) == element) {
            Object obj = list.remove(index);
            list.add(newIndex, obj);
        }
    }

    private JButton getJButtonRefresh() {
        if (this.jButtonRefresh == null) {
            this.jButtonRefresh = new JButton();
            this.jButtonRefresh.setToolTipText("Refresh list");
            this.jButtonRefresh.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/beans/editors/icons/refresh_view.gif")));
            this.jButtonRefresh.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CollectionCustomizer.this.refresh();
                }
            });
        }
        return this.jButtonRefresh;
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            this.jPanel2 = new JPanel();
            this.jPanel2.setMaximumSize(new Dimension(8, 8));
            this.jPanel2.setPreferredSize(new Dimension(8, 8));
            this.jPanel2.setOpaque(false);
            this.jPanel2.setMinimumSize(new Dimension(8, 8));
        }
        return this.jPanel2;
    }

    @Override
    public BeanDropSupport getBeanDropSupport() {
        return this.beanDropSupport;
    }

    @Override
    public void setBeanDropSupport(BeanDropSupport beanDropSupport) {
        this.beanDropSupport = beanDropSupport;
    }

    protected void handleException(Throwable e) {
        logger.log(Level.SEVERE, e.getMessage(), e);
    }

    protected BeanContext getTargetBeanContext(int x, int y) {
        Rectangle rect;
        if (this.collection == null) {
            return null;
        }
        Point p = new Point(x, y);
        int index = this.getJList().locationToIndex(p);
        if (index >= 0 && (rect = this.getJList().getCellBounds(index, index)) != null && !rect.contains(x, y)) {
            index = -1;
        }
        if (index < 0) {
            index = this.collection.size();
        }
        logger.fine("drop: x=" + x + ", y=" + y + " => index=" + index);
        if (this.dropBeanContext == null) {
            this.dropBeanContext = new DropBeanContext();
        }
        this.dropBeanContext.setIndex(index);
        this.dropBeanContext.setSupportedType(Object.class);
        return this.dropBeanContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean drop(int index, Object targetChild) {
        Collection coll = this.collection;
        if (coll == null) {
            return false;
        }
        try {
            logger.fine("drop: index=" + index + ", element=" + targetChild);
            if (index >= 0 && coll instanceof List) {
                List list = (List)coll;
                list.add(index, targetChild);
                boolean bl = true;
                return bl;
            }
            boolean bl = coll.add(targetChild);
            return bl;
        }
        finally {
            this.refresh();
        }
    }

    private JButton getJButtonMoveUp() {
        if (this.jButtonMoveUp == null) {
            this.jButtonMoveUp = new JButton();
            this.jButtonMoveUp.setToolTipText("Move up selected element(s)");
            this.jButtonMoveUp.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/beans/editors/icons/pageup.gif")));
            this.jButtonMoveUp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CollectionCustomizer.this.actionMoveUp();
                }
            });
        }
        return this.jButtonMoveUp;
    }

    private JPanel getJPanel3() {
        if (this.jPanel3 == null) {
            this.jPanel3 = new JPanel();
            this.jPanel3.setMaximumSize(new Dimension(8, 8));
            this.jPanel3.setPreferredSize(new Dimension(8, 8));
            this.jPanel3.setOpaque(false);
            this.jPanel3.setMinimumSize(new Dimension(8, 8));
        }
        return this.jPanel3;
    }

    private JButton getJButtonMoveDown() {
        if (this.jButtonMoveDown == null) {
            this.jButtonMoveDown = new JButton();
            this.jButtonMoveDown.setToolTipText("Move down selected element(s)");
            this.jButtonMoveDown.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/beans/editors/icons/pagedown.gif")));
            this.jButtonMoveDown.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CollectionCustomizer.this.actionMoveDown();
                }
            });
        }
        return this.jButtonMoveDown;
    }

    protected static class SetEntryComparator
    implements Comparator {
        protected SetEntryComparator() {
        }

        public int compare(Object a, Object b) {
            int bh;
            String sb;
            if (a == null) {
                return b == null ? 0 : -1;
            }
            if (b == null) {
                return 1;
            }
            String sa = a.toString();
            int rc = sa.compareTo(sb = b.toString());
            if (rc != 0) {
                return rc;
            }
            int ah = System.identityHashCode(a);
            return ah < (bh = System.identityHashCode(b)) ? -1 : 1;
        }
    }

    protected class DragGestureHandler
    implements DragGestureListener {
        protected DragGestureHandler() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            ArrayList beans = new ArrayList();
            int[] sel = CollectionCustomizer.this.getJList().getSelectedIndices();
            ListModel model = CollectionCustomizer.this.getJList().getModel();
            if (model == null) {
                return;
            }
            for (int i = 0; i < sel.length; ++i) {
                int index = sel[i];
                Object obj = model.getElementAt(index);
                beans.add(obj);
            }
            if (beans.isEmpty()) {
                return;
            }
            CollectionCustomizer.this.dragSourceHandler.setBeanDropSupport(CollectionCustomizer.this.getBeanDropSupport());
            CollectionCustomizer.this.dragSourceHandler.startDrag(dge, beans);
        }
    }

    protected class DropBeanContext
    extends AnchorlessBeanContext
    implements TypeContext {
        private static final long serialVersionUID = -4846278274704762661L;
        private Set supportedTypes = new HashSet();
        private int index;

        public Iterator getSupportedTypes() {
            return this.supportedTypes.iterator();
        }

        public boolean supports(Class type) {
            if (this.supportedTypes.contains(type)) {
                return true;
            }
            for (Class clazz : this.supportedTypes) {
                if (!clazz.isAssignableFrom(type)) continue;
                return true;
            }
            return false;
        }

        public boolean supports(Object bean) {
            return this.supports(bean.getClass());
        }

        public boolean add(Object targetChild) {
            if (targetChild == null) {
                return false;
            }
            if (!this.supports(targetChild)) {
                return false;
            }
            return CollectionCustomizer.this.drop(this.index, targetChild);
        }

        protected void setSupportedTypes(Set supportedTypes) {
            this.supportedTypes = supportedTypes;
        }

        protected void setSupportedType(Class type) {
            this.supportedTypes.clear();
            this.supportedTypes.add(type);
        }

        protected int getIndex() {
            return this.index;
        }

        protected void setIndex(int index) {
            this.index = index;
        }
    }

    protected class DropTargetHandler
    implements DropTargetListener {
        private Collection dropBeans = new ArrayList();

        protected DropTargetHandler() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            if (CollectionCustomizer.this.beanDropSupport == null) {
                return;
            }
            Point pos = dtde.getLocation();
            BeanContext target = CollectionCustomizer.this.getTargetBeanContext(pos.x, pos.y);
            this.dropBeans.clear();
            CollectionCustomizer.this.beanDropSupport.enumerateDropBeans(target, dtde, this.dropBeans);
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
            this.dropBeans.clear();
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            if (CollectionCustomizer.this.beanDropSupport == null) {
                return;
            }
            Point pos = dtde.getLocation();
            BeanContext target = CollectionCustomizer.this.getTargetBeanContext(pos.x, pos.y);
            ArrayList temp = new ArrayList();
            boolean searchSuccess = CollectionCustomizer.this.beanDropSupport.enumerateDropBeans(target, dtde, temp);
            if (target != null && searchSuccess) {
                this.dropBeans.clear();
                this.dropBeans.addAll(temp);
                boolean accepted = false;
                for (Object o : this.dropBeans) {
                    if (o == null || !CollectionCustomizer.this.beanDropSupport.acceptDropBean(target, o)) continue;
                    accepted = true;
                    break;
                }
                if (accepted) {
                    dtde.acceptDrag(dtde.getDropAction());
                    return;
                }
                dtde.rejectDrag();
                return;
            }
            dtde.acceptDrag(dtde.getDropAction());
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            if (CollectionCustomizer.this.beanDropSupport == null) {
                return;
            }
            Transferable trans = dtde.getTransferable();
            int dropAction = dtde.getDropAction();
            Point pos = dtde.getLocation();
            BeanContext target = CollectionCustomizer.this.getTargetBeanContext(pos.x, pos.y);
            Sys.println((String)(" - Drop target context: " + target));
            ArrayList temp = new ArrayList();
            boolean enumSuccess = CollectionCustomizer.this.beanDropSupport.enumerateDropBeans(target, trans, temp);
            if (enumSuccess) {
                this.dropBeans.clear();
                this.dropBeans.addAll(temp);
            }
            Sys.println((String)(" - Drop beans: " + this.dropBeans.size()));
            if (!this.dropBeans.isEmpty()) {
                dtde.acceptDrop(dropAction);
                if (target != null) {
                    try {
                        Sys.println((String)" - Drop beans..");
                        CollectionCustomizer.this.beanDropSupport.dropBeans(this.dropBeans, target, dropAction);
                        Sys.println((String)" - Drop completed.");
                        dtde.dropComplete(true);
                        this.dropBeans.clear();
                        return;
                    }
                    catch (Exception e) {
                        CollectionCustomizer.this.handleException(e);
                    }
                } else {
                    Sys.println((String)"DEBUG: drop target is null!");
                }
            }
            Sys.println((String)" - Drop failed!");
            try {
                dtde.rejectDrop();
            }
            catch (InvalidDnDOperationException e) {
                // empty catch block
            }
            dtde.dropComplete(false);
            this.dropBeans.clear();
        }
    }
}

