/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.customizers;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.beans.customizers.BeanTableCustomizer;
import com.spacekiller.util.beans.customizers.BeanTreeCustomizer;
import com.spacekiller.util.beans.customizers.PropertySheetCustomizer;
import com.spacekiller.util.beans.customizers.PropertyTableCustomizer;
import com.spacekiller.util.beans.customizers.TabbedCustomizer;
import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class DefaultCustomizer
extends TabbedCustomizer {
    private static final long serialVersionUID = 1048289794797264100L;
    private Class[] defaultCustomizerClasses;
    private Hashtable customizerTitles = new Hashtable();
    private Hashtable customizerIcons = new Hashtable();
    private Hashtable customizerTips = new Hashtable();
    private boolean alwaysUseDefaultCustomizers = true;
    private static final Logger logger = Logger.getLogger(DefaultCustomizer.class.getName());

    public DefaultCustomizer() {
        this.initDefaultCustomizer();
    }

    public void deregisterCustomizerType(Class customizerClass) {
        this.customizerTitles.remove(customizerClass);
        this.customizerIcons.remove(customizerClass);
        this.customizerTips.remove(customizerClass);
    }

    protected void enumerateCustomizerClasses(Class beanType, Collection dstClasses) {
        Class[] def;
        if (beanType == null) {
            return;
        }
        BeansToolkit tk = this.getBeansToolkit();
        int num = 0;
        if (tk != null) {
            try {
                Iterator i = tk.getCustomizerClasses(beanType);
                while (i.hasNext()) {
                    Class c = (Class)i.next();
                    if (c == null) continue;
                    dstClasses.add(c);
                    ++num;
                }
            }
            catch (Throwable e) {
                this.handleCustomizerException(e);
            }
        }
        if ((num < 1 || this.isAlwaysUseDefaultCustomizers()) && (def = this.getDefaultCustomizerClasses()) != null) {
            for (int c = 0; c < def.length; ++c) {
                if (def[c] == null) continue;
                dstClasses.add(def[c]);
            }
        }
    }

    protected Icon getCustomizerIcon(Class customizerClass, int tabIndex) {
        Icon rc = (Icon)this.customizerIcons.get(customizerClass);
        if (rc != null) {
            return rc;
        }
        try {
            Image image;
            BeanInfo beanInfo = this.getBeansToolkit().getBeanInfo(customizerClass);
            if (beanInfo != null && (image = beanInfo.getIcon(1)) != null) {
                rc = new ImageIcon(image);
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return rc;
    }

    protected String getCustomizerTip(Class customizerClass, int tabIndex) {
        String rc = (String)this.customizerTips.get(customizerClass);
        if (rc != null) {
            return rc;
        }
        try {
            BeanDescriptor descr;
            BeanInfo beanInfo = this.getBeansToolkit().getBeanInfo(customizerClass);
            if (beanInfo != null && (descr = beanInfo.getBeanDescriptor()) != null) {
                rc = descr.getShortDescription();
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return rc;
    }

    protected String getCustomizerTitle(Class customizerClass, int tabIndex) {
        String rc = (String)this.customizerTitles.get(customizerClass);
        if (rc != null) {
            return rc;
        }
        try {
            BeanDescriptor descr;
            BeanInfo beanInfo = this.getBeansToolkit().getBeanInfo(customizerClass);
            if (beanInfo != null && (descr = beanInfo.getBeanDescriptor()) != null) {
                return descr.getDisplayName();
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        String name = customizerClass.getName();
        int i = name.lastIndexOf(".");
        if (i >= 0) {
            name = name.substring(i + 1);
        }
        return name;
    }

    public Class[] getDefaultCustomizerClasses() {
        return this.defaultCustomizerClasses;
    }

    protected void initDefaultCustomizer() {
        this.defaultCustomizerClasses = new Class[]{PropertySheetCustomizer.class, PropertyTableCustomizer.class, BeanTableCustomizer.class, BeanTreeCustomizer.class};
        this.registerCustomizerType(PropertySheetCustomizer.class, "", this.getIcon("/com/spacekiller/util/beans/editors/icons/selectbean_view.gif"), "Property sheet");
        this.registerCustomizerType(PropertyTableCustomizer.class, "", this.getIcon("/com/spacekiller/util/beans/editors/icons/beantable.gif"), "Table of bean properties");
        this.registerCustomizerType(BeanTableCustomizer.class, "", this.getIcon("/com/spacekiller/util/beans/editors/icons/beantable2.gif"), "Bean table");
        this.registerCustomizerType(BeanTreeCustomizer.class, "", this.getIcon("/com/spacekiller/util/beans/editors/icons/beantree.gif"), "Bean tree");
    }

    public boolean isAlwaysUseDefaultCustomizers() {
        return this.alwaysUseDefaultCustomizers;
    }

    protected void refreshCustomizerTabs(Object bean) {
        int c;
        ArrayList customizerClasses = new ArrayList();
        Class<?> beanType = bean == null ? null : bean.getClass();
        this.enumerateCustomizerClasses(beanType, customizerClasses);
        int oldTabCount = this.getCustomizerCount();
        int newTabCount = customizerClasses.size();
        for (c = 0; c < newTabCount; ++c) {
            Class custClass = (Class)customizerClasses.get(c);
            String title = this.getCustomizerTitle(custClass, c);
            Icon icon = this.getCustomizerIcon(custClass, c);
            String tip = this.getCustomizerTip(custClass, c);
            if (c >= oldTabCount) {
                this.insertCustomizerAt(custClass, c, title, icon, tip);
                continue;
            }
            this.setCustomizerAt(custClass, c, title, icon, tip);
        }
        for (c = newTabCount; c < oldTabCount; ++c) {
            this.removeCustomizerAt(newTabCount);
        }
        if (newTabCount < 1) {
            // empty if block
        }
    }

    public void registerCustomizerType(Class customizerClass, String title, Icon icon, String tip) {
        if (title != null) {
            this.customizerTitles.put(customizerClass, title);
        }
        if (icon != null) {
            this.customizerIcons.put(customizerClass, icon);
        }
        if (tip != null) {
            this.customizerTips.put(customizerClass, tip);
        }
    }

    public void setAlwaysUseDefaultCustomizers(boolean newAlwaysUseDefaultCustomizers) {
        this.alwaysUseDefaultCustomizers = newAlwaysUseDefaultCustomizers;
    }

    public void setDefaultCustomizerClasses(Class[] newDefaultCustomizerClasses) {
        this.defaultCustomizerClasses = newDefaultCustomizerClasses;
    }

    @Override
    public void setObject(Object newObject) {
        this.refreshCustomizerTabs(newObject);
        super.setObject(newObject);
    }
}

