/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.customizers;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.Sys;
import com.spacekiller.util.beans.AnchorlessBeanContext;
import com.spacekiller.util.beans.BeanDropSupport;
import com.spacekiller.util.beans.BeanEditor;
import com.spacekiller.util.beans.DefaultDragSourceHandler;
import com.spacekiller.util.beans.FeatureDescriptorFilter;
import com.spacekiller.util.beans.TypeContext;
import com.spacekiller.util.beans.components.BeanTable;
import com.spacekiller.util.beans.customizers.AbstractTableCustomizer;
import com.spacekiller.util.beans.customizers.BeanSelectionContext;
import com.spacekiller.util.beans.model.AbstractBeanTableModel;
import com.spacekiller.util.beans.model.DefaultPropertyTableModel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyDescriptor;
import java.beans.beancontext.BeanContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class PropertyTableCustomizer
extends AbstractTableCustomizer
implements BeanEditor {
    private static final long serialVersionUID = 1229286216944765565L;
    private BeansToolkit beansToolkit;
    private FeatureDescriptorFilter featureDescriptorFilter;
    private DragGestureHandler dragGestureHandler = new DragGestureHandler();
    private DefaultDragSourceHandler dragSourceHandler = new DefaultDragSourceHandler();
    private DropTargetHandler dropTargetHandler = new DropTargetHandler();
    private DropBeanContext dropBeanContext;
    private JScrollPane ivjJScrollPane1 = null;
    private ListSelectionListener listSelectionListener;
    private BeanTable fieldTable = new BeanTable(null);
    private Object bean;
    private BeanContext beanContextOfBean;
    private static final Logger logger = Logger.getLogger(PropertyTableCustomizer.class.getName());

    public PropertyTableCustomizer() {
        this.initialize();
        this.tableCustomizer_Initialize();
    }

    @Override
    protected AbstractBeanTableModel createTableModel() {
        return new DefaultPropertyTableModel(this.getBeansToolkit());
    }

    public Object getBean() {
        return this.bean;
    }

    public BeanContext getBeanContextOfBean() {
        return this.beanContextOfBean;
    }

    @Override
    protected BeanContext getBeanContextOfBean(Object bean) {
        return this.getBeanContextOfBean();
    }

    @Override
    public BeanSelectionContext getBeanSelectionContext() {
        return null;
    }

    @Override
    public BeansToolkit getBeansToolkit() {
        if (this.beansToolkit == null) {
            return super.getBeansToolkit();
        }
        return this.beansToolkit;
    }

    public FeatureDescriptorFilter getFeatureDescriptorFilter() {
        return this.featureDescriptorFilter;
    }

    private JScrollPane getJScrollPane1() {
        if (this.ivjJScrollPane1 == null) {
            try {
                this.ivjJScrollPane1 = new JScrollPane();
                this.ivjJScrollPane1.setName("JScrollPane1");
                this.ivjJScrollPane1.setVerticalScrollBarPolicy(22);
                this.ivjJScrollPane1.setHorizontalScrollBarPolicy(32);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJScrollPane1;
    }

    @Override
    public ListSelectionListener getListSelectionListener() {
        return this.listSelectionListener;
    }

    public BeanTable getTable() {
        return this.fieldTable;
    }

    private void handleException(Throwable exception) {
        this.handleCustomizerException(exception);
    }

    private void initialize() {
        this.setName("TableCustomizer");
        this.setLayout(new GridBagLayout());
        this.setSize(378, 273);
        GridBagConstraints constraintsJScrollPane1 = new GridBagConstraints();
        constraintsJScrollPane1.gridx = 0;
        constraintsJScrollPane1.gridy = 0;
        constraintsJScrollPane1.fill = 1;
        constraintsJScrollPane1.weightx = 1.0;
        constraintsJScrollPane1.weighty = 1.0;
        this.add((Component)this.getJScrollPane1(), constraintsJScrollPane1);
    }

    public static void main(String[] args) {
        try {
            JFrame frame = new JFrame();
            PropertyTableCustomizer aPropertyTableCustomizer = new PropertyTableCustomizer();
            frame.setContentPane(aPropertyTableCustomizer);
            frame.setSize(aPropertyTableCustomizer.getSize());
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            frame.setVisible(true);
            Insets insets = frame.getInsets();
            frame.setSize(frame.getWidth() + insets.left + insets.right, frame.getHeight() + insets.top + insets.bottom);
            frame.setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of com.spacekiller.util.beans.customizers.AbstractTableCustomizer");
            logger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    public void setBean(Object newBean) {
        this.bean = newBean;
        this.setObject(newBean);
    }

    public void setBeanContextOfBean(BeanContext newBeanContextOfBean) {
        this.beanContextOfBean = newBeanContextOfBean;
    }

    @Override
    public void setBeanSelectionContext(BeanSelectionContext ctx) {
    }

    @Override
    public void setBeansToolkit(BeansToolkit newBeansToolkit) {
        this.beansToolkit = newBeansToolkit;
    }

    public void setFeatureDescriptorFilter(FeatureDescriptorFilter newFeatureDescriptorFilter) {
        this.featureDescriptorFilter = newFeatureDescriptorFilter;
    }

    @Override
    public void setListSelectionListener(ListSelectionListener newListSelectionListener) {
        this.listSelectionListener = newListSelectionListener;
    }

    @Override
    public void setObject(Object bean) {
        try {
            AbstractBeanTableModel model = this.getTableModel(bean);
            this.getTable().setColumnModel(model.createTableColumnModel(this.getBeanContextOfBean()));
            this.getTable().setModel(model);
        }
        catch (Exception e) {
            this.handleCustomizerException(e);
        }
    }

    void setTable(BeanTable table) {
        BeanTable oldValue = this.fieldTable;
        this.fieldTable = table;
        this.firePropertyChange("table", oldValue, table);
    }

    private void tableCustomizer_Initialize() {
        this.setOpaque(false);
        this.getJScrollPane1().setViewportView(this.getTable());
        BeanTable table = this.getTable();
        table.setAutoCreateColumnsFromModel(false);
        table.getTableHeader().setReorderingAllowed(false);
        table.setOpaque(false);
        table.setAutoResizeMode(0);
        this.initTable(table, this.getJScrollPane1());
        DragSource ds = new DragSource();
        ds.addDragSourceListener((DragSourceListener)this.dragSourceHandler);
        int actions = 0x40000003;
        DragGestureRecognizer dgr = ds.createDefaultDragGestureRecognizer(this.getTable(), actions, this.dragGestureHandler);
        dgr.getComponent();
        DropTarget dt = new DropTarget(table, this.dropTargetHandler);
        table.setDropTarget(dt);
    }

    protected BeanContext getTargetBeanContext(int x, int y) {
        Point p = new Point(x, y);
        int row = this.getTable().rowAtPoint(p);
        int col = this.getTable().columnAtPoint(p);
        if (row < 0 || col < 0) {
            return null;
        }
        AbstractBeanTableModel model = (AbstractBeanTableModel)this.getTable().getModel();
        PropertyDescriptor descr = model.getPropertyDescriptorAt(row, col);
        if (descr == null) {
            return null;
        }
        if (descr.getWriteMethod() == null) {
            return null;
        }
        Class<?> propertyType = descr.getPropertyType();
        if (propertyType == null) {
            return null;
        }
        logger.fine("Property: " + descr.getName() + " >> " + propertyType);
        if (propertyType == String.class) {
            propertyType = Object.class;
        }
        if (propertyType == StringBuffer.class) {
            propertyType = Object.class;
        }
        if (propertyType.isPrimitive()) {
            propertyType = this.getPrimitiveWrapperClass(propertyType);
        }
        if (this.dropBeanContext == null) {
            this.dropBeanContext = new DropBeanContext();
        }
        this.dropBeanContext.setRow(row);
        this.dropBeanContext.setColumn(col);
        this.dropBeanContext.setSupportedType(propertyType);
        return this.dropBeanContext;
    }

    protected Class getPrimitiveWrapperClass(Class type) {
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        throw new UnsupportedOperationException("Invalid primitive type: " + type);
    }

    protected boolean drop(int row, int column, Object value) {
        AbstractBeanTableModel model = (AbstractBeanTableModel)this.getTable().getModel();
        PropertyDescriptor descr = model.getPropertyDescriptorAt(row, column);
        if (descr == null) {
            return false;
        }
        if (descr.getWriteMethod() == null) {
            return false;
        }
        Class<?> propertyType = descr.getPropertyType();
        if (propertyType == null) {
            return false;
        }
        if (propertyType == String.class) {
            value = String.valueOf(value);
        }
        if (propertyType == StringBuffer.class && !(value instanceof StringBuffer)) {
            value = new StringBuffer(String.valueOf(value));
        }
        model.setValueAt(value, row, column);
        return true;
    }

    protected class DropBeanContext
    extends AnchorlessBeanContext
    implements TypeContext {
        private static final long serialVersionUID = 1616988649969955037L;
        private Set supportedTypes = new HashSet();
        private int row;
        private int column;

        public Iterator getSupportedTypes() {
            return this.supportedTypes.iterator();
        }

        public boolean supports(Class type) {
            if (this.supportedTypes.contains(type)) {
                return true;
            }
            for (Class clazz : this.supportedTypes) {
                if (!clazz.isAssignableFrom(type)) continue;
                return true;
            }
            return false;
        }

        public boolean supports(Object bean) {
            return this.supports(bean.getClass());
        }

        public boolean add(Object targetChild) {
            if (targetChild == null) {
                return false;
            }
            if (!this.supports(targetChild)) {
                return false;
            }
            return PropertyTableCustomizer.this.drop(this.row, this.column, targetChild);
        }

        protected void setSupportedTypes(Set supportedTypes) {
            this.supportedTypes = supportedTypes;
        }

        protected void setSupportedType(Class type) {
            this.supportedTypes.clear();
            this.supportedTypes.add(type);
        }

        public int getColumn() {
            return this.column;
        }

        protected void setColumn(int column) {
            this.column = column;
        }

        public int getRow() {
            return this.row;
        }

        protected void setRow(int row) {
            this.row = row;
        }
    }

    protected class DropTargetHandler
    implements DropTargetListener {
        private Collection dropBeans = new ArrayList();

        protected DropTargetHandler() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            BeanDropSupport bds = PropertyTableCustomizer.this.getBeanDropSupport();
            if (bds == null) {
                return;
            }
            Point pos = dtde.getLocation();
            BeanContext target = PropertyTableCustomizer.this.getTargetBeanContext(pos.x, pos.y);
            this.dropBeans.clear();
            if (target != null) {
                bds.enumerateDropBeans(target, dtde, this.dropBeans);
            }
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
            this.dropBeans.clear();
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            BeanDropSupport bds = PropertyTableCustomizer.this.getBeanDropSupport();
            if (bds == null) {
                return;
            }
            Point pos = dtde.getLocation();
            BeanContext target = PropertyTableCustomizer.this.getTargetBeanContext(pos.x, pos.y);
            if (target == null) {
                dtde.rejectDrag();
                return;
            }
            ArrayList temp = new ArrayList();
            boolean searchSuccess = bds.enumerateDropBeans(target, dtde, temp);
            if (target != null && searchSuccess) {
                this.dropBeans.clear();
                this.dropBeans.addAll(temp);
                boolean accepted = false;
                for (Object o : this.dropBeans) {
                    if (o == null || !bds.acceptDropBean(target, o)) continue;
                    accepted = true;
                    break;
                }
                if (accepted) {
                    dtde.acceptDrag(dtde.getDropAction());
                    return;
                }
                dtde.rejectDrag();
                return;
            }
            dtde.acceptDrag(dtde.getDropAction());
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            BeanDropSupport bds = PropertyTableCustomizer.this.getBeanDropSupport();
            if (bds == null) {
                return;
            }
            Transferable trans = dtde.getTransferable();
            int dropAction = dtde.getDropAction();
            Point pos = dtde.getLocation();
            BeanContext target = PropertyTableCustomizer.this.getTargetBeanContext(pos.x, pos.y);
            Sys.println((String)(" - Drop target context: " + target));
            ArrayList temp = new ArrayList();
            boolean enumSuccess = bds.enumerateDropBeans(target, trans, temp);
            if (enumSuccess) {
                this.dropBeans.clear();
                this.dropBeans.addAll(temp);
            }
            Sys.println((String)(" - Drop beans: " + this.dropBeans.size()));
            if (!this.dropBeans.isEmpty()) {
                dtde.acceptDrop(dropAction);
                if (target != null) {
                    try {
                        Sys.println((String)" - Drop beans..");
                        bds.dropBeans(this.dropBeans, target, dropAction);
                        Sys.println((String)" - Drop completed.");
                        dtde.dropComplete(true);
                        this.dropBeans.clear();
                        return;
                    }
                    catch (Exception e) {
                        PropertyTableCustomizer.this.handleException(e);
                    }
                } else {
                    Sys.println((String)"DEBUG: drop target is null!");
                }
            }
            Sys.println((String)" - Drop failed!");
            try {
                dtde.rejectDrop();
            }
            catch (InvalidDnDOperationException e) {
                // empty catch block
            }
            dtde.dropComplete(false);
            this.dropBeans.clear();
        }
    }

    protected class DragGestureHandler
    implements DragGestureListener {
        protected DragGestureHandler() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            ArrayList<Object> beans = new ArrayList<Object>();
            int[] rows = PropertyTableCustomizer.this.getTable().getSelectedRows();
            int[] cols = PropertyTableCustomizer.this.getTable().getSelectedColumns();
            TableModel model = PropertyTableCustomizer.this.getTable().getModel();
            if (model == null) {
                return;
            }
            int columns = model.getColumnCount();
            for (int i = 0; i < rows.length; ++i) {
                int row = rows[i];
                if (cols.length < 1) {
                    for (int c = 0; c < columns; ++c) {
                        Object obj = model.getValueAt(row, c);
                        beans.add(obj);
                    }
                    continue;
                }
                for (int k = 0; k < cols.length; ++k) {
                    int col = cols[k];
                    Object obj = model.getValueAt(row, col);
                    beans.add(obj);
                }
            }
            if (beans.isEmpty()) {
                return;
            }
            PropertyTableCustomizer.this.dragSourceHandler.setBeanDropSupport(PropertyTableCustomizer.this.getBeanDropSupport());
            PropertyTableCustomizer.this.dragSourceHandler.startDrag(dge, beans);
        }
    }
}

