/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.customizers;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.beans.BeanEditor;
import com.spacekiller.util.beans.FeatureDescriptorFilter;
import com.spacekiller.util.beans.customizers.AbstractCustomizer;
import com.spacekiller.util.beans.customizers.BeanSelectionContext;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.beans.Customizer;
import java.beans.beancontext.BeanContext;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionListener;

public class TabbedCustomizer
extends AbstractCustomizer
implements BeanEditor {
    private static final long serialVersionUID = 6293344651108071492L;
    private JTabbedPane jTabbedPane1 = null;
    private Object object;
    private BeansToolkit beansToolkit;
    private BeanContext beanContextOfBean;
    private JPanel jPanel = null;
    private static final Logger logger = Logger.getLogger(TabbedCustomizer.class.getName());

    public TabbedCustomizer() {
        this.initialize();
        this.tabbedCustomizer_Initialize();
    }

    private void initialize() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.setRows(1);
        this.setLayout(gridLayout);
        this.setSize(new Dimension(376, 234));
        this.add((Component)this.getJPanel(), null);
    }

    private void action_Tab_Selected() {
        this.refreshCustomizers();
    }

    public void addCustomizer(Class customizerClass, String title, Icon icon, String tip) {
        this.insertCustomizerAt(customizerClass, this.getCustomizerCount(), title, icon, tip);
    }

    public Object getBean() {
        return this.getObject();
    }

    public BeanContext getBeanContextOfBean() {
        return this.beanContextOfBean;
    }

    @Override
    public BeanSelectionContext getBeanSelectionContext() {
        return null;
    }

    @Override
    public BeansToolkit getBeansToolkit() {
        if (this.beansToolkit == null) {
            return super.getBeansToolkit();
        }
        return this.beansToolkit;
    }

    public Class getCustomizerAt(int i) {
        return this.getTabbedPageAt(i).getCustomizerClass();
    }

    public int getCustomizerCount() {
        return this.getJTabbedPane1().getTabCount();
    }

    public FeatureDescriptorFilter getFeatureDescriptorFilter() {
        return null;
    }

    protected Icon getIcon(String resource) {
        try {
            return new ImageIcon(this.getClass().getResource(resource));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    private JTabbedPane getJTabbedPane1() {
        if (this.jTabbedPane1 == null) {
            this.jTabbedPane1 = new JTabbedPane();
            this.jTabbedPane1.setName("JTabbedPane1");
        }
        return this.jTabbedPane1;
    }

    @Override
    public ListSelectionListener getListSelectionListener() {
        return null;
    }

    protected Object getObject() {
        return this.object;
    }

    protected TabbedPage getTabbedPageAt(int i) {
        return (TabbedPage)this.getJTabbedPane1().getComponent(i);
    }

    void handleException(Throwable exception) {
        this.handleCustomizerException(exception);
    }

    public void insertCustomizerAt(Class customizerClass, int tabIndex, String title, Icon icon, String tip) {
        TabbedPage page = new TabbedPage();
        page.setCustomizerClass(customizerClass);
        this.getJTabbedPane1().insertTab(title, icon, page, tip, tabIndex);
    }

    protected void refreshCustomizers() {
        BeansToolkit btk = this.getBeansToolkit();
        TabbedPage selectedPage = (TabbedPage)this.getJTabbedPane1().getSelectedComponent();
        logger.fine("" + this.getClass().getName() + " >> btk=" + btk);
        if (btk == null) {
            return;
        }
        int count = this.getJTabbedPane1().getTabCount();
        for (int c = 0; c < count; ++c) {
            TabbedPage page = (TabbedPage)this.getJTabbedPane1().getComponent(c);
            try {
                Customizer custom;
                if (page == selectedPage) {
                    custom = page.getCustomizer();
                    if (custom == null) {
                        Class customClass = page.getCustomizerClass();
                        if (customClass != null) {
                            custom = btk.getCustomizer(customClass);
                        }
                        page.setCustomizer(custom);
                    }
                    if (custom != null) {
                        if (custom instanceof AbstractCustomizer) {
                            AbstractCustomizer abstr = (AbstractCustomizer)custom;
                            abstr.setBeansToolkit(this.getBeansToolkit());
                        }
                        if (custom instanceof BeanEditor) {
                            logger.fine("" + this + " >>>> " + custom + ".setBean: " + this.getBean());
                            BeanEditor be = (BeanEditor)custom;
                            be.setBeanContextOfBean(this.getBeanContextOfBean());
                            be.setBean(this.getBean());
                        } else {
                            logger.fine("" + this + " >>>> " + custom + ".setObject: " + this.getObject());
                            custom.setObject(this.getObject());
                        }
                    }
                    page.validate();
                    page.repaint();
                    continue;
                }
                custom = page.getCustomizer();
                page.setCustomizer(null);
                if (custom == null) continue;
            }
            catch (Exception e) {
                this.handleCustomizerException(e);
            }
        }
    }

    public void removeCustomizerAt(int tabIndex) {
        this.getJTabbedPane1().removeTabAt(tabIndex);
    }

    public void setBean(Object newBean) {
        this.setObject(newBean);
    }

    public void setBeanContextOfBean(BeanContext newBeanContextOfBean) {
        this.beanContextOfBean = newBeanContextOfBean;
    }

    @Override
    public void setBeanSelectionContext(BeanSelectionContext ctx) {
    }

    @Override
    public void setBeansToolkit(BeansToolkit newBeansToolkit) {
        this.beansToolkit = newBeansToolkit;
    }

    public void setCustomizerAt(Class customizerClass, int tabIndex, String title, Icon icon, String tip) {
        TabbedPage page = this.getTabbedPageAt(tabIndex);
        page.setCustomizerClass(customizerClass);
        page.setCustomizer(null);
        page.setToolTipText(tip);
        this.getJTabbedPane1().setIconAt(tabIndex, icon);
        this.getJTabbedPane1().setTitleAt(tabIndex, title);
    }

    public void setFeatureDescriptorFilter(FeatureDescriptorFilter filter) {
    }

    @Override
    public void setListSelectionListener(ListSelectionListener selectionListener) {
    }

    @Override
    public void setObject(Object newObject) {
        this.object = newObject;
        this.refreshCustomizers();
    }

    protected void tabbedCustomizer_Initialize() {
        this.setOpaque(false);
        this.getJTabbedPane1().setOpaque(false);
        this.getJTabbedPane1().getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TabbedCustomizer.this.action_Tab_Selected();
            }
        });
    }

    @Override
    public String toString() {
        return String.valueOf(this.object);
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridLayout gridLayout1 = new GridLayout();
            gridLayout1.setRows(1);
            this.jPanel = new JPanel();
            this.jPanel.setOpaque(true);
            this.jPanel.setLayout(gridLayout1);
            this.jPanel.add((Component)this.getJTabbedPane1(), null);
        }
        return this.jPanel;
    }

    public class TabbedPage
    extends JPanel {
        private static final long serialVersionUID = -2727536094938488473L;
        private Class customizerClass;
        private Customizer customizer;

        public TabbedPage() {
            this.setLayout(new GridLayout());
            this.setOpaque(false);
        }

        public Class getCustomizerClass() {
            return this.customizerClass;
        }

        public void setCustomizerClass(Class c) {
            this.customizerClass = c;
        }

        public Customizer getCustomizer() {
            return this.customizer;
        }

        public void setCustomizer(Customizer c) {
            this.removeAll();
            if (c != null && c instanceof Component) {
                if (c instanceof JComponent) {
                    ((JComponent)((Object)c)).setOpaque(false);
                }
                this.add((Component)((Object)c));
            }
        }
    }
}

