/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.editors;

import java.awt.Point;
import java.beans.PropertyEditorSupport;
import java.util.StringTokenizer;

public class PointPropertyEditor
extends PropertyEditorSupport {
    protected String convertPoint2Text(Point p) {
        if (p == null) {
            return null;
        }
        return "" + p.x + "," + p.y;
    }

    protected Point convertText2Point(String s) {
        if (s == null) {
            return null;
        }
        if (s.equalsIgnoreCase("null")) {
            return null;
        }
        Point p = new Point();
        int c = 0;
        StringTokenizer tok = new StringTokenizer(s, ",", false);
        while (tok.hasMoreElements()) {
            String sub = String.valueOf(tok.nextElement());
            int intValue = Integer.parseInt(sub.trim());
            switch (c) {
                case 0: {
                    p.x = intValue;
                    break;
                }
                case 1: {
                    p.y = intValue;
                }
            }
            ++c;
        }
        return p;
    }

    @Override
    public String getAsText() {
        Object value = this.getValue();
        if (value instanceof Point) {
            return this.convertPoint2Text((Point)value);
        }
        if (value instanceof String) {
            return (String)value;
        }
        return "" + value;
    }

    @Override
    public String getJavaInitializationString() {
        Object value = this.getValue();
        if (!(value instanceof Point)) {
            value = null;
        }
        if (value == null) {
            return "null";
        }
        Point p = (Point)value;
        return "new java.awt.Point(" + this.convertPoint2Text(p) + ")";
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (text == null) {
            this.setValue(null);
            return;
        }
        this.setValue(this.convertText2Point(text));
    }
}

