/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.model;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.beans.model.AbstractBeanModel;
import com.spacekiller.util.beans.model.BeanTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.beancontext.BeanContext;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public abstract class AbstractBeanTableModel
extends AbstractBeanModel
implements BeanTableModel {
    private Vector propertyDescriptors = new Vector();
    private EventListenerList listenerList = new EventListenerList();

    public AbstractBeanTableModel(BeansToolkit tk) {
        super(tk);
    }

    @Override
    public void addPropertyDescriptor(PropertyDescriptor pd) {
        this.insertPropertyDescriptorAt(pd, this.getPropertyDescriptorCount());
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listenerList.add(TableModelListener.class, l);
    }

    protected Dimension computePreferredCellSize(TableCellRenderer renderer, int row, int column) {
        try {
            Object v = this.getValueAt(row, column);
            Component comp = renderer.getTableCellRendererComponent(null, v, false, false, row, column);
            if (comp != null) {
                return comp.getPreferredSize();
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        return null;
    }

    protected PropertyEditor createPropertyEditor(int propertyDescrIndex) throws Exception {
        PropertyDescriptor property = this.getPropertyDescriptorAt(propertyDescrIndex);
        if (property == null) {
            return null;
        }
        return this.getToolkit().createPropertyEditor(property);
    }

    public TableColumnModel createTableColumnModel(BeanContext propertyEditorBeanContext) throws Exception {
        Vector<PropertyDescriptor> descr = new Vector<PropertyDescriptor>();
        Vector<PropertyEditor> editor = new Vector<PropertyEditor>();
        Vector<BeanContext> beanContexts = new Vector<BeanContext>();
        int count = this.getPropertyDescriptorCount();
        for (int c = 0; c < count; ++c) {
            PropertyDescriptor pd = this.getPropertyDescriptorAt(c);
            descr.add(pd);
            editor.add(this.createPropertyEditor(c));
            beanContexts.add(propertyEditorBeanContext);
        }
        return this.createTableColumnModel(descr, editor, beanContexts);
    }

    protected abstract TableColumnModel createTableColumnModel(Vector var1, Vector var2, Vector var3) throws Exception;

    protected abstract void firePropertyDescriptorsDeleted(int var1, int var2);

    protected abstract void firePropertyDescriptorsInserted(int var1, int var2);

    protected abstract void firePropertyDescriptorsUpdated(int var1, int var2);

    protected final void fireTableCellUpdated(int row, int column) {
        this.fireTableChanged(new TableModelEvent(this, row, row, column));
    }

    protected final void fireTableChanged(TableModelEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 1; i >= 0; --i) {
            if (!(listeners[i] instanceof TableModelListener)) continue;
            ((TableModelListener)listeners[i]).tableChanged(e);
        }
    }

    protected final void fireTableRowsDeleted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, -1));
    }

    protected final void fireTableRowsInserted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 1));
    }

    protected final void fireTableRowsUpdated(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 0));
    }

    protected final void fireTableStructureChanged() {
        this.fireTableChanged(new TableModelEvent(this, -1));
    }

    @Override
    public PropertyDescriptor getPropertyDescriptorAt(int i) {
        return (PropertyDescriptor)this.propertyDescriptors.get(i);
    }

    @Override
    public int getPropertyDescriptorCount() {
        return this.propertyDescriptors.size();
    }

    @Override
    public int getPropertyDescriptorIndex(String propertyName) {
        int count = this.getPropertyDescriptorCount();
        for (int c = 0; c < count; ++c) {
            if (!this.getPropertyDescriptorAt(c).getName().equals(propertyName)) continue;
            return c;
        }
        return -1;
    }

    @Override
    public void insertPropertyDescriptorAt(PropertyDescriptor pd, int index) {
        if (pd == null) {
            return;
        }
        this.propertyDescriptors.insertElementAt(pd, index);
        this.firePropertyDescriptorsInserted(index, index);
    }

    @Override
    public void removePropertyDescriptor(PropertyDescriptor pd) {
        int i = this.propertyDescriptors.indexOf(pd);
        if (i >= 0) {
            this.removePropertyDescriptorAt(i);
        }
    }

    @Override
    public void removePropertyDescriptorAt(int index) {
        this.propertyDescriptors.removeElementAt(index);
        this.firePropertyDescriptorsDeleted(index, index);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listenerList.remove(TableModelListener.class, l);
    }

    @Override
    public void setPropertyDescriptorAt(PropertyDescriptor pd, int index) {
        if (pd == null) {
            return;
        }
        this.propertyDescriptors.setElementAt(pd, index);
        this.firePropertyDescriptorsUpdated(index, index);
    }

    public abstract PropertyDescriptor getPropertyDescriptorAt(int var1, int var2);
}

