/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.model;

import com.spacekiller.util.beans.model.BeanTreeModel;
import com.spacekiller.util.beans.model.BeanTreeNode;
import java.beans.FeatureDescriptor;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.TreeNode;

public abstract class AbstractBeanTreeBranchNode
implements BeanTreeNode {
    private Vector children = new Vector();
    private Object bean;
    private FeatureDescriptor featureDescriptor;
    private static final Logger logger = Logger.getLogger(AbstractBeanTreeBranchNode.class.getName());

    public AbstractBeanTreeBranchNode() {
    }

    public AbstractBeanTreeBranchNode(Object bean, FeatureDescriptor feature) {
        this.setBean(bean);
        this.setFeatureDescriptor(feature);
    }

    public void addChildNode(BeanTreeNode child) {
        this.insertChildNodeAt(child, this.getChildCount());
    }

    protected void addChildNodeInternal(BeanTreeNode child) {
        this.insertChildNodeAtInternal(child, this.getChildCountInternal());
    }

    public Enumeration children() {
        if (!this.isLoaded()) {
            this.loadChildren(true);
        }
        return this.children.elements();
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public Object getBean() {
        return this.bean;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        if (!this.isLoaded()) {
            this.loadChildren(true);
        }
        return (TreeNode)this.children.get(childIndex);
    }

    @Override
    public int getChildCount() {
        if (!this.isLoaded()) {
            this.loadChildren(true);
        }
        return this.getChildCountInternal();
    }

    protected int getChildCountInternal() {
        return this.children.size();
    }

    @Override
    public int getChildIndexOfBean(Object bean) {
        int count = this.getChildCount();
        for (int c = 0; c < count; ++c) {
            if (this.getChildNode(c).getBean() != bean) continue;
            return c;
        }
        return -1;
    }

    @Override
    public BeanTreeNode getChildNode(int childIndex) {
        if (!this.isLoaded()) {
            this.loadChildren(true);
        }
        return this.getChildNodeInternal(childIndex);
    }

    protected BeanTreeNode getChildNodeInternal(int childIndex) {
        return (BeanTreeNode)this.children.get(childIndex);
    }

    @Override
    public FeatureDescriptor getFeatureDescriptor() {
        return this.featureDescriptor;
    }

    @Override
    public int getIndex(TreeNode node) {
        if (!this.isLoaded()) {
            this.loadChildren(true);
        }
        return this.children.indexOf(node);
    }

    protected void handleException(Throwable e) {
        logger.log(Level.WARNING, this.getClass().getName(), e);
    }

    public void insertChildNodeAt(BeanTreeNode child, int index) {
        if (child == null) {
            return;
        }
        if (!this.isLoaded()) {
            this.loadChildren(true);
        }
        this.insertChildNodeAtInternal(child, index);
    }

    protected void insertChildNodeAtInternal(BeanTreeNode child, int index) {
        if (child == null) {
            return;
        }
        child.setParent(this);
        this.children.insertElementAt(child, index);
        BeanTreeModel model = this.getBeanTreeModel();
        if (model != null) {
            model.beanStructureInserted(this, child);
        }
    }

    @Override
    public abstract boolean isLeaf();

    protected abstract void loadChildren(boolean var1);

    public void removeAllChildNodes() {
        if (!this.isLoaded()) {
            this.loadChildren(true);
        }
        this.removeAllChildNodesInternal();
    }

    protected void removeAllChildNodesInternal() {
        int count = this.getChildCountInternal();
        for (int c = 0; c < count; ++c) {
            this.removeChildNodeAtInternal(0);
        }
    }

    public void removeChildNode(BeanTreeNode child) {
        int i = this.getIndex(child);
        if (i < 0) {
            return;
        }
        this.removeChildNodeAt(i);
    }

    public void removeChildNodeAt(int index) {
        if (!this.isLoaded()) {
            this.loadChildren(true);
        }
        this.removeChildNodeAtInternal(index);
    }

    protected void removeChildNodeAtInternal(int index) {
        BeanTreeModel model;
        BeanTreeNode child = this.getChildNode(index);
        this.children.removeElementAt(index);
        if (child != null) {
            child.setParent(null);
        }
        if ((model = this.getBeanTreeModel()) != null) {
            model.beanStructureDeleted(this, child);
        }
    }

    public void setBean(Object newBean) {
        this.bean = newBean;
    }

    public void setChildNodeAt(BeanTreeNode child, int index) {
        BeanTreeNode oldNode;
        if (child == null) {
            return;
        }
        if (!this.isLoaded()) {
            this.loadChildren(true);
        }
        if ((oldNode = (BeanTreeNode)this.children.elementAt(index)) != null) {
            oldNode.setParent(null);
        }
        child.setParent(this);
        this.children.setElementAt(child, index);
        BeanTreeModel model = this.getBeanTreeModel();
        if (model != null) {
            model.beanStructureUpdated(this, oldNode, child);
        }
    }

    public void setFeatureDescriptor(FeatureDescriptor newFeatureDescriptor) {
        this.featureDescriptor = newFeatureDescriptor;
    }

    public String toString() {
        String feature = "";
        FeatureDescriptor f = this.getFeatureDescriptor();
        if (f != null) {
            feature = "" + f.getDisplayName();
        }
        return String.valueOf(this.getBean()) + " -> Feature=" + feature;
    }
}

