/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.model;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.beans.components.DefaultFeatureHeaderRenderer;
import com.spacekiller.util.beans.components.DefaultPropertyEditorCellEditor;
import com.spacekiller.util.beans.components.DefaultPropertyEditorCellRenderer;
import com.spacekiller.util.beans.components.DefaultPropertyEditorCellToolkit;
import com.spacekiller.util.beans.model.AbstractBeanTableModel;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyDescriptor;
import java.util.Vector;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class DefaultBeanTableModel
extends AbstractBeanTableModel {
    public DefaultBeanTableModel(BeansToolkit btk) {
        super(btk);
    }

    protected int computePreferredColumnWidth(TableCellRenderer renderer, int column, int spacing, int rowsToCheck) {
        int rc = spacing * 2;
        int rows = this.getRowCount();
        if (rows > 0) {
            int row = 0;
            int plus = rows / rowsToCheck;
            if (plus < 1) {
                plus = 1;
            }
            for (int c = 0; c < rowsToCheck && row < rows; row += plus, ++c) {
                int w;
                Dimension pref = this.computePreferredCellSize(renderer, row, column);
                if (pref == null || (w = pref.width + spacing) <= rc) continue;
                rc = w;
            }
        }
        return rc;
    }

    @Override
    protected TableColumnModel createTableColumnModel(Vector propertyDescriptors, Vector propertyEditors, Vector propertyEditorBeanContexts) throws Exception {
        DefaultPropertyEditorCellToolkit cellToolkit = new DefaultPropertyEditorCellToolkit(this.getToolkit(), this, 0, propertyDescriptors, propertyEditors, propertyEditorBeanContexts);
        DefaultPropertyEditorCellRenderer renderer = new DefaultPropertyEditorCellRenderer(cellToolkit);
        DefaultPropertyEditorCellEditor editor = new DefaultPropertyEditorCellEditor(cellToolkit);
        DefaultFeatureHeaderRenderer headerRenderer = new DefaultFeatureHeaderRenderer(this.getToolkit());
        DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
        int spacing = 10;
        int rowsToCheck = 10;
        int colCount = this.getColumnCount();
        for (int c = 0; c < colCount; ++c) {
            TableColumn column = new TableColumn(c);
            column.setCellRenderer(renderer);
            column.setCellEditor(editor);
            column.setHeaderValue(this.getPropertyDescriptorAt(c));
            column.setHeaderRenderer(headerRenderer);
            column.setResizable(true);
            int width = this.computePreferredColumnWidth(renderer, c, spacing, rowsToCheck);
            column.setPreferredWidth(width);
            column.setWidth(width);
            columnModel.addColumn(column);
        }
        return columnModel;
    }

    @Override
    protected void fireBeansDeleted(int firstIndex, int lastIndex) {
        this.fireTableRowsDeleted(firstIndex, lastIndex);
    }

    @Override
    protected void fireBeansInserted(int firstIndex, int lastIndex) {
        this.fireTableRowsInserted(firstIndex, lastIndex);
    }

    @Override
    protected void fireBeansUpdated(int firstIndex, int lastIndex) {
        this.fireTableRowsUpdated(firstIndex, lastIndex);
    }

    @Override
    protected void firePropertyDescriptorsDeleted(int firstIndex, int lastIndex) {
        this.fireTableStructureChanged();
    }

    @Override
    protected void firePropertyDescriptorsInserted(int firstIndex, int lastIndex) {
        this.fireTableStructureChanged();
    }

    @Override
    protected void firePropertyDescriptorsUpdated(int firstIndex, int lastIndex) {
        this.fireTableStructureChanged();
    }

    public Class getColumnClass(int columnIndex) {
        PropertyDescriptor pd = this.getPropertyDescriptorAt(columnIndex);
        return pd == null ? String.class : pd.getPropertyType();
    }

    @Override
    public int getColumnCount() {
        return this.getPropertyDescriptorCount();
    }

    public String getColumnDisplayName(int columnIndex) {
        PropertyDescriptor pd = this.getPropertyDescriptorAt(columnIndex);
        return pd == null ? "" + (columnIndex + 1) : pd.getDisplayName();
    }

    @Override
    public String getColumnName(int columnIndex) {
        PropertyDescriptor pd = this.getPropertyDescriptorAt(columnIndex);
        return pd == null ? "" + (columnIndex + 1) : pd.getName();
    }

    @Override
    public int getRowCount() {
        return this.getBeanCount();
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (col < 0) {
            if (row < 0) {
                return null;
            }
            return this.getBeanAt(row);
        }
        PropertyDescriptor descr = this.getPropertyDescriptorAt(col);
        if (descr == null) {
            return null;
        }
        return this.getValue(row, descr);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        PropertyDescriptor descr = this.getPropertyDescriptorAt(column);
        return descr == null ? false : descr.getWriteMethod() != null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        Object bean = ev.getSource();
        if (bean == null) {
            return;
        }
        int col = this.getPropertyDescriptorIndex(ev.getPropertyName());
        if (col < 0) {
            return;
        }
        int from = 0;
        int row;
        while ((row = this.getBeanIndex(bean, from)) >= 0) {
            this.fireTableCellUpdated(row, col);
            from = row + 1;
        }
        return;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        PropertyDescriptor descr = this.getPropertyDescriptorAt(col);
        if (descr == null) {
            return;
        }
        this.setValue(row, descr, value);
        this.fireTableCellUpdated(row, col);
    }

    @Override
    public PropertyDescriptor getPropertyDescriptorAt(int row, int col) {
        return this.getPropertyDescriptorAt(col);
    }
}

