/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.systray;

import com.spacekiller.util.swing.SystemTrayIcon;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.TrayIcon;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPopupMenu;

public class SystemTrayIconImpl
implements SystemTrayIcon {
    private TrayIcon trayIcon;
    private JPopupMenu popupMenu;

    public SystemTrayIconImpl(Image image) {
        this.trayIcon = new TrayIcon(image);
        this.trayIcon.addMouseListener(new MouseHandler());
    }

    public Image getImage() {
        return this.trayIcon.getImage();
    }

    public void setImage(Image image) {
        this.trayIcon.setImage(image);
    }

    public boolean isImageAutoSize() {
        return this.trayIcon.isImageAutoSize();
    }

    public void setImageAutoSize(boolean imageAutoSize) {
        this.trayIcon.setImageAutoSize(imageAutoSize);
    }

    public String getTooltip() {
        return this.trayIcon.getToolTip();
    }

    public void setTooltip(String tooltip) {
        this.trayIcon.setToolTip(tooltip);
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        this.popupMenu = popupMenu;
    }

    TrayIcon getTrayIcon() {
        return this.trayIcon;
    }

    protected void showPopupMenu(int x, int y) {
        JPopupMenu menu = this.getPopupMenu();
        if (menu == null) {
            return;
        }
        if (menu.getComponentCount() < 1) {
            return;
        }
        menu.validate();
        menu.doLayout();
        Dimension menuSize = menu.getPreferredSize();
        if (menuSize != null) {
            y -= menuSize.height;
        }
        menu.setLocation(x, y);
        menu.setInvoker(menu);
        menu.setVisible(true);
    }

    public void addActionListener(ActionListener actionListener) {
        this.trayIcon.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.trayIcon.removeActionListener(actionListener);
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.trayIcon.addMouseListener(mouseListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.trayIcon.removeMouseListener(mouseListener);
    }

    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.trayIcon.addMouseMotionListener(mouseMotionListener);
    }

    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.trayIcon.removeMouseMotionListener(mouseMotionListener);
    }

    protected class MouseHandler
    extends MouseAdapter {
        protected MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            if (e.isPopupTrigger()) {
                SystemTrayIconImpl.this.showPopupMenu(e.getX(), e.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            if (e.isPopupTrigger()) {
                SystemTrayIconImpl.this.showPopupMenu(e.getX(), e.getY());
            }
        }
    }
}

