/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.locale;

import com.spacekiller.util.Filter;
import com.spacekiller.util.Tools;
import com.spacekiller.util.locale.LocaleUtil;
import com.spacekiller.util.swing.AbstractCellRenderer;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.Customizer;
import java.util.Comparator;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class LocaleChooser
extends JPanel
implements Customizer {
    private static final long serialVersionUID = 8264200353438239978L;
    private Filter localeFilter;
    private JScrollPane jScrollPane = null;
    private JList jList = null;
    private transient List changeListeners;
    private transient ActionListener actionListeners;

    public LocaleChooser() {
        this.initialize();
        this.initLocaleChooser();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        gridBagConstraints1.gridx = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(310, 272));
        this.add((Component)this.getJList(), gridBagConstraints1);
        this.add((Component)this.getJScrollPane(), gridBagConstraints);
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setOpaque(false);
            this.jScrollPane.setViewportView(this.getJList());
        }
        return this.jScrollPane;
    }

    private JList getJList() {
        if (this.jList == null) {
            this.jList = new JList();
            this.jList.setOpaque(false);
            this.jList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    LocaleChooser.this.handleSelectionChanged();
                }
            });
            this.jList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int clicks = e.getClickCount();
                    if (clicks == 2) {
                        LocaleChooser.this.handleDoubleClick();
                    }
                }
            });
        }
        return this.jList;
    }

    public Locale showDialog(Component owner, String title) {
        Window win;
        JDialog dialog = null;
        if (owner != null && (win = SwingUtilities.getWindowAncestor(owner)) != null) {
            if (win instanceof Frame) {
                dialog = new JDialog((Frame)win);
            } else if (win instanceof Dialog) {
                dialog = new JDialog((Dialog)win);
            }
        }
        if (dialog == null) {
            dialog = new JDialog();
        }
        this.getJList().setSelectionMode(0);
        final JDialog dialogFinal = dialog;
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialogFinal.dispose();
            }
        });
        dialog.setTitle(title);
        dialog.setContentPane(this);
        dialog.pack();
        Tools.centerWindow((Component)owner, (Window)dialog);
        dialog.setModal(true);
        dialog.setVisible(true);
        return this.getSelectedLocale();
    }

    protected void initLocaleChooser() {
        this.getJList().setCellRenderer(new LocaleListCellRenderer());
        this.setPreferredSize(new Dimension(250, 350));
        this.refresh();
    }

    protected void fireStateChanged(ChangeEvent e) {
        if (this.changeListeners == null) {
            return;
        }
        int currentSize = this.changeListeners.size();
        for (int index = 0; index < currentSize; ++index) {
            ChangeListener ls = (ChangeListener)this.changeListeners.get(index);
            if (ls == null) continue;
            ls.stateChanged(e);
        }
    }

    public void addChangeListener(ChangeListener listener) {
        if (this.changeListeners == null) {
            this.changeListeners = new LinkedList();
        }
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        if (this.changeListeners != null) {
            this.changeListeners.remove(listener);
        }
    }

    public ChangeListener[] getChangeListeners() {
        if (this.changeListeners == null) {
            return new ChangeListener[0];
        }
        return this.changeListeners.toArray(new ChangeListener[this.changeListeners.size()]);
    }

    public Filter getLocaleFilter() {
        return this.localeFilter;
    }

    public void setLocaleFilter(Filter localeFilter) {
        this.localeFilter = localeFilter;
        this.refresh();
    }

    protected void refresh() {
        Locale oldSelected = this.getSelectedLocale();
        TreeSet<Locale> set = new TreeSet<Locale>(new LocaleComparator());
        Locale[] locales = Locale.getAvailableLocales();
        if (locales != null) {
            Filter filter = this.localeFilter;
            for (int i = 0; i < locales.length; ++i) {
                Locale locale = locales[i];
                if (locale == null || filter != null && !filter.accept((Object)locale)) continue;
                set.add(locale);
            }
        }
        DefaultListModel model = new DefaultListModel();
        Iterator i = set.iterator();
        while (i.hasNext()) {
            model.addElement(i.next());
        }
        this.getJList().setModel(model);
        this.selectLocale(oldSelected);
    }

    public Locale getSelectedLocale() {
        return (Locale)this.getJList().getSelectedValue();
    }

    public void setSelectedLocale(Locale locale) {
        this.selectLocale(locale);
    }

    @Override
    public void setObject(Object bean) {
        this.setSelectedLocale((Locale)bean);
    }

    private void selectLocale(Locale locale) {
        ListModel model = this.getJList().getModel();
        if (model == null) {
            return;
        }
        int index = -1;
        if (locale != null) {
            int size = model.getSize();
            for (int i = 0; i < size; ++i) {
                Locale loc = (Locale)model.getElementAt(i);
                if (!locale.equals(loc)) continue;
                index = i;
                break;
            }
        }
        if (index >= 0) {
            this.getJList().setSelectedIndex(index);
            Rectangle rect = this.getJList().getCellBounds(index, index);
            if (rect != null) {
                this.getJList().scrollRectToVisible(rect);
            }
        } else {
            this.getJList().clearSelection();
        }
    }

    private void handleSelectionChanged() {
        this.fireStateChanged(new ChangeEvent(this));
    }

    private void handleDoubleClick() {
        ActionEvent ev = new ActionEvent(this, 1001, "action");
        this.fireActionPerformed(ev);
    }

    protected void fireActionPerformed(ActionEvent e) {
        if (this.actionListeners == null) {
            return;
        }
        this.actionListeners.actionPerformed(e);
    }

    public void addActionListener(ActionListener listener) {
        this.actionListeners = AWTEventMulticaster.add(this.actionListeners, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListeners = AWTEventMulticaster.remove(this.actionListeners, listener);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])AWTEventMulticaster.getListeners((EventListener)this.actionListeners, ActionListener.class);
    }

    public static class LocaleListCellRenderer
    extends AbstractCellRenderer
    implements ListCellRenderer {
        private static final long serialVersionUID = 6279262730900780794L;
        private JLabel label = new JLabel();

        public LocaleListCellRenderer() {
            this.setOpaque(false);
            this.setLayout(new GridLayout(1, 1));
            this.add(this.label);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setSelected(isSelected);
            this.setFocus(cellHasFocus);
            String text = null;
            Icon icon = null;
            if (value != null && value instanceof Locale) {
                Locale locale = (Locale)value;
                text = locale.getDisplayName();
                icon = LocaleUtil.getInstance().getLocaleIcon(locale);
            }
            if (text == null) {
                text = "";
            }
            this.label.setText(text);
            this.label.setIcon(icon);
            return this;
        }
    }

    public static class LocaleComparator
    implements Comparator {
        public int compare(Object arg0, Object arg1) {
            Locale loc0 = (Locale)arg0;
            Locale loc1 = (Locale)arg1;
            String name0 = loc0.getDisplayName();
            String name1 = loc1.getDisplayName();
            if (name0 == null) {
                return -1;
            }
            if (name1 == null) {
                return 1;
            }
            int rc = name0.compareToIgnoreCase(name1);
            if (rc != 0) {
                return rc;
            }
            String iso0 = loc0.getISO3Language();
            String iso1 = loc1.getISO3Language();
            return iso0.compareToIgnoreCase(iso1);
        }
    }
}

