/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.locale;

import com.spacekiller.util.Tools;
import com.spacekiller.util.locale.LocaleChooser;
import com.spacekiller.util.locale.LocaleUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditorSupport;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JPanel;

public class LocalePropertyEditor
extends PropertyEditorSupport {
    private static JPanel dummy = new JPanel();
    private Color textColor = Color.BLACK;
    private Font textFont = dummy.getFont();

    @Override
    public String getAsText() {
        Object value = this.getValue();
        if (value == null) {
            return null;
        }
        if (value instanceof Locale) {
            return ((Locale)value).toString();
        }
        if (value instanceof String) {
            return (String)value;
        }
        return String.valueOf(value);
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        Locale locale = this.getLocale(text);
        this.setValue(locale);
    }

    private Locale getLocale(String text) {
        if (text == null) {
            return null;
        }
        if (text.equals("null")) {
            return null;
        }
        Locale[] locales = Locale.getAvailableLocales();
        for (int i = 0; i < locales.length; ++i) {
            if (!text.equals(locales[i].toString())) continue;
            return locales[i];
        }
        String language = text;
        String country = "";
        String variant = "";
        int x = language.indexOf("_");
        if (x >= 0) {
            country = language.substring(x + 1);
            language = language.substring(0, x);
        }
        if ((x = country.indexOf("_")) >= 0) {
            variant = country.substring(x + 1);
            country = country.substring(0, x);
        }
        return new Locale(language, country, variant);
    }

    @Override
    public String getJavaInitializationString() {
        Object value = this.getValue();
        if (value != null && value instanceof Locale) {
            Locale locale = (Locale)value;
            String language = Tools.quoteJava((String)locale.getLanguage());
            String country = Tools.quoteJava((String)locale.getCountry());
            String variant = Tools.quoteJava((String)locale.getVariant());
            return "new java.util.Locale(" + language + ", " + country + ", " + variant + ")";
        }
        return "null";
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics g, Rectangle box) {
        super.paintValue(g, box);
        Icon icon = null;
        String text = null;
        Object value = this.getValue();
        if (value != null && value instanceof Locale) {
            Locale locale = (Locale)value;
            text = locale.getDisplayName();
            icon = LocaleUtil.getInstance().getLocaleIcon(locale);
        }
        int h = box.height;
        int x = 0;
        int y = 0;
        if (icon != null) {
            int iw = icon.getIconWidth();
            int ih = icon.getIconHeight();
            icon.paintIcon(dummy, g, x, h / 2 - ih / 2);
            x += iw;
        }
        if (text != null) {
            Font font = this.getTextFont();
            g.setFont(font);
            FontMetrics fm = g.getFontMetrics();
            g.setColor(this.getTextColor());
            g.drawString(text, x + 4, y + fm.getAscent());
        }
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public void setTextFont(Font textFont) {
        this.textFont = textFont;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        final LocaleChooser chooser = new LocaleChooser();
        chooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Locale locale = chooser.getSelectedLocale();
                LocalePropertyEditor.this.setValue(locale);
            }
        });
        return chooser;
    }
}

