/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.locale;

import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class LocaleUtil {
    private static LocaleUtil instance;
    private Map iconCache = new HashMap();
    private Icon unknownIcon;
    private Properties localeFlagMapping = new Properties();
    private static final Logger logger;
    private static final String LOCALE_ICONS_PATH = "/com/spacekiller/util/locale/icons/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocaleUtil() {
        try {
            InputStream in = this.getClass().getResource("/com/spacekiller/util/locale/locale_flag_icons.properties").openStream();
            try {
                this.localeFlagMapping.load(in);
            }
            finally {
                in.close();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        try {
            this.unknownIcon = this.getFlagIcon("unknown.gif");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LocaleUtil getInstance() {
        if (instance != null) return instance;
        Class<LocaleUtil> clazz = LocaleUtil.class;
        synchronized (LocaleUtil.class) {
            if (instance != null) return instance;
            instance = new LocaleUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Icon getCountryIcon(String country) {
        return this.getCountryIcon(country, 1);
    }

    public Icon getCountryIcon(String country, int iconKind) {
        if (country == null) {
            return null;
        }
        Icon icon = this.getFlagIcon(country.toLowerCase() + ".png");
        if (icon != null) {
            return icon;
        }
        return this.unknownIcon;
    }

    public Icon getLocaleIcon(Locale locale) {
        return this.getLocaleIcon(locale, 1);
    }

    public Icon getLocaleIcon(Locale locale, int iconKind) {
        Icon icon;
        String langCountry;
        Icon icon2;
        if (locale == null) {
            return null;
        }
        String lang = locale.getLanguage();
        String country = locale.getCountry();
        String localeString = this.getLocaleString(locale);
        String iconFileName = this.localeFlagMapping.getProperty(localeString);
        if (iconFileName != null && (icon2 = this.getFlagIcon(iconFileName)) != null) {
            return icon2;
        }
        if (lang != null && country != null && (iconFileName = this.localeFlagMapping.getProperty(langCountry = lang + "_" + country)) != null && (icon = this.getFlagIcon(iconFileName)) != null) {
            return icon;
        }
        if (lang != null && (iconFileName = this.localeFlagMapping.getProperty(lang)) != null && (icon2 = this.getFlagIcon(iconFileName)) != null) {
            return icon2;
        }
        icon2 = this.getFlagIcon(localeString + ".png");
        if (icon2 != null) {
            return icon2;
        }
        icon2 = this.getFlagIcon(country.toLowerCase() + ".png");
        if (icon2 != null) {
            return icon2;
        }
        icon2 = this.getFlagIcon(lang.toLowerCase() + ".png");
        if (icon2 != null) {
            return icon2;
        }
        return this.unknownIcon;
    }

    public Icon getLocaleIcon(String locale) {
        return this.getLocaleIcon(locale, 1);
    }

    public Icon getLocaleIcon(String locale, int iconKind) {
        return this.getLocaleIcon(this.getLocale(locale));
    }

    public Locale getLocale(String localeString) {
        String language = null;
        String country = null;
        String variant = null;
        if (localeString == null) {
            return null;
        }
        int i = localeString.indexOf("_");
        if (i < 0) {
            language = localeString;
            if (language.length() < 1) {
                language = null;
            }
        } else {
            language = localeString.substring(0, i);
            if ((i = (localeString = localeString.substring(i + 1)).indexOf("_")) < 0) {
                country = localeString;
            } else {
                country = localeString.substring(0, i);
                variant = localeString.substring(i + 1);
            }
        }
        if (language != null) {
            if (country != null) {
                if (variant != null) {
                    return new Locale(language, country, variant);
                }
                return new Locale(language, country);
            }
            return new Locale(language);
        }
        return null;
    }

    public String getLocaleString(Locale locale) {
        String str = "";
        if (locale != null) {
            String lang = locale.getLanguage();
            String country = locale.getCountry();
            String variant = locale.getVariant();
            if (lang != null) {
                str = lang;
                if (country != null) {
                    str = str + "_" + country;
                    if (variant != null) {
                        str = str + "_" + variant;
                    }
                }
            }
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Icon getFlagIcon(String fileName) {
        Icon icon = (Icon)this.iconCache.get(fileName);
        if (icon != null) {
            return icon;
        }
        LocaleUtil localeUtil = this;
        synchronized (localeUtil) {
            try {
                URL url = this.getClass().getResource(LOCALE_ICONS_PATH + fileName);
                if (url == null) {
                    return null;
                }
                icon = new ImageIcon(url);
                this.iconCache.put(fileName, icon);
                return icon;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                return null;
            }
        }
    }

    static {
        logger = Logger.getLogger(LocaleUtil.class.getName());
    }
}

