/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.heap.plugin;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class HeapManagerPreferencesPanel
extends JPanel {
    private static final long serialVersionUID = -4736442937214566126L;
    private boolean useFairLocking;
    private boolean useJnaMemory;
    private boolean useUnsafeMemory;
    private JCheckBox chckbxFairLocking;
    private JCheckBox chckbxUnsafeMemory;
    private JCheckBox chckbxJnaMemory;

    public HeapManagerPreferencesPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JPanel panelMediaHeap = new JPanel();
        panelMediaHeap.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Heap Manager", 4, 2, null, new Color(51, 51, 51)));
        GridBagConstraints gbc_panelMediaHeap = new GridBagConstraints();
        gbc_panelMediaHeap.weightx = 1.0;
        gbc_panelMediaHeap.insets = new Insets(4, 4, 0, 5);
        gbc_panelMediaHeap.fill = 1;
        gbc_panelMediaHeap.gridx = 0;
        gbc_panelMediaHeap.gridy = 0;
        this.add((Component)panelMediaHeap, gbc_panelMediaHeap);
        GridBagLayout gbl_panelMediaHeap = new GridBagLayout();
        gbl_panelMediaHeap.columnWidths = new int[]{0, 0};
        gbl_panelMediaHeap.rowHeights = new int[]{0, 0};
        gbl_panelMediaHeap.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelMediaHeap.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelMediaHeap.setLayout(gbl_panelMediaHeap);
        JPanel panel_1 = new JPanel();
        GridBagConstraints gbc_panel_1 = new GridBagConstraints();
        gbc_panel_1.weightx = 1.0;
        gbc_panel_1.insets = new Insets(4, 4, 4, 4);
        gbc_panel_1.fill = 1;
        gbc_panel_1.gridx = 0;
        gbc_panel_1.gridy = 0;
        panelMediaHeap.add((Component)panel_1, gbc_panel_1);
        GridBagLayout gbl_panel_1 = new GridBagLayout();
        gbl_panel_1.columnWidths = new int[]{0, 0};
        gbl_panel_1.rowHeights = new int[]{0, 0, 0, 0, 0};
        gbl_panel_1.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panel_1.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        panel_1.setLayout(gbl_panel_1);
        JLabel lblHeapinfo = new JLabel("Note: Changes require a restart to take effect.");
        lblHeapinfo.setIcon(new ImageIcon(HeapManagerPreferencesPanel.class.getResource("/com/spacekiller/util/heap/plugin/icons/crate-refresh_icon16.png")));
        GridBagConstraints gbc_lblHeapinfo = new GridBagConstraints();
        gbc_lblHeapinfo.weightx = 1.0;
        gbc_lblHeapinfo.insets = new Insets(4, 4, 8, 4);
        gbc_lblHeapinfo.anchor = 18;
        gbc_lblHeapinfo.weighty = 1.0;
        gbc_lblHeapinfo.gridx = 0;
        gbc_lblHeapinfo.gridy = 0;
        panel_1.add((Component)lblHeapinfo, gbc_lblHeapinfo);
        this.chckbxFairLocking = new JCheckBox("Fair Locking Support");
        this.chckbxFairLocking.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                HeapManagerPreferencesPanel.this.useFairLocking = HeapManagerPreferencesPanel.this.chckbxFairLocking.isSelected();
            }
        });
        this.chckbxFairLocking.setToolTipText("Use fair locking strategy ?");
        GridBagConstraints gbc_chckbxFairLocking = new GridBagConstraints();
        gbc_chckbxFairLocking.anchor = 17;
        gbc_chckbxFairLocking.insets = new Insets(0, 0, 5, 0);
        gbc_chckbxFairLocking.gridx = 0;
        gbc_chckbxFairLocking.gridy = 1;
        panel_1.add((Component)this.chckbxFairLocking, gbc_chckbxFairLocking);
        this.chckbxUnsafeMemory = new JCheckBox("Unsafe Memory Support");
        this.chckbxUnsafeMemory.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                HeapManagerPreferencesPanel.this.useUnsafeMemory = HeapManagerPreferencesPanel.this.chckbxUnsafeMemory.isSelected();
            }
        });
        this.chckbxJnaMemory = new JCheckBox("JNA Memory Support");
        this.chckbxJnaMemory.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                HeapManagerPreferencesPanel.this.useJnaMemory = HeapManagerPreferencesPanel.this.chckbxJnaMemory.isSelected();
            }
        });
        GridBagConstraints gbc_chckbxJnaMemory = new GridBagConstraints();
        gbc_chckbxJnaMemory.anchor = 17;
        gbc_chckbxJnaMemory.insets = new Insets(0, 0, 5, 0);
        gbc_chckbxJnaMemory.gridx = 0;
        gbc_chckbxJnaMemory.gridy = 2;
        panel_1.add((Component)this.chckbxJnaMemory, gbc_chckbxJnaMemory);
        this.chckbxUnsafeMemory.setToolTipText("Use unsafe direct memory ? (faster)");
        GridBagConstraints gbc_chckbxUnsafeMemory = new GridBagConstraints();
        gbc_chckbxUnsafeMemory.anchor = 17;
        gbc_chckbxUnsafeMemory.gridx = 0;
        gbc_chckbxUnsafeMemory.gridy = 3;
        panel_1.add((Component)this.chckbxUnsafeMemory, gbc_chckbxUnsafeMemory);
        this.initHeapManagerPreferencesPanel();
    }

    protected void initHeapManagerPreferencesPanel() {
    }

    protected JCheckBox getChckbxFairLocking() {
        return this.chckbxFairLocking;
    }

    protected JCheckBox getChckbxJnaMemory() {
        return this.chckbxJnaMemory;
    }

    protected JCheckBox getChckbxUnsafeMemory() {
        return this.chckbxUnsafeMemory;
    }

    public boolean isUseFairLocking() {
        return this.useFairLocking;
    }

    public void setUseFairLocking(boolean useFairLocking) {
        this.useFairLocking = useFairLocking;
        this.chckbxFairLocking.setSelected(useFairLocking);
    }

    public boolean isUseUnsafeMemory() {
        return this.useUnsafeMemory;
    }

    public void setUseUnsafeMemory(boolean useUnsafeMemory) {
        this.useUnsafeMemory = useUnsafeMemory;
        this.chckbxUnsafeMemory.setSelected(useUnsafeMemory);
    }

    public boolean isUseJnaMemory() {
        return this.useJnaMemory;
    }

    public void setUseJnaMemory(boolean useJnaMemory) {
        this.useJnaMemory = useJnaMemory;
        this.chckbxJnaMemory.setSelected(useJnaMemory);
    }
}

