/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.heap.view;

import com.spacekiller.util.heap.AreaConfig;
import com.spacekiller.util.heap.DefaultAreaConfig;
import com.spacekiller.util.heap.DefaultHeapConfig;
import com.spacekiller.util.heap.HeapConfig;
import com.spacekiller.util.heap.view.DefaultAreaConfigPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DefaultHeapConfigPanel
extends JPanel {
    private static final long serialVersionUID = 4638703242724834140L;
    private static final long MB = 0x100000L;
    private HeapConfig heapConfig;
    private boolean refreshing;
    private JTextField textFieldName;
    private JTextField textFieldPageSize;
    private JCheckBox chckbxJavaHeapPreferred;
    private JCheckBox chckbxJavaHeap;
    private JCheckBox chckbxDirectHeap;
    private JCheckBox chckbxSwapFile;
    private DefaultAreaConfigPanel defaultAreaConfigPanelJavaHeap;
    private DefaultAreaConfigPanel defaultAreaConfigPanelDirectHeap;
    private DefaultAreaConfigPanel defaultAreaConfigPanelSwapFile;

    public DefaultHeapConfigPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JLabel lblHeapName = new JLabel("Heap Name:");
        GridBagConstraints gbc_lblHeapName = new GridBagConstraints();
        gbc_lblHeapName.anchor = 17;
        gbc_lblHeapName.insets = new Insets(0, 0, 5, 5);
        gbc_lblHeapName.gridx = 0;
        gbc_lblHeapName.gridy = 0;
        this.add((Component)lblHeapName, gbc_lblHeapName);
        this.textFieldName = new JTextField();
        GridBagConstraints gbc_textFieldName = new GridBagConstraints();
        gbc_textFieldName.weightx = 1.0;
        gbc_textFieldName.insets = new Insets(0, 0, 5, 0);
        gbc_textFieldName.fill = 2;
        gbc_textFieldName.gridx = 1;
        gbc_textFieldName.gridy = 0;
        this.add((Component)this.textFieldName, gbc_textFieldName);
        this.textFieldName.setColumns(15);
        JLabel lblPageSize = new JLabel("Page Size:");
        GridBagConstraints gbc_lblPageSize = new GridBagConstraints();
        gbc_lblPageSize.anchor = 17;
        gbc_lblPageSize.insets = new Insets(0, 0, 5, 5);
        gbc_lblPageSize.gridx = 0;
        gbc_lblPageSize.gridy = 1;
        this.add((Component)lblPageSize, gbc_lblPageSize);
        this.textFieldPageSize = new JTextField();
        GridBagConstraints gbc_textFieldPageSize = new GridBagConstraints();
        gbc_textFieldPageSize.insets = new Insets(0, 0, 5, 0);
        gbc_textFieldPageSize.fill = 2;
        gbc_textFieldPageSize.gridx = 1;
        gbc_textFieldPageSize.gridy = 1;
        this.add((Component)this.textFieldPageSize, gbc_textFieldPageSize);
        this.textFieldPageSize.setColumns(10);
        JLabel lblHeapArea = new JLabel("Heap Area(s)...");
        GridBagConstraints gbc_lblHeapArea = new GridBagConstraints();
        gbc_lblHeapArea.gridwidth = 2;
        gbc_lblHeapArea.anchor = 17;
        gbc_lblHeapArea.insets = new Insets(0, 0, 5, 5);
        gbc_lblHeapArea.gridx = 0;
        gbc_lblHeapArea.gridy = 2;
        this.add((Component)lblHeapArea, gbc_lblHeapArea);
        this.chckbxJavaHeapPreferred = new JCheckBox("Java Heap Preferred");
        this.chckbxJavaHeapPreferred.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!DefaultHeapConfigPanel.this.refreshing) {
                    DefaultHeapConfigPanel.this.apply();
                }
            }
        });
        GridBagConstraints gbc_chckbxJavaHeapPreferred = new GridBagConstraints();
        gbc_chckbxJavaHeapPreferred.gridwidth = 2;
        gbc_chckbxJavaHeapPreferred.anchor = 17;
        gbc_chckbxJavaHeapPreferred.insets = new Insets(0, 0, 5, 5);
        gbc_chckbxJavaHeapPreferred.gridx = 0;
        gbc_chckbxJavaHeapPreferred.gridy = 3;
        this.add((Component)this.chckbxJavaHeapPreferred, gbc_chckbxJavaHeapPreferred);
        this.chckbxJavaHeap = new JCheckBox("Java Heap:");
        this.chckbxJavaHeap.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!DefaultHeapConfigPanel.this.refreshing) {
                    DefaultHeapConfigPanel.this.apply();
                }
            }
        });
        GridBagConstraints gbc_chckbxJavaHeap = new GridBagConstraints();
        gbc_chckbxJavaHeap.gridwidth = 2;
        gbc_chckbxJavaHeap.anchor = 17;
        gbc_chckbxJavaHeap.insets = new Insets(0, 0, 5, 5);
        gbc_chckbxJavaHeap.gridx = 0;
        gbc_chckbxJavaHeap.gridy = 4;
        this.add((Component)this.chckbxJavaHeap, gbc_chckbxJavaHeap);
        this.chckbxDirectHeap = new JCheckBox("Direct Heap:");
        this.chckbxDirectHeap.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!DefaultHeapConfigPanel.this.refreshing) {
                    DefaultHeapConfigPanel.this.apply();
                }
            }
        });
        this.defaultAreaConfigPanelJavaHeap = new DefaultAreaConfigPanel();
        GridBagConstraints gbc_defaultAreaConfigPanelJavaHeap = new GridBagConstraints();
        gbc_defaultAreaConfigPanelJavaHeap.insets = new Insets(0, 30, 0, 0);
        gbc_defaultAreaConfigPanelJavaHeap.gridwidth = 2;
        gbc_defaultAreaConfigPanelJavaHeap.fill = 1;
        gbc_defaultAreaConfigPanelJavaHeap.gridx = 0;
        gbc_defaultAreaConfigPanelJavaHeap.gridy = 5;
        this.add((Component)this.defaultAreaConfigPanelJavaHeap, gbc_defaultAreaConfigPanelJavaHeap);
        GridBagConstraints gbc_chckbxDirectHeap = new GridBagConstraints();
        gbc_chckbxDirectHeap.gridwidth = 2;
        gbc_chckbxDirectHeap.anchor = 17;
        gbc_chckbxDirectHeap.insets = new Insets(0, 0, 5, 5);
        gbc_chckbxDirectHeap.gridx = 0;
        gbc_chckbxDirectHeap.gridy = 6;
        this.add((Component)this.chckbxDirectHeap, gbc_chckbxDirectHeap);
        this.chckbxSwapFile = new JCheckBox("Swap File:");
        this.chckbxSwapFile.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!DefaultHeapConfigPanel.this.refreshing) {
                    DefaultHeapConfigPanel.this.apply();
                }
            }
        });
        this.defaultAreaConfigPanelDirectHeap = new DefaultAreaConfigPanel();
        GridBagConstraints gbc_defaultAreaConfigPanelDirectHeap = new GridBagConstraints();
        gbc_defaultAreaConfigPanelDirectHeap.insets = new Insets(0, 30, 0, 0);
        gbc_defaultAreaConfigPanelDirectHeap.gridwidth = 2;
        gbc_defaultAreaConfigPanelDirectHeap.fill = 1;
        gbc_defaultAreaConfigPanelDirectHeap.gridx = 0;
        gbc_defaultAreaConfigPanelDirectHeap.gridy = 7;
        this.add((Component)this.defaultAreaConfigPanelDirectHeap, gbc_defaultAreaConfigPanelDirectHeap);
        GridBagConstraints gbc_chckbxSwapFile = new GridBagConstraints();
        gbc_chckbxSwapFile.gridwidth = 2;
        gbc_chckbxSwapFile.anchor = 17;
        gbc_chckbxSwapFile.insets = new Insets(0, 0, 5, 5);
        gbc_chckbxSwapFile.gridx = 0;
        gbc_chckbxSwapFile.gridy = 8;
        this.add((Component)this.chckbxSwapFile, gbc_chckbxSwapFile);
        this.defaultAreaConfigPanelSwapFile = new DefaultAreaConfigPanel();
        GridBagConstraints gbc_defaultAreaConfigPanelSwapFile = new GridBagConstraints();
        gbc_defaultAreaConfigPanelSwapFile.insets = new Insets(0, 30, 0, 0);
        gbc_defaultAreaConfigPanelSwapFile.gridwidth = 2;
        gbc_defaultAreaConfigPanelSwapFile.fill = 1;
        gbc_defaultAreaConfigPanelSwapFile.gridx = 0;
        gbc_defaultAreaConfigPanelSwapFile.gridy = 9;
        this.add((Component)this.defaultAreaConfigPanelSwapFile, gbc_defaultAreaConfigPanelSwapFile);
        this.initDefaultHeapConfigPanel();
    }

    protected void initDefaultHeapConfigPanel() {
        DocumentListener docHandler = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (!DefaultHeapConfigPanel.this.refreshing) {
                    DefaultHeapConfigPanel.this.apply();
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (!DefaultHeapConfigPanel.this.refreshing) {
                    DefaultHeapConfigPanel.this.apply();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (!DefaultHeapConfigPanel.this.refreshing) {
                    DefaultHeapConfigPanel.this.apply();
                }
            }
        };
        this.textFieldName.getDocument().addDocumentListener(docHandler);
        this.textFieldPageSize.getDocument().addDocumentListener(docHandler);
    }

    protected JTextField getTextFieldName() {
        return this.textFieldName;
    }

    protected JCheckBox getChckbxJavaHeapPreferred() {
        return this.chckbxJavaHeapPreferred;
    }

    protected JCheckBox getChckbxJavaHeap() {
        return this.chckbxJavaHeap;
    }

    protected JCheckBox getChckbxDirectHeap() {
        return this.chckbxDirectHeap;
    }

    protected JCheckBox getChckbxSwapFile() {
        return this.chckbxSwapFile;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.checkEnable();
    }

    protected void checkEnable() {
        boolean enabled = super.isEnabled();
        this.textFieldName.setEnabled(enabled);
        this.textFieldPageSize.setEnabled(enabled);
        this.chckbxJavaHeapPreferred.setEnabled(enabled);
        this.chckbxJavaHeap.setEnabled(enabled);
        this.chckbxDirectHeap.setEnabled(enabled);
        this.chckbxSwapFile.setEnabled(enabled);
        this.defaultAreaConfigPanelJavaHeap.setEnabled(enabled && this.chckbxJavaHeap.isSelected());
        this.defaultAreaConfigPanelDirectHeap.setEnabled(enabled && this.chckbxDirectHeap.isSelected());
        this.defaultAreaConfigPanelSwapFile.setEnabled(enabled && this.chckbxSwapFile.isSelected());
    }

    public HeapConfig getHeapConfig() {
        return this.heapConfig;
    }

    public void setHeapConfig(HeapConfig heapConfig) {
        this.heapConfig = heapConfig;
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void refresh() {
        try {
            this.refreshing = true;
            String name = null;
            int pageSize = -1;
            boolean javaHeapPreferred = false;
            boolean javaHeapEnabled = false;
            boolean directHeapEnabled = false;
            boolean swapFileEnabled = false;
            AreaConfig javaHeapAreaConfig = null;
            AreaConfig directHeapAreaConfig = null;
            AreaConfig swapFileAreaConfig = null;
            HeapConfig config = this.getHeapConfig();
            if (config != null) {
                name = config.getName();
                pageSize = config.getDefaultPageSize();
                javaHeapPreferred = config.isJavaHeapPreferred();
                javaHeapAreaConfig = config.getJavaHeapAreaConfig();
                if (javaHeapAreaConfig != null) {
                    javaHeapEnabled = javaHeapAreaConfig.isAreaEnabled();
                }
                if ((directHeapAreaConfig = config.getDirectHeapAreaConfig()) != null) {
                    directHeapEnabled = directHeapAreaConfig.isAreaEnabled();
                }
                if ((swapFileAreaConfig = config.getSwapFileAreaConfig()) != null) {
                    swapFileEnabled = swapFileAreaConfig.isAreaEnabled();
                }
            }
            this.textFieldName.setText(name == null ? "" : name);
            this.textFieldPageSize.setText(pageSize < 1 ? "" : String.valueOf((long)pageSize / 0x100000L));
            this.chckbxJavaHeapPreferred.setSelected(javaHeapPreferred);
            this.chckbxJavaHeap.setSelected(javaHeapEnabled);
            this.chckbxDirectHeap.setSelected(directHeapEnabled);
            this.chckbxSwapFile.setSelected(swapFileEnabled);
            if (javaHeapAreaConfig == null) {
                javaHeapAreaConfig = new DefaultAreaConfig();
            }
            this.defaultAreaConfigPanelJavaHeap.setAreaConfig(javaHeapAreaConfig);
            if (directHeapAreaConfig == null) {
                directHeapAreaConfig = new DefaultAreaConfig();
            }
            this.defaultAreaConfigPanelDirectHeap.setAreaConfig(directHeapAreaConfig);
            if (swapFileAreaConfig == null) {
                swapFileAreaConfig = new DefaultAreaConfig();
            }
            this.defaultAreaConfigPanelSwapFile.setAreaConfig(swapFileAreaConfig);
            this.checkEnable();
        }
        finally {
            this.refreshing = false;
        }
    }

    protected synchronized void apply() {
        DefaultHeapConfig config = null;
        HeapConfig hc = this.getHeapConfig();
        if (hc != null && hc instanceof DefaultHeapConfig) {
            config = (DefaultHeapConfig)hc;
        }
        if (config == null) {
            return;
        }
        config.setJavaHeapPreferred(this.chckbxJavaHeapPreferred.isSelected());
        config.setName(this.textFieldName.getText());
        try {
            int pageSize = -1;
            String text = this.textFieldPageSize.getText().trim();
            if (text.length() > 0 && (pageSize = Integer.parseInt(text)) > 0) {
                pageSize = (int)((long)pageSize * 0x100000L);
            }
            config.setDefaultPageSize(pageSize);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        AreaConfig javaHeapAreaConfig = this.defaultAreaConfigPanelJavaHeap.getAreaConfig();
        if (javaHeapAreaConfig != null && javaHeapAreaConfig instanceof DefaultAreaConfig) {
            DefaultAreaConfig defConfig = (DefaultAreaConfig)javaHeapAreaConfig;
            defConfig.setAreaEnabled(this.chckbxJavaHeap.isSelected());
        }
        config.setJavaHeapAreaConfig(javaHeapAreaConfig);
        AreaConfig directHeapAreaConfig = this.defaultAreaConfigPanelDirectHeap.getAreaConfig();
        if (directHeapAreaConfig != null && directHeapAreaConfig instanceof DefaultAreaConfig) {
            DefaultAreaConfig defConfig = (DefaultAreaConfig)directHeapAreaConfig;
            defConfig.setAreaEnabled(this.chckbxDirectHeap.isSelected());
        }
        config.setDirectHeapAreaConfig(directHeapAreaConfig);
        AreaConfig swapFileAreaConfig = this.defaultAreaConfigPanelSwapFile.getAreaConfig();
        if (swapFileAreaConfig != null && swapFileAreaConfig instanceof DefaultAreaConfig) {
            DefaultAreaConfig defConfig = (DefaultAreaConfig)swapFileAreaConfig;
            defConfig.setAreaEnabled(this.chckbxSwapFile.isSelected());
        }
        config.setSwapFileAreaConfig(swapFileAreaConfig);
        this.checkEnable();
    }

    protected DefaultAreaConfigPanel getDefaultAreaConfigPanelJavaHeap() {
        return this.defaultAreaConfigPanelJavaHeap;
    }

    protected DefaultAreaConfigPanel getDefaultAreaConfigPanelDirectHeap() {
        return this.defaultAreaConfigPanelDirectHeap;
    }

    protected DefaultAreaConfigPanel getDefaultAreaConfigPanelSwapFile() {
        return this.defaultAreaConfigPanelSwapFile;
    }
}

