/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.heap.view;

import com.spacekiller.util.heap.AreaInfo;
import com.spacekiller.util.heap.HeapInfo;
import com.spacekiller.util.heap.HeapSummary;
import com.spacekiller.util.heap.view.AreaInfoPanel;
import com.spacekiller.util.heap.view.HeapSummaryBarPanel;
import com.spacekiller.util.heap.view.HeapSummaryInfoPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class HeapInfoPanel
extends JPanel {
    private static final long serialVersionUID = 2876087222479246996L;
    private static final Logger logger = Logger.getLogger(HeapInfoPanel.class.getName());
    private HeapInfo heapInfo;
    private DefaultListModel areaInfoListModel;
    private HeapSummary heapSummary;
    private Timer refreshTimer;
    private int refreshDelay = 1000;
    private boolean refreshTimerEnabled = true;
    private boolean refreshing;
    private HeapSummaryInfoPanel heapSummaryPanel;
    private HeapSummaryBarPanel heapSummaryBarPanel;
    private JList listAreas;
    private AreaInfoPanel areaInfoPanel;

    public HeapInfoPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JPanel panelHeapDetails = new JPanel();
        panelHeapDetails.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Heap Details", 4, 2, null, null));
        GridBagConstraints gbc_panelHeapDetails = new GridBagConstraints();
        gbc_panelHeapDetails.insets = new Insets(4, 4, 4, 4);
        gbc_panelHeapDetails.weightx = 1.0;
        gbc_panelHeapDetails.fill = 1;
        gbc_panelHeapDetails.gridx = 0;
        gbc_panelHeapDetails.gridy = 0;
        this.add((Component)panelHeapDetails, gbc_panelHeapDetails);
        GridBagLayout gbl_panelHeapDetails = new GridBagLayout();
        gbl_panelHeapDetails.columnWidths = new int[]{0, 0};
        gbl_panelHeapDetails.rowHeights = new int[]{0, 0};
        gbl_panelHeapDetails.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelHeapDetails.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelHeapDetails.setLayout(gbl_panelHeapDetails);
        JPanel panel = new JPanel();
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.insets = new Insets(4, 4, 4, 4);
        gbc_panel.weightx = 1.0;
        gbc_panel.fill = 1;
        gbc_panel.gridx = 0;
        gbc_panel.gridy = 0;
        panelHeapDetails.add((Component)panel, gbc_panel);
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{0, 0, 0};
        gbl_panel.rowHeights = new int[]{0, 0};
        gbl_panel.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panel.setLayout(gbl_panel);
        JPanel panelHeapMonitor = new JPanel();
        panelHeapMonitor.setBorder(new EtchedBorder(1, null, null));
        GridBagConstraints gbc_panelHeapMonitor = new GridBagConstraints();
        gbc_panelHeapMonitor.fill = 1;
        gbc_panelHeapMonitor.gridx = 1;
        gbc_panelHeapMonitor.gridy = 0;
        panel.add((Component)panelHeapMonitor, gbc_panelHeapMonitor);
        GridBagLayout gbl_panelHeapMonitor = new GridBagLayout();
        gbl_panelHeapMonitor.columnWidths = new int[]{0, 0};
        gbl_panelHeapMonitor.rowHeights = new int[]{0, 0};
        gbl_panelHeapMonitor.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelHeapMonitor.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelHeapMonitor.setLayout(gbl_panelHeapMonitor);
        this.heapSummaryBarPanel = new HeapSummaryBarPanel();
        GridBagConstraints gbc_heapSummaryBarPanel = new GridBagConstraints();
        gbc_heapSummaryBarPanel.weighty = 1.0;
        gbc_heapSummaryBarPanel.weightx = 1.0;
        gbc_heapSummaryBarPanel.fill = 1;
        gbc_heapSummaryBarPanel.gridx = 0;
        gbc_heapSummaryBarPanel.gridy = 0;
        panelHeapMonitor.add((Component)this.heapSummaryBarPanel, gbc_heapSummaryBarPanel);
        this.heapSummaryBarPanel.setReverse(true);
        this.heapSummaryBarPanel.setOrientation(1);
        this.heapSummaryPanel = new HeapSummaryInfoPanel();
        GridBagConstraints gbc_heapSummaryPanel = new GridBagConstraints();
        gbc_heapSummaryPanel.weightx = 1.0;
        gbc_heapSummaryPanel.insets = new Insets(0, 0, 0, 5);
        gbc_heapSummaryPanel.fill = 1;
        gbc_heapSummaryPanel.gridx = 0;
        gbc_heapSummaryPanel.gridy = 0;
        panel.add((Component)this.heapSummaryPanel, gbc_heapSummaryPanel);
        JPanel panelAreas = new JPanel();
        GridBagConstraints gbc_panelAreas = new GridBagConstraints();
        gbc_panelAreas.insets = new Insets(4, 4, 4, 4);
        gbc_panelAreas.weighty = 1.0;
        gbc_panelAreas.weightx = 1.0;
        gbc_panelAreas.fill = 1;
        gbc_panelAreas.gridx = 0;
        gbc_panelAreas.gridy = 1;
        this.add((Component)panelAreas, gbc_panelAreas);
        GridBagLayout gbl_panelAreas = new GridBagLayout();
        gbl_panelAreas.columnWidths = new int[]{0, 0, 0};
        gbl_panelAreas.rowHeights = new int[]{0, 0};
        gbl_panelAreas.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panelAreas.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelAreas.setLayout(gbl_panelAreas);
        JPanel panelAreaList = new JPanel();
        GridBagConstraints gbc_panelAreaList = new GridBagConstraints();
        gbc_panelAreaList.weighty = 1.0;
        gbc_panelAreaList.weightx = 1.0;
        gbc_panelAreaList.fill = 1;
        gbc_panelAreaList.insets = new Insets(0, 0, 0, 5);
        gbc_panelAreaList.gridx = 0;
        gbc_panelAreaList.gridy = 0;
        panelAreas.add((Component)panelAreaList, gbc_panelAreaList);
        panelAreaList.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Areas", 4, 2, null, null));
        GridBagLayout gbl_panelAreaList = new GridBagLayout();
        gbl_panelAreaList.columnWidths = new int[]{0, 0};
        gbl_panelAreaList.rowHeights = new int[]{0, 0};
        gbl_panelAreaList.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelAreaList.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelAreaList.setLayout(gbl_panelAreaList);
        JPanel panel_2 = new JPanel();
        GridBagConstraints gbc_panel_2 = new GridBagConstraints();
        gbc_panel_2.weighty = 1.0;
        gbc_panel_2.weightx = 1.0;
        gbc_panel_2.fill = 1;
        gbc_panel_2.gridx = 0;
        gbc_panel_2.gridy = 0;
        panelAreaList.add((Component)panel_2, gbc_panel_2);
        GridBagLayout gbl_panel_2 = new GridBagLayout();
        gbl_panel_2.columnWidths = new int[]{0, 0};
        gbl_panel_2.rowHeights = new int[]{0, 0};
        gbl_panel_2.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panel_2.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panel_2.setLayout(gbl_panel_2);
        JScrollPane scrollPane = new JScrollPane();
        GridBagConstraints gbc_scrollPane = new GridBagConstraints();
        gbc_scrollPane.weighty = 1.0;
        gbc_scrollPane.weightx = 1.0;
        gbc_scrollPane.insets = new Insets(4, 4, 4, 4);
        gbc_scrollPane.fill = 1;
        gbc_scrollPane.gridx = 0;
        gbc_scrollPane.gridy = 0;
        panel_2.add((Component)scrollPane, gbc_scrollPane);
        this.listAreas = new JList();
        this.listAreas.setSelectionMode(0);
        this.listAreas.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (HeapInfoPanel.this.refreshing) {
                    return;
                }
                HeapInfoPanel.this.refreshAreaDetails();
            }
        });
        scrollPane.setViewportView(this.listAreas);
        JPanel panelAreaDetails = new JPanel();
        GridBagConstraints gbc_panelAreaDetails = new GridBagConstraints();
        gbc_panelAreaDetails.fill = 1;
        gbc_panelAreaDetails.weighty = 1.0;
        gbc_panelAreaDetails.weightx = 1.0;
        gbc_panelAreaDetails.gridx = 1;
        gbc_panelAreaDetails.gridy = 0;
        panelAreas.add((Component)panelAreaDetails, gbc_panelAreaDetails);
        panelAreaDetails.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Area Details", 4, 2, null, null));
        GridBagLayout gbl_panelAreaDetails = new GridBagLayout();
        gbl_panelAreaDetails.columnWidths = new int[]{0, 0};
        gbl_panelAreaDetails.rowHeights = new int[]{0, 0};
        gbl_panelAreaDetails.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelAreaDetails.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelAreaDetails.setLayout(gbl_panelAreaDetails);
        this.areaInfoPanel = new AreaInfoPanel();
        GridBagConstraints gbc_areaInfoPanel = new GridBagConstraints();
        gbc_areaInfoPanel.insets = new Insets(4, 4, 4, 4);
        gbc_areaInfoPanel.weighty = 1.0;
        gbc_areaInfoPanel.weightx = 1.0;
        gbc_areaInfoPanel.fill = 1;
        gbc_areaInfoPanel.gridx = 0;
        gbc_areaInfoPanel.gridy = 0;
        panelAreaDetails.add((Component)this.areaInfoPanel, gbc_areaInfoPanel);
        this.initHeapInfoPanel();
    }

    protected void initHeapInfoPanel() {
        this.heapSummary = new HeapSummary();
        this.areaInfoListModel = new DefaultListModel();
        this.getListAreas().setModel(this.areaInfoListModel);
        int delay = this.getRefreshDelay();
        this.refreshTimer = new Timer(delay, new Refresher());
        this.addHierarchyListener(new HierarchyHandler());
        this.getListAreas().setCellRenderer(new AreaInfoListCellRenderer());
    }

    private HeapInfo getHeapInfo() {
        return this.heapInfo;
    }

    public void setHeapInfo(HeapInfo heapInfo) {
        this.heapInfo = heapInfo;
        this.refresh();
        this.startStopTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        try {
            this.refreshing = true;
            HeapSummary heapSummary = null;
            AreaInfo[] areaInfos = null;
            HeapInfo heapInfo = this.getHeapInfo();
            if (heapInfo != null) {
                heapSummary = this.heapSummary;
                heapSummary = heapInfo.getHeapSummary(heapSummary);
                areaInfos = heapInfo.getAreaInfo();
            }
            this.getHeapSummaryPanel().setHeapSummary(heapSummary);
            this.getHeapSummaryBarPanel().setHeapSummary(heapSummary);
            int num = areaInfos == null ? 0 : areaInfos.length;
            boolean changed = true;
            if (num == this.areaInfoListModel.getSize()) {
                changed = false;
                for (int i = 0; i < num; ++i) {
                    if (areaInfos[i] == this.areaInfoListModel.getElementAt(i)) continue;
                    changed = true;
                    break;
                }
            }
            if (changed) {
                int sel = this.getListAreas().getSelectedIndex();
                this.areaInfoListModel.removeAllElements();
                for (int i = 0; i < num; ++i) {
                    AreaInfo areaInfo = areaInfos[i];
                    if (areaInfo == null) continue;
                    this.areaInfoListModel.addElement(areaInfo);
                }
                if (sel < 0) {
                    sel = 0;
                }
                if (sel >= this.areaInfoListModel.getSize()) {
                    sel = -1;
                }
                this.getListAreas().setSelectedIndex(sel);
            }
        }
        finally {
            this.refreshing = false;
        }
        this.refreshAreaDetails();
    }

    protected void refreshAreaDetails() {
        int index = -1;
        int[] sel = this.getListAreas().getSelectedIndices();
        if (sel != null && sel.length == 1) {
            index = sel[0];
        }
        AreaInfo areaInfo = null;
        if (index >= 0) {
            areaInfo = (AreaInfo)this.areaInfoListModel.get(index);
        }
        this.getAreaInfoPanel().setAreaInfo(areaInfo);
    }

    protected HeapSummaryInfoPanel getHeapSummaryPanel() {
        return this.heapSummaryPanel;
    }

    protected HeapSummaryBarPanel getHeapSummaryBarPanel() {
        return this.heapSummaryBarPanel;
    }

    public int getRefreshDelay() {
        return this.refreshDelay;
    }

    public void setRefreshDelay(int refreshDelay) {
        this.refreshDelay = refreshDelay;
        if (this.refreshTimer != null) {
            this.refreshTimer.setDelay(refreshDelay);
            this.refreshTimer.setInitialDelay(refreshDelay);
        }
    }

    public boolean isRefreshTimerEnabled() {
        return this.refreshTimerEnabled;
    }

    public void setRefreshTimerEnabled(boolean refreshTimerEnabled) {
        this.refreshTimerEnabled = refreshTimerEnabled;
    }

    protected void startStopTimer() {
        Timer tima = this.refreshTimer;
        if (tima == null) {
            return;
        }
        if (this.heapInfo != null && this.isRefreshTimerEnabled() && this.isShowing()) {
            if (!tima.isRunning()) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Starting HeapMonitor update timer: " + tima);
                }
                tima.start();
            }
        } else if (tima.isRunning()) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Stopping HeapMonitor update timer: " + tima);
            }
            tima.stop();
        }
    }

    protected JList getListAreas() {
        return this.listAreas;
    }

    protected AreaInfoPanel getAreaInfoPanel() {
        return this.areaInfoPanel;
    }

    protected class AreaInfoListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -3361021669003541204L;

        protected AreaInfoListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            AreaInfo areaInfo;
            Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            String text = null;
            if (value != null && value instanceof AreaInfo && (areaInfo = (AreaInfo)value) != null) {
                text = areaInfo.getName();
            }
            if (text == null) {
                text = String.valueOf(value);
            }
            this.setText(text);
            return comp;
        }
    }

    protected class HierarchyHandler
    implements HierarchyListener {
        protected HierarchyHandler() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            long flags = e.getChangeFlags();
            if ((flags & 4L) != 0L) {
                HeapInfoPanel.this.startStopTimer();
            }
        }
    }

    protected class Refresher
    implements ActionListener {
        protected Refresher() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HeapInfoPanel.this.refresh();
        }
    }
}

