/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.heap.view;

import com.spacekiller.util.heap.HeapSummary;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;

public class HeapSummaryBarPanel
extends JPanel {
    private static final long serialVersionUID = 1855714331019947388L;
    private HeapSummary heapSummary;
    private int orientation = 0;
    private boolean reverse;
    private Color backColor = null;
    private Color lineColor = Color.GRAY;
    private Color freeColor = Color.LIGHT_GRAY.brighter();
    private Color usedColor = Color.GREEN.darker();

    public HeapSummaryBarPanel() {
        this.setPreferredSize(new Dimension(40, 40));
    }

    public HeapSummary getHeapSummary() {
        return this.heapSummary;
    }

    public void setHeapSummary(HeapSummary heapSummary) {
        this.heapSummary = heapSummary;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        HeapSummary heapSummary = this.getHeapSummary();
        if (heapSummary != null) {
            Color lineColor;
            Color freeColor;
            Color usedColor;
            long limit = heapSummary.limit;
            long size = heapSummary.size;
            long free = heapSummary.free;
            long used = size - free;
            int orient = this.orientation;
            boolean reverse = this.reverse;
            int width = this.getWidth();
            int height = this.getHeight();
            int fullSize = 0;
            switch (orient) {
                case 0: {
                    fullSize = width;
                    break;
                }
                case 1: {
                    fullSize = height;
                }
            }
            Color backColor = this.backColor;
            if (backColor != null) {
                g.setColor(backColor);
                g.fillRect(0, 0, width, height);
            }
            if (limit < size) {
                limit = size;
            } else if (limit >= Long.MAX_VALUE) {
                limit = size;
            }
            if (limit < 1L) {
                limit = 1L;
            }
            int usedPixels = 0;
            if (used >= 0L && (usedPixels = Math.round((long)fullSize * used / limit)) > fullSize) {
                usedPixels = fullSize;
            }
            int freePixels = 0;
            if (free >= 0L) {
                freePixels = Math.round((long)fullSize * (used + free) / limit);
                if (freePixels > fullSize) {
                    freePixels = fullSize;
                }
                freePixels -= usedPixels;
            }
            if ((usedColor = this.usedColor) != null && usedPixels > 0) {
                g.setColor(usedColor);
                switch (orient) {
                    case 0: {
                        if (reverse) {
                            g.fillRect(fullSize - usedPixels, 0, usedPixels, height);
                            break;
                        }
                        g.fillRect(0, 0, usedPixels, height);
                        break;
                    }
                    case 1: {
                        if (reverse) {
                            g.fillRect(0, fullSize - usedPixels, width, usedPixels);
                            break;
                        }
                        g.fillRect(0, 0, width, usedPixels);
                    }
                }
            }
            if ((freeColor = this.freeColor) != null && freePixels > 0) {
                g.setColor(freeColor);
                switch (orient) {
                    case 0: {
                        if (reverse) {
                            g.fillRect(fullSize - usedPixels - freePixels, 0, freePixels, height);
                            break;
                        }
                        g.fillRect(usedPixels, 0, freePixels, height);
                        break;
                    }
                    case 1: {
                        if (reverse) {
                            g.fillRect(0, fullSize - usedPixels - freePixels, width, freePixels);
                            break;
                        }
                        g.fillRect(0, usedPixels, width, freePixels);
                    }
                }
            }
            if ((lineColor = this.lineColor) != null) {
                g.setColor(lineColor);
                switch (orient) {
                    case 0: {
                        if (reverse) {
                            g.fillRect(fullSize - usedPixels - freePixels - 1, 0, 1, height);
                            break;
                        }
                        g.fillRect(usedPixels + freePixels, 0, 1, height);
                        break;
                    }
                    case 1: {
                        if (reverse) {
                            g.fillRect(0, fullSize - usedPixels - freePixels - 1, width, 1);
                            break;
                        }
                        g.fillRect(0, usedPixels + freePixels, width, 1);
                    }
                }
            }
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
        this.repaint();
    }

    public Color getFreeColor() {
        return this.freeColor;
    }

    public void setFreeColor(Color freeColor) {
        this.freeColor = freeColor;
        this.repaint();
    }

    public Color getUsedColor() {
        return this.usedColor;
    }

    public void setUsedColor(Color usedColor) {
        this.usedColor = usedColor;
        this.repaint();
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
        this.repaint();
    }

    public Color getBackColor() {
        return this.backColor;
    }

    public void setBackColor(Color backColor) {
        this.backColor = backColor;
        this.repaint();
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
        this.repaint();
    }
}

