/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.heap.view;

import com.spacekiller.util.heap.HeapSummary;
import com.spacekiller.util.heap.view.HeapSummaryUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class HeapSummaryInfoPanel
extends JPanel {
    private static final long serialVersionUID = -9141148845311882811L;
    private HeapSummary heapSummary;
    private long limit = -1L;
    private long size = -1L;
    private long free = -1L;
    private long used = -1L;
    private JTextField textFieldUsed;
    private JTextField textFieldFree;
    private JTextField textFieldSize;
    private JTextField textFieldLimit;

    public HeapSummaryInfoPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JPanel panel = new JPanel();
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.weighty = 1.0;
        gbc_panel.weightx = 1.0;
        gbc_panel.fill = 1;
        gbc_panel.gridx = 0;
        gbc_panel.gridy = 0;
        this.add((Component)panel, gbc_panel);
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{0, 0, 0};
        gbl_panel.rowHeights = new int[]{0, 0, 0, 0, 0};
        gbl_panel.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        panel.setLayout(gbl_panel);
        JLabel lblLimit = new JLabel("Limit:");
        GridBagConstraints gbc_lblLimit = new GridBagConstraints();
        gbc_lblLimit.anchor = 17;
        gbc_lblLimit.insets = new Insets(0, 0, 5, 5);
        gbc_lblLimit.gridx = 0;
        gbc_lblLimit.gridy = 0;
        panel.add((Component)lblLimit, gbc_lblLimit);
        this.textFieldLimit = new JTextField();
        this.textFieldLimit.setEditable(false);
        GridBagConstraints gbc_textFieldLimit = new GridBagConstraints();
        gbc_textFieldLimit.insets = new Insets(0, 0, 5, 0);
        gbc_textFieldLimit.fill = 2;
        gbc_textFieldLimit.gridx = 1;
        gbc_textFieldLimit.gridy = 0;
        panel.add((Component)this.textFieldLimit, gbc_textFieldLimit);
        this.textFieldLimit.setColumns(10);
        JLabel lblSize = new JLabel("Size:");
        GridBagConstraints gbc_lblSize = new GridBagConstraints();
        gbc_lblSize.anchor = 17;
        gbc_lblSize.insets = new Insets(0, 0, 5, 5);
        gbc_lblSize.gridx = 0;
        gbc_lblSize.gridy = 1;
        panel.add((Component)lblSize, gbc_lblSize);
        this.textFieldSize = new JTextField();
        this.textFieldSize.setEditable(false);
        GridBagConstraints gbc_textFieldSize = new GridBagConstraints();
        gbc_textFieldSize.insets = new Insets(0, 0, 5, 0);
        gbc_textFieldSize.fill = 2;
        gbc_textFieldSize.gridx = 1;
        gbc_textFieldSize.gridy = 1;
        panel.add((Component)this.textFieldSize, gbc_textFieldSize);
        this.textFieldSize.setColumns(10);
        JLabel lblFree = new JLabel("Free:");
        GridBagConstraints gbc_lblFree = new GridBagConstraints();
        gbc_lblFree.anchor = 17;
        gbc_lblFree.insets = new Insets(0, 0, 5, 5);
        gbc_lblFree.gridx = 0;
        gbc_lblFree.gridy = 2;
        panel.add((Component)lblFree, gbc_lblFree);
        this.textFieldFree = new JTextField();
        this.textFieldFree.setEditable(false);
        GridBagConstraints gbc_textFieldFree = new GridBagConstraints();
        gbc_textFieldFree.insets = new Insets(0, 0, 5, 0);
        gbc_textFieldFree.fill = 2;
        gbc_textFieldFree.gridx = 1;
        gbc_textFieldFree.gridy = 2;
        panel.add((Component)this.textFieldFree, gbc_textFieldFree);
        this.textFieldFree.setColumns(10);
        JLabel lblUsed = new JLabel("Used:");
        GridBagConstraints gbc_lblUsed = new GridBagConstraints();
        gbc_lblUsed.anchor = 17;
        gbc_lblUsed.insets = new Insets(0, 0, 0, 5);
        gbc_lblUsed.gridx = 0;
        gbc_lblUsed.gridy = 3;
        panel.add((Component)lblUsed, gbc_lblUsed);
        this.textFieldUsed = new JTextField();
        this.textFieldUsed.setEditable(false);
        GridBagConstraints gbc_textFieldUsed = new GridBagConstraints();
        gbc_textFieldUsed.fill = 2;
        gbc_textFieldUsed.gridx = 1;
        gbc_textFieldUsed.gridy = 3;
        panel.add((Component)this.textFieldUsed, gbc_textFieldUsed);
        this.textFieldUsed.setColumns(10);
    }

    protected JTextField getTextFieldUsed() {
        return this.textFieldUsed;
    }

    protected JTextField getTextFieldFree() {
        return this.textFieldFree;
    }

    protected JTextField getTextFieldSize() {
        return this.textFieldSize;
    }

    protected JTextField getTextFieldLimit() {
        return this.textFieldLimit;
    }

    private HeapSummary getHeapSummary() {
        return this.heapSummary;
    }

    public void setHeapSummary(HeapSummary heapSummary) {
        this.heapSummary = heapSummary;
        this.refresh();
    }

    protected void refresh() {
        long limit = -1L;
        long size = -1L;
        long free = -1L;
        HeapSummary heapSummary = this.getHeapSummary();
        if (heapSummary != null) {
            limit = heapSummary.getLimit();
            size = heapSummary.getSize();
            free = heapSummary.getFree();
        }
        long used = -1L;
        if (free >= 0L && size >= 0L) {
            used = size - free;
        }
        if (limit != this.limit) {
            this.limit = limit;
            String strLimit = null;
            if (limit >= 0L && limit < Long.MAX_VALUE) {
                strLimit = HeapSummaryUtil.getHumanByteSizeString(limit, true);
            }
            if (strLimit == null) {
                strLimit = "";
            }
            if (!strLimit.equals(this.getTextFieldLimit().getText())) {
                this.getTextFieldLimit().setText(strLimit);
                this.getTextFieldLimit().setCaretPosition(0);
            }
        }
        if (size != this.size) {
            this.size = size;
            String strSize = null;
            if (size >= 0L) {
                strSize = HeapSummaryUtil.getHumanByteSizeString(size, true);
            }
            if (strSize == null) {
                strSize = "";
            }
            if (!strSize.equals(this.getTextFieldSize().getText())) {
                this.getTextFieldSize().setText(strSize);
                this.getTextFieldSize().setCaretPosition(0);
            }
        }
        if (free != this.free) {
            this.free = free;
            String strFree = null;
            if (free >= 0L) {
                strFree = HeapSummaryUtil.getHumanByteSizeString(free, false);
            }
            if (strFree == null) {
                strFree = "";
            }
            if (!strFree.equals(this.getTextFieldFree().getText())) {
                this.getTextFieldFree().setText(strFree);
                this.getTextFieldFree().setCaretPosition(0);
            }
        }
        if (used != this.used) {
            this.used = used;
            String strUsed = null;
            if (used >= 0L) {
                strUsed = HeapSummaryUtil.getHumanByteSizeString(used, true);
            }
            if (strUsed == null) {
                strUsed = "";
            }
            if (!strUsed.equals(this.getTextFieldUsed().getText())) {
                this.getTextFieldUsed().setText(strUsed);
                this.getTextFieldUsed().setCaretPosition(0);
            }
        }
    }
}

