/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.plaf.bene;

import com.spacekiller.plaf.bene.BeneArea;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;

public class SmoothArea
implements BeneArea {
    private Color color;
    private Color[] upperLeftColors;
    private Color[] lowerRightColors;

    public SmoothArea(Color center, Color[] upperLeft, Color[] lowerRight) {
        this.setColor(center);
        this.setUpperLeftColors(upperLeft);
        this.setLowerRightColors(lowerRight);
    }

    protected Color getColor() {
        return this.color;
    }

    protected Color[] getLowerRightColors() {
        return this.lowerRightColors;
    }

    protected Color[] getUpperLeftColors() {
        return this.upperLeftColors;
    }

    @Override
    public void paintArea(Component comp, Graphics g, int x, int y, int w, int h) {
        int x2 = x + w - 1;
        int y2 = y + h - 1;
        Color[] cols = this.getUpperLeftColors();
        int n = cols.length;
        for (int c = 0; c < n; ++c) {
            g.setColor(cols[c]);
            g.drawLine(x + c, y + c, x + c, y2 - c);
            g.drawLine(x + c + 1, y + c, x2 - c, y + c);
        }
        cols = this.getLowerRightColors();
        int m = cols.length;
        for (int c = 0; c < m; ++c) {
            g.setColor(cols[c]);
            g.drawLine(x2 - c, y + c + 1, x2 - c, y2 - c);
            g.drawLine(x + c + 1, y2 - c, x2 - c - 1, y2 - c);
        }
        Color col = this.getColor();
        if (col != null) {
            g.setColor(this.getColor());
            g.fillRect(x + n, y + n, w - m - n, h - m - n);
        }
    }

    private void setColor(Color newColor) {
        this.color = newColor;
    }

    private void setLowerRightColors(Color[] newLowerRightColors) {
        this.lowerRightColors = newLowerRightColors;
    }

    private void setUpperLeftColors(Color[] newUpperLeftColors) {
        this.upperLeftColors = newUpperLeftColors;
    }
}

