/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.ClassRegistry;
import com.spacekiller.util.Clock;
import com.spacekiller.util.ConfigInjector;
import com.spacekiller.util.DesktopManager;
import com.spacekiller.util.ExecutionManager;
import com.spacekiller.util.Extension;
import com.spacekiller.util.ExtensionPoint;
import com.spacekiller.util.FileListener;
import com.spacekiller.util.FileLocator;
import com.spacekiller.util.FileManager;
import com.spacekiller.util.FileTypeRegistry;
import com.spacekiller.util.Injection;
import com.spacekiller.util.InjectionFactory;
import com.spacekiller.util.LoginManager;
import com.spacekiller.util.Plugin;
import com.spacekiller.util.PluginDescriptor;
import com.spacekiller.util.Preferences;
import com.spacekiller.util.PreferencesRegistry;
import com.spacekiller.util.RuntimeContext;
import com.spacekiller.util.SensorManager;
import com.spacekiller.util.ThreadManager;
import com.spacekiller.util.Tools;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Timer;
import java.util.logging.Logger;

public abstract class Platform {
    public static final String SYSTEM_PROPERTY_PLATFORM = "com.spacekiller.util.platform";
    private static Platform platform = null;

    protected Platform() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Platform getInstance() {
        if (platform != null) return platform;
        Class<Platform> clazz = Platform.class;
        synchronized (Platform.class) {
            if (platform != null) return platform;
            String platformClassName = System.getProperty(SYSTEM_PROPERTY_PLATFORM);
            if (platformClassName == null) {
                throw new RuntimeException("Platform-Class not specified in system-properties: com.spacekiller.util.platform");
            }
            try {
                Class<?> platformClass = Class.forName(platformClassName);
                Platform pf = (Platform)Tools.newInstance(platformClass);
                Platform.setInstance(pf);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return platform;
        }
    }

    public static boolean isInstanceAvailable() {
        return platform != null;
    }

    public abstract Iterator getServices(Class var1) throws Exception;

    protected abstract RuntimeContext getRuntimeContext(Plugin var1);

    public abstract RuntimeContext getRuntimeContext();

    public abstract PreferencesRegistry getPreferencesRegistry();

    public abstract ClassRegistry getClassRegistry();

    public abstract BeansToolkit getBeansToolkit();

    public abstract FileTypeRegistry getFileTypeRegistry();

    public abstract InjectionFactory getInjectionFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void setInstance(Platform instance) throws Exception {
        Class<Platform> clazz = Platform.class;
        synchronized (Platform.class) {
            if (platform != null) {
                throw new IllegalAccessException("Platform instance already registered");
            }
            platform = instance;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterPlatform() {
        Class<Platform> clazz = Platform.class;
        synchronized (Platform.class) {
            if (platform == this) {
                platform = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected abstract void setPluginPreferences(Plugin var1, Preferences var2);

    protected void startupPlugin(Plugin plugin) {
        plugin.startup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdownPlugin(Plugin plugin) {
        try {
            plugin.shutdown();
        }
        finally {
            plugin.plugout();
        }
    }

    protected void initPlugin(Plugin plugin, PluginDescriptor descr, ConfigInjector injector, Injection injection) {
        plugin.plugin(this, descr, injector, injection);
    }

    public abstract String[] getPluginIds() throws Exception;

    public abstract PluginDescriptor getPluginDescriptor(String var1) throws Exception;

    public PluginDescriptor getPluginDescriptor(Plugin plugin) throws Exception {
        return plugin.getDescriptor();
    }

    public abstract Plugin getPlugin(String var1) throws Exception;

    public Plugin getPlugin(PluginDescriptor descr) throws Exception {
        String id = descr.getId();
        return this.getPlugin(id);
    }

    protected abstract void registerExtension(PluginDescriptor var1, Extension var2) throws Exception;

    protected abstract void unregisterExtension(PluginDescriptor var1, Extension var2) throws Exception;

    protected void fireExtensionAvailable(Plugin plugin, ExtensionPoint point, Extension extension) {
        plugin.extensionAvailable(point, extension);
    }

    protected void fireExtensionUnavailable(Plugin plugin, ExtensionPoint point, Extension extension) {
        plugin.extensionUnavailable(point, extension);
    }

    protected Object getExtensionInstance(Extension extension) throws Exception {
        PluginDescriptor descr = extension.getDeclaringPluginDescriptor();
        Plugin plugin = this.getPlugin(descr);
        return plugin.getExtensionInstance(extension);
    }

    public abstract ExecutionManager getExecutionManager();

    public abstract ThreadManager getThreadManager();

    public abstract FileLocator getFileLocator();

    public abstract FileListener getFileListener();

    public abstract FileManager getFileManager();

    public abstract SensorManager getSensorManager();

    public abstract File getHomeDir();

    public abstract File getDataDir();

    public abstract File getLogDir();

    public abstract File getConfigDir();

    public abstract File getTempDir();

    public abstract void addShutdownHook(Thread var1);

    public abstract void removeShutdownHook(Thread var1);

    public abstract void shutdown() throws Exception;

    public abstract void exit(int var1) throws Exception;

    public abstract boolean isShutdownInProgress();

    public abstract Timer getTimer();

    public abstract void addPostStartupHook(Thread var1);

    public abstract void removePostStartupHook(Thread var1);

    public abstract boolean isHeadless();

    public abstract void debugReference(Object var1);

    public abstract DesktopManager getDesktopManager();

    public abstract LoginManager getLoginManager();

    public abstract Clock getClock();

    public abstract File createTempFile(String var1, String var2) throws IOException;

    public abstract double getJavaVersion();

    public static boolean isJavaVersionCompatible(double javaVersion) {
        return Platform.getInstance().getJavaVersion() >= javaVersion;
    }

    public static boolean isJava15Compatible() {
        return Platform.getInstance().getJavaVersion() >= 1.5;
    }

    public static boolean isJava16Compatible() {
        return Platform.getInstance().getJavaVersion() >= 1.6;
    }

    public static Logger getLogger(Class clazz) {
        return Logger.getLogger(clazz.getName());
    }

    public static Logger getLogger(Class clazz, String resourceBundleName) {
        return Logger.getLogger(clazz.getName(), resourceBundleName);
    }

    public abstract String getApplicationName();

    public abstract String getApplicationTitle();

    public abstract String getApplicationVersion();

    public abstract String getDistributionProperty(String var1);

    public abstract byte[] getDistributionResourceData(String var1) throws IOException;

    public abstract boolean showJavaRuntimeWizard(Object var1);
}

