/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public final class Tools {
    private static final Logger logger = Logger.getLogger(Tools.class.getName());
    private static final Class[] NULL_TYPES = new Class[0];
    private static final Object[] NULL_OBJECTS = new Object[0];
    private static Font defaultFont;

    private Tools() {
    }

    public static Object newInstance(Class type) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        return type.getConstructor(NULL_TYPES).newInstance(NULL_OBJECTS);
    }

    public static Icon getIcon(Class clazz, String resource) {
        URL url = clazz.getResource(resource);
        if (url == null) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("Icon resource not found: class=" + clazz + ", resource=" + resource);
            }
            return null;
        }
        return new ImageIcon(url);
    }

    public static URL getFileURL(File file) throws MalformedURLException {
        return file.toURI().toURL();
    }

    public static URI getFileURI(File file) {
        return file.toURI();
    }

    public static File getURLFile(URL fileURL) throws Exception {
        if (fileURL == null) {
            return null;
        }
        if ("file".equals(fileURL.getProtocol())) {
            String path = fileURL.getPath();
            path = URLDecoder.decode(path, "UTF-8");
            File file = new File(path);
            return file;
        }
        return null;
    }

    public static File getURIFile(URI fileURI) throws Exception {
        if (fileURI == null) {
            return null;
        }
        if ("file".equals(fileURI.getScheme())) {
            String path = fileURI.getPath();
            path = URLDecoder.decode(path, "UTF-8");
            File file = new File(path);
            return file;
        }
        return null;
    }

    public static Level getLoggerLevel(Logger logger) {
        while (logger != null) {
            Level level = logger.getLevel();
            if (level != null) {
                return level;
            }
            logger = logger.getParent();
        }
        return null;
    }

    public static String quoteRegex(String s) {
        int slashEIndex = s.indexOf("\\E");
        if (slashEIndex == -1) {
            return "\\Q" + s + "\\E";
        }
        StringBuffer sb = new StringBuffer(s.length() * 2);
        sb.append("\\Q");
        slashEIndex = 0;
        int current = 0;
        while ((slashEIndex = s.indexOf("\\E", current)) != -1) {
            sb.append(s.substring(current, slashEIndex));
            current = slashEIndex + 2;
            sb.append("\\E\\\\E\\Q");
        }
        sb.append(s.substring(current, s.length()));
        sb.append("\\E");
        return sb.toString();
    }

    public static String quoteJava(String s) {
        if (s == null) {
            return "null";
        }
        StringBuffer sbuf = new StringBuffer();
        sbuf.append('\"');
        int len = s.length();
        block8: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': {
                    sbuf.append("\\\"");
                    continue block8;
                }
                case '\\': {
                    sbuf.append("\\\\");
                    continue block8;
                }
                case '\r': {
                    sbuf.append("\\r");
                    continue block8;
                }
                case '\n': {
                    sbuf.append("\\n");
                    continue block8;
                }
                case '\t': {
                    sbuf.append("\\t");
                    continue block8;
                }
                case '\f': {
                    sbuf.append("\\f");
                    continue block8;
                }
                default: {
                    sbuf.append(c);
                }
            }
        }
        sbuf.append('\"');
        return sbuf.toString();
    }

    public static Image createImage(Component comp, Class clazz, String resource) throws Exception {
        URL url = clazz.getResource(resource);
        if (url == null) {
            return null;
        }
        Image img = new ImageIcon(url).getImage();
        MediaTracker tracker = new MediaTracker(comp);
        tracker.addImage(img, 0);
        tracker.waitForID(0);
        return img;
    }

    public static TexturePaint createImageTexture(Component comp, Image img) {
        int iw = img.getWidth(comp);
        int ih = img.getHeight(comp);
        BufferedImage bi = new BufferedImage(iw, ih, 1);
        Graphics2D tG2 = bi.createGraphics();
        tG2.drawImage(img, 0, 0, comp);
        Rectangle r = new Rectangle(0, 0, iw, ih);
        return new TexturePaint(bi, r);
    }

    public static void centerWindow(Window window) {
        Tools.centerWindow(null, window);
    }

    public static void centerWindow(Component owner, Window window) {
        Dimension windowSize = window.getSize();
        Rectangle ownerBounds = null;
        if (owner != null && owner.isShowing()) {
            try {
                Point p = owner.getLocationOnScreen();
                if (p != null) {
                    ownerBounds = owner.getBounds();
                    ownerBounds.x = p.x;
                    ownerBounds.y = p.y;
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        try {
            Point center;
            if (ownerBounds != null) {
                center = new Point(ownerBounds.x + ownerBounds.width / 2, ownerBounds.y + ownerBounds.height / 2);
            } else {
                GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
                center = env.getCenterPoint();
                if (center == null) {
                    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                    center = new Point(screenSize.width / 2, screenSize.height / 2);
                }
            }
            window.setLocation(center.x - windowSize.width / 2, center.y - windowSize.height / 2);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        Tools.ensureWindowFitsScreen(window);
    }

    public static void ensureWindowFitsScreen(Window window) {
        Rectangle windowBounds = window.getBounds();
        try {
            GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Rectangle screenBounds = env.getMaximumWindowBounds();
            if (screenBounds == null) {
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                screenBounds = new Rectangle(0, 0, screenSize.width, screenSize.height);
            }
            boolean valid = true;
            if (windowBounds.width > screenBounds.width) {
                windowBounds.width = screenBounds.width;
                valid = false;
            }
            if (windowBounds.height > screenBounds.height) {
                windowBounds.height = screenBounds.height;
                valid = false;
            }
            if (windowBounds.x < screenBounds.x) {
                windowBounds.x = screenBounds.x;
                valid = false;
            }
            if (windowBounds.y < screenBounds.y) {
                windowBounds.y = screenBounds.y;
                valid = false;
            }
            if (windowBounds.x + windowBounds.width > screenBounds.x + screenBounds.width) {
                windowBounds.x = screenBounds.x + screenBounds.width - windowBounds.width;
                valid = false;
            }
            if (windowBounds.y + windowBounds.height > screenBounds.y + screenBounds.height) {
                windowBounds.y = screenBounds.y + screenBounds.height - windowBounds.height;
                valid = false;
            }
            if (!valid) {
                window.setBounds(windowBounds);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public static void propagateFont(Font font, Component[] comps) {
        if (font == null) {
            return;
        }
        if (comps == null) {
            return;
        }
        for (Component comp : comps) {
            if (comp == null) continue;
            comp.setFont(font);
        }
    }

    public static Font getDefaultFont() {
        Font font = defaultFont;
        if (font == null) {
            JLabel dummyLabel = new JLabel();
            font = dummyLabel.getFont();
            if (font == null) {
                font = new Font("dialog", 0, 12);
            }
            defaultFont = font;
        }
        return font;
    }

    public static Font getDefaultFont(int style) {
        Font font = Tools.getDefaultFont();
        return new Font(font.getName(), style, font.getSize());
    }

    public static int floorMod(int x, int y) {
        int mod = x % y;
        if ((mod ^ y) < 0 && mod != 0) {
            mod += y;
        }
        return mod;
    }

    public static long floorMod(long x, long y) {
        long mod = x % y;
        if ((x ^ y) < 0L && mod != 0L) {
            mod += y;
        }
        return mod;
    }
}

