/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util;

import com.spacekiller.util.Resource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;

public final class URIResource
implements Resource {
    private final URI uri;

    public URIResource(URI uri) {
        if (uri == null) {
            throw new NullPointerException();
        }
        this.uri = uri;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public URL getURL() throws IOException {
        return this.uri.toURL();
    }

    @Override
    public InputStream createInputStream() throws IOException {
        return this.uri.toURL().openStream();
    }

    @Override
    public boolean isFile() {
        return false;
    }

    @Override
    public File getFile() {
        return null;
    }

    public String toString() {
        return this.uri.toString();
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != URIResource.class) {
            return false;
        }
        URIResource r = (URIResource)obj;
        return this.uri.equals(r.getURI());
    }
}

