/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans;

import java.beans.PropertyVetoException;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextServiceAvailableEvent;
import java.beans.beancontext.BeanContextServiceRevokedEvent;
import java.beans.beancontext.BeanContextServices;
import java.beans.beancontext.BeanContextServicesListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractBeanContextServicesListener
implements BeanContextServicesListener {
    private transient BeanContextChild beanContextChild;
    private transient BeanContext beanContext = null;
    private transient Vector requestedServices = new Vector();
    private transient Hashtable availableServices = new Hashtable();
    private static final Logger logger = Logger.getLogger(AbstractBeanContextServicesListener.class.getName());

    public AbstractBeanContextServicesListener(BeanContextChild newBeanContextChild) {
        this.setBeanContextChild(newBeanContextChild);
    }

    protected void addAvailableService(Class serviceClass, Object service) {
        if (service == null || serviceClass == null) {
            return;
        }
        Object old = this.availableServices.get(serviceClass);
        if (old == service) {
            return;
        }
        this.availableServices.put(serviceClass, service);
        this.serviceChanged(serviceClass, service);
    }

    public void addServiceRequest(Class serviceClass) {
        if (serviceClass == null) {
            return;
        }
        if (!this.requestedServices.contains(serviceClass)) {
            this.requestedServices.add(serviceClass);
        }
    }

    public BeanContext getBeanContext() {
        return this.beanContext;
    }

    public BeanContextChild getBeanContextChild() {
        return this.beanContextChild;
    }

    protected Object getBeanContextService(Class serviceClass) throws Exception {
        BeanContextServices services = this.getBeanContextServices();
        if (services != null) {
            return services.getService(this.getBeanContextChild(), this.getBeanContextChild(), serviceClass, null, this);
        }
        return null;
    }

    protected BeanContextServices getBeanContextServices() {
        BeanContextServices services = (BeanContextServices)this.getBeanContext();
        return services;
    }

    protected void initializeBeanContextResources() {
        BeanContextServices services = this.getBeanContextServices();
        if (services == null) {
            return;
        }
        services.addBeanContextServicesListener(this);
        int count = this.requestedServices.size();
        for (int c = 0; c < count; ++c) {
            Class serviceClass = (Class)this.requestedServices.get(c);
            try {
                Object service = this.getBeanContextService(serviceClass);
                if (service == null) continue;
                this.addAvailableService(serviceClass, service);
                continue;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    protected void releaseBeanContextResources() {
        BeanContextServices services = this.getBeanContextServices();
        if (services != null) {
            services.removeBeanContextServicesListener(this);
        }
        Enumeration en = this.availableServices.keys();
        while (en.hasMoreElements()) {
            Class serviceClass = (Class)en.nextElement();
            Object service = this.availableServices.get(serviceClass);
            this.removeAvailableService(serviceClass, service);
        }
    }

    protected void removeAvailableService(Class serviceClass, Object service) {
        Object old = this.availableServices.get(serviceClass);
        if (old == service) {
            this.availableServices.remove(serviceClass);
            this.serviceChanged(serviceClass, null);
        }
    }

    public void removeServiceRequest(Class serviceClass) {
        if (serviceClass == null) {
            return;
        }
        this.requestedServices.remove(serviceClass);
    }

    @Override
    public void serviceAvailable(BeanContextServiceAvailableEvent bcsae) {
    }

    protected abstract void serviceChanged(Class var1, Object var2);

    @Override
    public void serviceRevoked(BeanContextServiceRevokedEvent bcsre) {
    }

    public void setBeanContext(BeanContext bc) throws PropertyVetoException {
        BeanContext old = this.beanContext;
        if (old != null) {
            this.releaseBeanContextResources();
        }
        this.beanContext = bc;
        if (bc != null) {
            this.initializeBeanContextResources();
        }
    }

    private void setBeanContextChild(BeanContextChild newBeanContextChild) {
        this.beanContextChild = newBeanContextChild;
    }
}

