/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans;

import com.spacekiller.util.ListenerList;
import com.spacekiller.util.beans.Selection;
import com.spacekiller.util.beans.SelectionEvent;
import com.spacekiller.util.beans.SelectionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractSelection
implements Selection {
    private Object source;
    private ArrayList objects = new ArrayList();
    private ArrayList types = new ArrayList();
    private Map classes = new HashMap();
    private ListenerList<SelectionListener> selectionListenerList;

    public AbstractSelection(Object source) {
        this.setSource(source);
    }

    protected synchronized void addSelectedObjects(Object[] objects) {
        this.insertSelectedObjectsAt(objects, this.getSelectedObjectCount());
    }

    @Override
    public void addSelectionListener(SelectionListener l) {
        if (l != null) {
            this.getSelectionListenerList().add((Object)l);
        }
    }

    protected synchronized void fireSelectionChanged(SelectionEvent ev) {
        for (SelectionListener l : (SelectionListener[])this.getSelectionListenerList().array()) {
            l.selectionChanged(ev);
        }
    }

    @Override
    public Class getSelectedClassAt(int i) {
        return ((ObjectType)this.types.get((int)i)).type;
    }

    @Override
    public int getSelectedClassCount() {
        return this.types.size();
    }

    @Override
    public void getSelectedClasses(Collection dst) {
        int count = this.types.size();
        for (int c = 0; c < count; ++c) {
            dst.add(((ObjectType)this.types.get((int)c)).type);
        }
    }

    @Override
    public Object getSelectedObjectAt(int i) {
        return this.objects.get(i);
    }

    @Override
    public int getSelectedObjectCount() {
        return this.objects.size();
    }

    @Override
    public void getSelectedObjects(Collection dst) {
        dst.addAll(this.objects);
    }

    @Override
    public int getSelectionCount() {
        return this.objects.size();
    }

    protected ListenerList<SelectionListener> getSelectionListenerList() {
        if (this.selectionListenerList == null) {
            this.setSelectionListenerList((ListenerList<SelectionListener>)new ListenerList(SelectionListener.class));
        }
        return this.selectionListenerList;
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    private ObjectType insert(Object o, int i) {
        Class<?> t;
        this.objects.add(i, o);
        ObjectType ot = null;
        if (o != null && (t = o.getClass()) != null) {
            ot = (ObjectType)this.classes.get(t);
            if (ot == null) {
                ot = new ObjectType();
                ot.type = t;
                this.classes.put(t, ot);
                this.types.add(ot);
            }
            ++ot.count;
        }
        return ot;
    }

    protected synchronized void insertSelectedObjectAt(Object o, int i) {
        ObjectType ot = this.insert(o, i);
        Class[] classes = ot != null && ot.count == 1 ? new Class[]{ot.type} : new Class[]{};
        this.fireSelectionChanged(new SelectionEvent(1, new Object[]{o}, new int[]{i}, classes));
    }

    protected synchronized void insertSelectedObjectsAt(Object[] o, int[] i) {
        ArrayList<ObjectType> ots = new ArrayList<ObjectType>();
        int count = o.length;
        for (int c = 0; c < count; ++c) {
            ObjectType ot = this.insert(o[c], i[c]);
            if (ot == null || ot.count != 1 || ots.contains(ot)) continue;
            ots.add(ot);
        }
        Class[] classes = new Class[ots.size()];
        for (int c = 0; c < classes.length; ++c) {
            classes[c] = ((ObjectType)ots.get((int)c)).type;
        }
        this.fireSelectionChanged(new SelectionEvent(1, o, i, classes));
    }

    protected synchronized void insertSelectedObjectsAt(Object[] o, int i) {
        ArrayList<ObjectType> ots = new ArrayList<ObjectType>();
        int count = o.length;
        int[] ix = new int[count];
        int c = 0;
        while (c < count) {
            ix[c] = i;
            ObjectType ot = this.insert(o[c], i);
            if (ot != null && ot.count == 1 && !ots.contains(ot)) {
                ots.add(ot);
            }
            ++c;
            ++i;
        }
        Class[] classes = new Class[ots.size()];
        for (int c2 = 0; c2 < classes.length; ++c2) {
            classes[c2] = ((ObjectType)ots.get((int)c2)).type;
        }
        this.fireSelectionChanged(new SelectionEvent(1, o, ix, classes));
    }

    @Override
    public boolean isSelectedClass(Class type) {
        ObjectType ot = (ObjectType)this.classes.get(type);
        if (ot != null) {
            return ot.count > 0;
        }
        return false;
    }

    @Override
    public boolean isSelectedObject(Object o) {
        return this.objects.contains(o);
    }

    protected int getSelectedObjectIndex(Object o) {
        return this.objects.indexOf(o);
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.objects.isEmpty();
    }

    private ObjectType remove(Object o, int i) {
        Class<?> t;
        this.objects.remove(i);
        ObjectType ot = null;
        if (o != null && (t = o.getClass()) != null && (ot = (ObjectType)this.classes.get(t)) != null) {
            --ot.count;
            if (ot.count < 1) {
                this.classes.remove(t);
                this.types.remove(ot);
            }
        }
        return ot;
    }

    protected synchronized void removeSelectedObject(Object o) {
        int index = this.objects.indexOf(o);
        if (index >= 0) {
            this.removeSelectedObjectAt(index);
        }
    }

    protected synchronized void removeSelectedObjectAt(int i) {
        Object o = this.objects.get(i);
        ObjectType ot = this.remove(o, i);
        Class[] classes = ot != null && ot.count < 1 ? new Class[]{ot.type} : new Class[]{};
        this.fireSelectionChanged(new SelectionEvent(-1, new Object[]{o}, new int[]{i}, classes));
    }

    protected synchronized void removeSelectedObjectsAt(int[] i) {
        int c;
        int count = i.length;
        ArrayList<ObjectType> ots = new ArrayList<ObjectType>();
        Object[] o = new Object[count];
        for (c = 0; c < count; ++c) {
            o[c] = this.objects.get(i[c]);
        }
        for (c = count - 1; c >= 0; --c) {
            ObjectType ot = this.remove(o[c], i[c]);
            if (ot == null || ot.count != 0) continue;
            ots.add(ot);
        }
        Class[] classes = new Class[ots.size()];
        for (int c2 = 0; c2 < classes.length; ++c2) {
            classes[c2] = ((ObjectType)ots.get((int)c2)).type;
        }
        this.fireSelectionChanged(new SelectionEvent(-1, o, i, classes));
    }

    protected synchronized void clearSelection() {
        int num = this.objects.size();
        if (num < 1) {
            return;
        }
        Object[] o = new Object[num];
        int[] i = new int[num];
        for (int c = 0; c < num; ++c) {
            o[c] = this.objects.get(c);
            i[c] = c;
        }
        this.objects.clear();
        Class[] classArray = this.classes.keySet().toArray(new Class[this.classes.size()]);
        this.classes.clear();
        this.types.clear();
        this.fireSelectionChanged(new SelectionEvent(-1, o, i, classArray));
    }

    @Override
    public void removeSelectionListener(SelectionListener l) {
        if (l != null) {
            this.getSelectionListenerList().remove((Object)l);
        }
    }

    protected void setSelectionListenerList(ListenerList<SelectionListener> newSelectionListenerList) {
        this.selectionListenerList = newSelectionListenerList;
    }

    protected void setSource(Object newSource) {
        this.source = newSource;
    }

    @Override
    public int cutSelectedObjects() {
        int sel = this.getSelectionCount();
        int copy = this.copySelectedObjects();
        if (copy < sel) {
            return 0;
        }
        int del = this.removeSelectedObjects();
        return del;
    }

    protected class ObjectType {
        public Class type = null;
        public int count = 0;

        protected ObjectType() {
        }
    }
}

