/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextServiceAvailableEvent;
import java.beans.beancontext.BeanContextServiceRevokedEvent;
import java.beans.beancontext.BeanContextServicesListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class DefaultBeanContextChild
implements BeanContextChild,
BeanContextServicesListener,
Serializable {
    static final long serialVersionUID = 6328947014421475877L;
    public BeanContextChild beanContextChildPeer;
    protected transient PropertyChangeSupport pcSupport;
    protected transient VetoableChangeSupport vcSupport;
    protected transient BeanContext beanContext;
    protected transient boolean rejectedSetBCOnce;

    public DefaultBeanContextChild() {
        this.beanContextChildPeer = this;
    }

    public DefaultBeanContextChild(BeanContextChild bcc) {
        this.beanContextChildPeer = bcc != null ? bcc : this;
    }

    @Override
    public synchronized void setBeanContext(BeanContext bc) throws PropertyVetoException {
        if (bc == this.beanContext) {
            return;
        }
        BeanContext oldValue = this.beanContext;
        BeanContext newValue = bc;
        if (!this.rejectedSetBCOnce) {
            this.rejectedSetBCOnce = !this.validatePendingSetBeanContext(bc);
            if (this.rejectedSetBCOnce) {
                throw new PropertyVetoException("setBeanContext() change rejected:", new PropertyChangeEvent(this.beanContextChildPeer, "beanContext", oldValue, newValue));
            }
            try {
                this.fireVetoableChange("beanContext", oldValue, newValue);
            }
            catch (PropertyVetoException pve) {
                this.rejectedSetBCOnce = true;
                throw pve;
            }
        }
        if (this.beanContext != null) {
            this.releaseBeanContextResources();
        }
        this.beanContext = newValue;
        this.rejectedSetBCOnce = false;
        this.firePropertyChange("beanContext", oldValue, newValue);
        if (this.beanContext != null) {
            this.initializeBeanContextResources();
        }
    }

    @Override
    public synchronized BeanContext getBeanContext() {
        return this.beanContext;
    }

    @Override
    public void addPropertyChangeListener(String name, PropertyChangeListener pcl) {
        this.getPcSupport().addPropertyChangeListener(name, pcl);
    }

    @Override
    public void removePropertyChangeListener(String name, PropertyChangeListener pcl) {
        if (this.pcSupport != null) {
            this.pcSupport.removePropertyChangeListener(name, pcl);
        }
    }

    @Override
    public void addVetoableChangeListener(String name, VetoableChangeListener vcl) {
        this.getVcSupport().addVetoableChangeListener(name, vcl);
    }

    @Override
    public void removeVetoableChangeListener(String name, VetoableChangeListener vcl) {
        if (this.vcSupport != null) {
            this.vcSupport.removeVetoableChangeListener(name, vcl);
        }
    }

    @Override
    public void serviceRevoked(BeanContextServiceRevokedEvent bcsre) {
    }

    @Override
    public void serviceAvailable(BeanContextServiceAvailableEvent bcsae) {
    }

    public BeanContextChild getBeanContextChildPeer() {
        return this.beanContextChildPeer;
    }

    public boolean isDelegated() {
        return !this.equals(this.beanContextChildPeer);
    }

    public void firePropertyChange(String name, Object oldValue, Object newValue) {
        if (this.pcSupport != null) {
            this.pcSupport.firePropertyChange(name, oldValue, newValue);
        }
    }

    public void fireVetoableChange(String name, Object oldValue, Object newValue) throws PropertyVetoException {
        if (this.vcSupport != null) {
            this.vcSupport.fireVetoableChange(name, oldValue, newValue);
        }
    }

    public boolean validatePendingSetBeanContext(BeanContext newValue) {
        return true;
    }

    protected void releaseBeanContextResources() {
    }

    protected void initializeBeanContextResources() {
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
    }

    protected PropertyChangeSupport getPcSupport() {
        if (this.pcSupport == null) {
            this.pcSupport = new PropertyChangeSupport(this.beanContextChildPeer);
        }
        return this.pcSupport;
    }

    void setPcSupport(PropertyChangeSupport pcSupport) {
        this.pcSupport = pcSupport;
    }

    protected VetoableChangeSupport getVcSupport() {
        if (this.vcSupport == null) {
            this.vcSupport = new VetoableChangeSupport(this.beanContextChildPeer);
        }
        return this.vcSupport;
    }

    void setVcSupport(VetoableChangeSupport vcSupport) {
        this.vcSupport = vcSupport;
    }
}

