/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans;

import com.spacekiller.util.FileLink;
import com.spacekiller.util.FileType;
import com.spacekiller.util.FileTypeRegistry;
import com.spacekiller.util.Platform;
import com.spacekiller.util.beans.IconProvider;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

public class FileIconProvider
implements IconProvider {
    private static final int DEFAULT_CACHE_SIZE = 512;
    private Icon fileIcon;
    private Icon fileNotFoundIcon;
    private Icon directoryIcon;
    private Icon directoryNotFoundIcon;
    private Icon rootIcon;
    private Icon rootNotFoundIcon;
    private Class[] beanTypes;
    private FileTypeRegistry registry;
    private boolean cacheEnabled;
    private Map cache;
    private int cacheSize = 512;
    private CacheEntry firstEntry;
    private CacheEntry lastEntry;

    public FileIconProvider() {
        this.setCacheEnabled(true);
    }

    @Override
    public Icon getIcon(Object bean, int iconKind) {
        if (bean == null) {
            return null;
        }
        if (bean instanceof FileLink) {
            return this.getFileIcon(((FileLink)bean).getFile(), iconKind);
        }
        if (bean instanceof File) {
            return this.getFileIcon((File)bean, iconKind);
        }
        return null;
    }

    protected synchronized Icon getFileIcon(File file, int iconKind) {
        CacheEntry ce;
        if (file == null) {
            return null;
        }
        String filePath = file.getPath();
        Map cache = this.cache;
        if (cache != null && (ce = (CacheEntry)cache.get(filePath)) != null) {
            if (ce != this.firstEntry) {
                ce.prev.next = ce.next;
                if (ce.next == null) {
                    this.lastEntry = ce.prev;
                } else {
                    ce.next.prev = ce.prev;
                }
                ce.prev = null;
                ce.next = this.firstEntry;
                if (this.firstEntry == null) {
                    this.lastEntry = ce;
                } else {
                    this.firstEntry.prev = ce;
                }
                this.firstEntry = ce;
            }
            return ce.icon;
        }
        Icon icon = null;
        if (file.getParentFile() == null) {
            icon = file.exists() ? this.rootIcon : this.rootNotFoundIcon;
        } else if (file.exists()) {
            if (file.isDirectory()) {
                icon = this.directoryIcon;
            } else {
                FileType fileType;
                FileTypeRegistry reg = this.getRegistry();
                if (reg != null && (fileType = reg.getFileType(file)) != null) {
                    icon = fileType.getIcon(file, iconKind);
                }
                if (icon == null) {
                    icon = this.fileIcon;
                }
            }
        } else {
            boolean isFile = false;
            try {
                isFile = file.isFile();
            }
            catch (Exception e) {
                // empty catch block
            }
            Icon icon2 = icon = isFile ? this.fileNotFoundIcon : this.directoryNotFoundIcon;
        }
        if (icon != null && cache != null) {
            for (int size = cache.size(); size >= this.cacheSize; --size) {
                if (this.lastEntry == null) continue;
                String path = this.lastEntry.path;
                if (this.lastEntry.prev == null) {
                    this.firstEntry = null;
                } else {
                    this.lastEntry.prev.next = null;
                }
                this.lastEntry = this.lastEntry.prev;
                cache.remove(path);
            }
            CacheEntry entry = new CacheEntry();
            entry.path = filePath;
            entry.icon = icon;
            entry.prev = null;
            entry.next = this.firstEntry;
            if (this.firstEntry == null) {
                this.lastEntry = entry;
            } else {
                this.firstEntry.prev = entry;
            }
            this.firstEntry = entry;
            cache.put(filePath, entry);
        }
        return icon;
    }

    public Icon getDirectoryIcon() {
        return this.directoryIcon;
    }

    public void setDirectoryIcon(Icon directoryIcon) {
        this.directoryIcon = directoryIcon;
    }

    public Icon getFileIcon() {
        return this.fileIcon;
    }

    public void setFileIcon(Icon fileIcon) {
        this.fileIcon = fileIcon;
    }

    @Override
    public Class[] getBeanTypes() {
        return this.beanTypes;
    }

    public void setBeanTypes(Class[] beanTypes) {
        this.beanTypes = beanTypes;
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public synchronized void setCacheEnabled(boolean newCacheEnabled) {
        if (this.cacheEnabled == newCacheEnabled) {
            return;
        }
        this.cacheEnabled = newCacheEnabled;
        if (this.cacheEnabled) {
            this.cache = new HashMap();
            this.firstEntry = null;
            this.lastEntry = null;
        } else {
            this.cache = null;
            this.firstEntry = null;
            this.lastEntry = null;
        }
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public Icon getRootIcon() {
        return this.rootIcon;
    }

    public void setRootIcon(Icon rootIcon) {
        this.rootIcon = rootIcon;
    }

    public Icon getDirectoryNotFoundIcon() {
        return this.directoryNotFoundIcon;
    }

    public void setDirectoryNotFoundIcon(Icon directoryNotFoundIcon) {
        this.directoryNotFoundIcon = directoryNotFoundIcon;
    }

    public Icon getFileNotFoundIcon() {
        return this.fileNotFoundIcon;
    }

    public void setFileNotFoundIcon(Icon fileNotFoundIcon) {
        this.fileNotFoundIcon = fileNotFoundIcon;
    }

    public Icon getRootNotFoundIcon() {
        return this.rootNotFoundIcon;
    }

    public void setRootNotFoundIcon(Icon rootNotFoundIcon) {
        this.rootNotFoundIcon = rootNotFoundIcon;
    }

    public FileTypeRegistry getRegistry() {
        if (this.registry == null) {
            this.setRegistry(Platform.getInstance().getFileTypeRegistry());
        }
        return this.registry;
    }

    public void setRegistry(FileTypeRegistry registry) {
        this.registry = registry;
    }

    protected static class CacheEntry {
        public String path;
        public Icon icon;
        public CacheEntry prev;
        public CacheEntry next;

        protected CacheEntry() {
        }
    }
}

