/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans;

import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

public class IconCache {
    private int kinds;
    private Map[] cache;

    public IconCache(int kinds) {
        if (kinds < 1) {
            kinds = 1;
        }
        this.kinds = kinds;
        this.cache = new Map[kinds];
        for (int c = 0; c < kinds; ++c) {
            this.cache[c] = new HashMap();
        }
    }

    public Icon getIcon(Object key, int kind) {
        if (kind >= 0 && kind < this.kinds) {
            return (Icon)this.cache[kind].get(key);
        }
        return null;
    }

    public void putIcon(Object key, int kind, Icon icon) {
        if (kind >= 0 && kind < this.kinds && key != null && icon != null) {
            this.cache[kind].put(key, icon);
        }
    }

    public void removeIcon(Object key, int kind) {
        if (kind >= 0 && kind < this.kinds) {
            this.cache[kind].remove(key);
        }
    }

    public void clear() {
        for (int c = 0; c < this.cache.length; ++c) {
            this.cache[c].clear();
        }
    }
}

