/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans;

import com.spacekiller.util.Data;
import com.spacekiller.util.beans.Property;
import com.spacekiller.util.beans.PropertyMap;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PropertyHashMap
implements PropertyMap {
    private Map props = new HashMap();

    public void addProperty(String name, Property p) {
        if (p != null && !this.props.containsValue(p)) {
            this.props.put(name, p);
        }
    }

    public boolean getBoolean(String key) throws InvocationTargetException, IllegalAccessException {
        return (Boolean)this.getValue(key);
    }

    public byte getByte(String key) throws InvocationTargetException, IllegalAccessException {
        return (Byte)this.getValue(key);
    }

    public char getChar(String key) throws IllegalAccessException, InvocationTargetException {
        return ((Character)this.getValue(key)).charValue();
    }

    public double getDouble(String key) throws InvocationTargetException, IllegalAccessException {
        return (Double)this.getValue(key);
    }

    public float getFloat(String key) throws InvocationTargetException, IllegalAccessException {
        return ((Float)this.getValue(key)).floatValue();
    }

    public int getInt(String key) throws InvocationTargetException, IllegalAccessException {
        return (Integer)this.getValue(key);
    }

    public long getLong(String key) throws InvocationTargetException, IllegalAccessException {
        return (Long)this.getValue(key);
    }

    public Object getObject(String key) throws InvocationTargetException, IllegalAccessException {
        return this.getValue(key);
    }

    @Override
    public Property[] getProperties() {
        Collection coll = this.props.values();
        return coll.toArray(new Property[coll.size()]);
    }

    @Override
    public Property getProperty(String name) {
        return (Property)this.props.get(name);
    }

    @Override
    public int getPropertyCount() {
        return this.props.size();
    }

    @Override
    public String[] getPropertyNames() {
        Set keys = this.props.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    public short getShort(String key) throws InvocationTargetException, IllegalAccessException {
        return (Short)this.getValue(key);
    }

    protected Object getValue(String property) throws InvocationTargetException, IllegalAccessException {
        Property prop = this.getProperty(property);
        if (prop == null) {
            throw new IllegalAccessException("Property not found: " + property);
        }
        return prop.getValue();
    }

    public String[] propertyNames() {
        return this.getPropertyNames();
    }

    public boolean contains(String key) {
        return this.props.containsKey(key);
    }

    public void removeAllProperties() {
        Set keys = this.props.keySet();
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            this.removeProperty((String)i.next());
        }
    }

    public void removeProperty(String name) {
        this.props.remove(name);
    }

    public void setBoolean(String key, boolean value) throws InvocationTargetException, IllegalAccessException, PropertyVetoException {
        this.setValue(key, Data.toBoolean((boolean)value));
    }

    public void setByte(String key, byte value) throws InvocationTargetException, IllegalAccessException, PropertyVetoException {
        this.setValue(key, Data.toByte((byte)value));
    }

    public void setChar(String key, char value) throws IllegalAccessException, InvocationTargetException, PropertyVetoException {
        this.setValue(key, Data.toCharacter((char)value));
    }

    public void setDouble(String key, double value) throws InvocationTargetException, IllegalAccessException, PropertyVetoException {
        this.setValue(key, Data.toDouble((double)value));
    }

    public void setFloat(String key, float value) throws InvocationTargetException, IllegalAccessException, PropertyVetoException {
        this.setValue(key, Data.toFloat((float)value));
    }

    public void setInt(String key, int value) throws InvocationTargetException, IllegalAccessException, PropertyVetoException {
        this.setValue(key, Data.toInteger((int)value));
    }

    public void setLong(String key, long value) throws InvocationTargetException, IllegalAccessException, PropertyVetoException {
        this.setValue(key, Data.toLong((long)value));
    }

    public void setObject(String key, Object value) throws InvocationTargetException, IllegalAccessException, PropertyVetoException {
        this.setValue(key, value);
    }

    public void setShort(String key, short value) throws InvocationTargetException, IllegalAccessException, PropertyVetoException {
        this.setValue(key, Data.toShort((short)value));
    }

    protected void setValue(String property, Object value) throws InvocationTargetException, IllegalAccessException, PropertyVetoException {
        Property prop = this.getProperty(property);
        if (prop == null) {
            throw new IllegalAccessException("Property not found: " + property);
        }
        prop.setValue(value);
    }
}

