/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.render;

import com.spacekiller.util.render.CharIterator;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import javax.swing.JComponent;
import javax.swing.SwingConstants;

public class CharLabel
extends JComponent
implements SwingConstants {
    private static final long serialVersionUID = -8654174745260697279L;
    private static final char[] EMPTY = new char[0];
    private Point point;
    private AttributedCharacterIterator text;
    private boolean antiAliasing;

    public CharLabel() {
        this.point = new Point();
        this.text = new CharIterator(EMPTY, 0, 0);
    }

    public CharLabel(Point point, AttributedCharacterIterator text) {
        this.setPoint(point);
        this.setText(text);
    }

    public AttributedCharacterIterator getText() {
        return this.text;
    }

    public void setText(AttributedCharacterIterator text) {
        if (text == null) {
            throw new NullPointerException();
        }
        this.text = text;
    }

    public Point getPoint() {
        return this.point;
    }

    public void setPoint(Point point) {
        if (point == null) {
            throw new NullPointerException();
        }
        this.point = point;
    }

    public boolean isAntiAliasing() {
        return this.antiAliasing;
    }

    public void setAntiAliasing(boolean antiAliasing) {
        this.antiAliasing = antiAliasing;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.text.getEndIndex() > this.text.getBeginIndex()) {
            Graphics2D g2 = (Graphics2D)g;
            if (this.antiAliasing) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            TextLayout tl = new TextLayout(this.text, g2.getFontRenderContext());
            tl.draw(g2, this.point.x, this.point.y);
        }
    }
}

